/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Identifier<T> {
    private String fStringIdentifier;
    private Class<T> fType;

    public static <T> Identifier<T> create(Class<T> type, String stringIdentifier) {
        return new Identifier<T>(stringIdentifier, type);
    }

    private Identifier(String stringIdentifier, Class<T> type) {
        Assert.isNotNull((Object)stringIdentifier);
        Assert.isTrue((!"".equals(stringIdentifier) ? 1 : 0) != 0);
        Assert.isNotNull(type);
        this.fStringIdentifier = stringIdentifier;
        this.fType = type;
    }

    public String getStringIdentifier() {
        return this.fStringIdentifier;
    }

    public Class<T> getType() {
        return this.fType;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Identifier other = (Identifier)obj;
        return other.fType.equals(this.fType) && other.fStringIdentifier.equals(this.fStringIdentifier);
    }

    public int hashCode() {
        return 17 * this.fStringIdentifier.hashCode() + this.fType.hashCode();
    }

    public String toString() {
        return String.valueOf(this.fType.getName()) + ":" + this.fStringIdentifier;
    }

    public static <T> void assertSameType(Class<T> type, Identifier<T> identifier) {
        Assert.isTrue((identifier == null || type.equals(identifier.fType) || InternalType.class.equals(identifier.fType) ? 1 : 0) != 0);
    }

    private static class InternalType {
        private InternalType() {
        }
    }
}

