/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import com.ibm.team.links.common.IReference;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.internal.model.CategoryAttributeType;
import com.ibm.team.workitem.common.internal.model.ContributorAttributeType;
import com.ibm.team.workitem.common.internal.model.DeliverableAttributeType;
import com.ibm.team.workitem.common.internal.model.EnumerationAttributeType;
import com.ibm.team.workitem.common.internal.model.HTMLAttributeType;
import com.ibm.team.workitem.common.internal.model.IterationAttributeType;
import com.ibm.team.workitem.common.internal.model.NumericAttributeType;
import com.ibm.team.workitem.common.internal.model.SetAttributeType;
import com.ibm.team.workitem.common.internal.model.SimpleAttributeType;
import com.ibm.team.workitem.common.internal.model.TimestampAttributeType;
import com.ibm.team.workitem.common.internal.model.TypeAttributeType;
import com.ibm.team.workitem.common.model.ApprovalStateAttributeType;
import com.ibm.team.workitem.common.model.ApprovalTypeAttributeType;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovals;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IComments;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IPriority;
import com.ibm.team.workitem.common.model.ISeverity;
import com.ibm.team.workitem.common.model.ISubscriptions;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.TagsAttributeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeTypes {
    public static final String SMALL_STRING = "smallString";
    public static final String MEDIUM_STRING = "mediumString";
    public static final String LARGE_STRING = "string";
    public static final String MEDIUM_HTML = "mediumHtml";
    public static final String LARGE_HTML = "html";
    public static final String TIMESTAMP = "timestamp";
    public static final String PROJECT_AREA = "projectArea";
    public static final String TEAM_AREA = "teamArea";
    public static final String CATEGORY = "category";
    public static final String PRIORITY = "priority";
    public static final String ITERATION = "interval";
    public static final String CONTRIBUTOR = "contributor";
    public static final String INTEGER = "integer";
    public static final String FLOAT = "float";
    public static final String SEVERITY = "severity";
    public static final String DELIVERABLE = "deliverable";
    public static final String LONG = "long";
    public static final String BOOLEAN = "boolean";
    public static final String COMMENTS = "comments";
    public static final String SUBSCRIPTIONS = "subscriptions";
    public static final String APPROVAL_DESCRIPTORS = "approvalDescriptors";
    public static final String APPROVALS = "approvals";
    public static final String WORK_ITEM = "workItem";
    public static final String TAGS = "tags";
    public static final String TYPE = "type";
    public static final String CUSTOM_ATTRIBUTE = "customAttribute";
    public static final String APPROVAL_STATE = "approvalState";
    public static final String APPROVAL_TYPE = "approvalType";
    public static final String DURATION = "duration";
    public static final String CONTENT = "content";
    public static final String FILE_SIZE = "fileSize";
    public static final String REFERENCE = "reference";
    public static final List<String> STRING_TYPES = Arrays.asList("smallString", "mediumString", "string");
    public static final List<String> HTML_TYPES = Arrays.asList("mediumHtml", "html");
    public static final List<String> NUMBER_TYPES = Arrays.asList("integer", "long", "float");
    private static final AttributeType SMALL_STRING_TYPE = new SimpleAttributeType("smallString", String.class, new AttributeOperation[]{AttributeOperation.CONTAINS, AttributeOperation.NOT_CONTAINS, AttributeOperation.MATCHES, AttributeOperation.NOT_MATCHES, AttributeOperation.STARTS_WITH, AttributeOperation.ENDS_WITH}, "", null, "_meta");
    private static final AttributeType MEDIUM_STRING_TYPE = new SimpleAttributeType("mediumString", String.class, new AttributeOperation[]{AttributeOperation.CONTAINS, AttributeOperation.NOT_CONTAINS, AttributeOperation.MATCHES, AttributeOperation.NOT_MATCHES, AttributeOperation.STARTS_WITH, AttributeOperation.ENDS_WITH}, "", null, "_meta");
    private static final AttributeType LARGE_STRING_TYPE = new SimpleAttributeType("string", String.class, new AttributeOperation[0], "", null, "_meta");
    private static final AttributeType MEDIUM_HTML_TYPE = new HTMLAttributeType("mediumHtml", String.class, new AttributeOperation[]{AttributeOperation.CONTAINS, AttributeOperation.NOT_CONTAINS, AttributeOperation.STARTS_WITH, AttributeOperation.ENDS_WITH}, "", null, "_meta");
    private static final AttributeType LARGE_HTML_TYPE = new HTMLAttributeType("html", String.class, new AttributeOperation[0], "", null, "_meta");
    private static final AttributeType TIMESTAMP_TYPE = new TimestampAttributeType("timestamp");
    private static final AttributeType PROJECT_AREA_TYPE = new SetAttributeType("projectArea", IProjectAreaHandle.class, ItemProfile.PROJECT_AREA_DEFAULT, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS}, new String[0]);
    private static final AttributeType TEAM_AREA_TYPE = new SetAttributeType("teamArea", ITeamAreaHandle.class, ItemProfile.TEAM_AREA_DEFAULT, new AttributeOperation[]{AttributeOperation.TEAM_AREA_EQUALS, AttributeOperation.TEAM_AREA_NOT_EQUALS}, new String[0]);
    private static final AttributeType CATEGORY_TYPE = new CategoryAttributeType("category");
    private static final AttributeType ITERATION_TYPE = new IterationAttributeType("interval");
    private static final AttributeType PRIORITY_TYPE = new EnumerationAttributeType("priority", IPriority.class);
    private static final AttributeType CONTRIBUTOR_TYPE = new ContributorAttributeType("contributor");
    private static final AttributeType INTEGER_TYPE = new NumericAttributeType("integer", Integer.class, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS, AttributeOperation.GREATER_OR_EQUALS, AttributeOperation.SMALLER_OR_EQUALS}, new Integer(0));
    private static final AttributeType FLOAT_TYPE = new NumericAttributeType("float", Float.class, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS, AttributeOperation.GREATER_OR_EQUALS, AttributeOperation.SMALLER_OR_EQUALS}, new Float(0.0f));
    private static final AttributeType SEVERITY_TYPE = new EnumerationAttributeType("severity", ISeverity.class);
    private static final AttributeType DELIVERABLE_TYPE = new DeliverableAttributeType("deliverable");
    private static final AttributeType LONG_TYPE = new NumericAttributeType("long", Long.class, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS, AttributeOperation.GREATER_OR_EQUALS, AttributeOperation.SMALLER_OR_EQUALS}, new Long(0L));
    private static final AttributeType BOOLEAN_TYPE = new SimpleAttributeType("boolean", Boolean.class, new AttributeOperation[]{AttributeOperation.EQUALS}, false, new Object[]{false, true}, "");
    private static final AttributeType COMMENTS_TYPE = new AttributeType("comments", IComments.class, new AttributeOperation[]{AttributeOperation.AUTHORED_BY}, new String[]{"currentUser"}, "_content");
    private static final AttributeType SUBSCRIPTIONS_TYPE = new AttributeType("subscriptions", ISubscriptions.class, new AttributeOperation[]{AttributeOperation.CONTAINING, AttributeOperation.NOT_CONTAINING}, new String[]{"currentUser"}, "");
    private static final AttributeType APPROVAL_DESCRIPTORS_TYPE = new AttributeType("approvalDescriptors", IApprovalDescriptor.class, new AttributeOperation[0], new String[0], "_meta");
    private static final AttributeType APPROVALS_TYPE = new AttributeType("approvals", IApprovals.class, new AttributeOperation[]{AttributeOperation.TO_BE_APPROVED_BY, AttributeOperation.APPROVED_BY, AttributeOperation.REJECTED_BY, AttributeOperation.INVOLVES}, new String[]{"currentUser", "anyone"}, "_meta");
    private static final AttributeType WORK_ITEM_TYPE = new AttributeType("workItem", IWorkItemHandle.class, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS});
    private static final AttributeType TAGS_TYPE = new TagsAttributeType("tags");
    private static final AttributeType TYPE_TYPE = new TypeAttributeType("type", (Class)String.class, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS});
    private static final AttributeType APPROVAL_STATE_TYPE = new ApprovalStateAttributeType("approvalState");
    private static final AttributeType APPROVAL_TYPE_TYPE = new ApprovalTypeAttributeType("approvalType");
    private static final AttributeType DURATION_TYPE = new SimpleAttributeType("duration", Long.class, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS, AttributeOperation.GREATER_OR_EQUALS, AttributeOperation.SMALLER_OR_EQUALS}, Duration.UNSPECIFIED.longValue(), null, "");
    private static final AttributeType CUSTOM_ATTRIBUTE_TYPE = new AttributeType("customAttribute", IAttributeHandle.class, new AttributeOperation[]{AttributeOperation.CONTAINING, AttributeOperation.NOT_CONTAINING}, new String[0], "");
    private static final AttributeType CONTENT_TYPE = new AttributeType("content", IContent.class, new AttributeOperation[0], new String[0], "");
    private static final AttributeType FILE_SIZE_TYPE = new AttributeType("fileSize", Long.class, new AttributeOperation[]{AttributeOperation.GREATER_OR_EQUALS, AttributeOperation.SMALLER_OR_EQUALS}, new String[0], "");
    private static final AttributeType REFERENCE_TYPE = new SimpleAttributeType("reference", IReference.class, new AttributeOperation[]{AttributeOperation.LINK_EXISTS}, "", null, "");
    private static final List<String> CUSTOM_ATTRIBUTE_TYPES = Arrays.asList("smallString", "mediumString", "string", "mediumHtml", "html", "integer", "long", "boolean", "timestamp");
    private static final Map<String, AttributeType> fgRegistry = new HashMap<String, AttributeType>();

    static {
        fgRegistry.put(SMALL_STRING, SMALL_STRING_TYPE);
        fgRegistry.put(MEDIUM_STRING, MEDIUM_STRING_TYPE);
        fgRegistry.put(LARGE_STRING, LARGE_STRING_TYPE);
        fgRegistry.put(MEDIUM_HTML, MEDIUM_HTML_TYPE);
        fgRegistry.put(LARGE_HTML, LARGE_HTML_TYPE);
        fgRegistry.put(TIMESTAMP, TIMESTAMP_TYPE);
        fgRegistry.put(PROJECT_AREA, PROJECT_AREA_TYPE);
        fgRegistry.put(TEAM_AREA, TEAM_AREA_TYPE);
        fgRegistry.put(CATEGORY, CATEGORY_TYPE);
        fgRegistry.put(ITERATION, ITERATION_TYPE);
        fgRegistry.put(PRIORITY, PRIORITY_TYPE);
        fgRegistry.put(CONTRIBUTOR, CONTRIBUTOR_TYPE);
        fgRegistry.put(INTEGER, INTEGER_TYPE);
        fgRegistry.put(FLOAT, FLOAT_TYPE);
        fgRegistry.put(SEVERITY, SEVERITY_TYPE);
        fgRegistry.put(DELIVERABLE, DELIVERABLE_TYPE);
        fgRegistry.put(LONG, LONG_TYPE);
        fgRegistry.put(BOOLEAN, BOOLEAN_TYPE);
        fgRegistry.put(COMMENTS, COMMENTS_TYPE);
        fgRegistry.put(SUBSCRIPTIONS, SUBSCRIPTIONS_TYPE);
        fgRegistry.put(APPROVAL_DESCRIPTORS, APPROVAL_DESCRIPTORS_TYPE);
        fgRegistry.put(APPROVALS, APPROVALS_TYPE);
        fgRegistry.put(WORK_ITEM, WORK_ITEM_TYPE);
        fgRegistry.put(TAGS, TAGS_TYPE);
        fgRegistry.put(TYPE, TYPE_TYPE);
        fgRegistry.put(APPROVAL_STATE, APPROVAL_STATE_TYPE);
        fgRegistry.put(APPROVAL_TYPE, APPROVAL_TYPE_TYPE);
        fgRegistry.put(DURATION, DURATION_TYPE);
        fgRegistry.put(CUSTOM_ATTRIBUTE, CUSTOM_ATTRIBUTE_TYPE);
        fgRegistry.put(CONTENT, CONTENT_TYPE);
        fgRegistry.put(FILE_SIZE, FILE_SIZE_TYPE);
        fgRegistry.put(REFERENCE, REFERENCE_TYPE);
    }

    public static AttributeType getAttributeType(String attributeTypeIdentifier) {
        AttributeType attributeType = fgRegistry.get(attributeTypeIdentifier);
        if (attributeType == null) {
            attributeType = new EnumerationAttributeType(attributeTypeIdentifier, ILiteral.class);
            fgRegistry.put(attributeTypeIdentifier, attributeType);
        }
        return attributeType;
    }

    public static List<AttributeType> getAttributeTypes() {
        return new ArrayList<AttributeType>(fgRegistry.values());
    }

    public static boolean isEnumerationAttributeType(String attributeTypeIdentifier) {
        return AttributeTypes.getAttributeType(attributeTypeIdentifier) instanceof EnumerationAttributeType;
    }

    public static boolean isPrimitiveAttributeType(String attributeTypeIdentifier) {
        AttributeType type = AttributeTypes.getAttributeType(attributeTypeIdentifier);
        return type instanceof SimpleAttributeType || type instanceof NumericAttributeType || type instanceof TimestampAttributeType || type instanceof TagsAttributeType;
    }

    public static boolean isItemAttributeType(String attributeTypeIdentifier) {
        AttributeType type = AttributeTypes.getAttributeType(attributeTypeIdentifier);
        return IItemHandle.class.isAssignableFrom(type.getInstanceType());
    }

    public static boolean isSupportedCustomAttributeType(String attributeTypeIdentifier) {
        if (CUSTOM_ATTRIBUTE_TYPES.contains(attributeTypeIdentifier)) {
            return true;
        }
        return AttributeTypes.isEnumerationAttributeType(attributeTypeIdentifier);
    }
}

