/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import com.ibm.team.links.internal.links.LinksPackage;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IQuery;
import com.ibm.team.repository.common.query.ast.IBoolean;
import com.ibm.team.repository.common.query.ast.IBooleanField;
import com.ibm.team.repository.common.query.ast.IDateTime;
import com.ibm.team.repository.common.query.ast.IDateTimeField;
import com.ibm.team.repository.common.query.ast.IDynamicQueryModel;
import com.ibm.team.repository.common.query.ast.IEnum;
import com.ibm.team.repository.common.query.ast.IEnumField;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IManyItemQueryModel;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.INumericField;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.ISingleItemQueryModel;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IStringField;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.query.ast.IUUIDField;
import com.ibm.team.workitem.common.expression.variables.TimeSpan;
import com.ibm.team.workitem.common.internal.expression.ITransformationContext;
import com.ibm.team.workitem.common.internal.model.Category;
import com.ibm.team.workitem.common.internal.model.Comment;
import com.ibm.team.workitem.common.internal.model.ModelPackage;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.Messages;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AttributeOperation {
    private static final String OPERATOR_APP_REJECTED = "rejected by";
    private static final String OPERATOR_APP_APPROVED = "approved by";
    private static final String OPERATOR_APP_PENDING = "pending by";
    private static final String OPERATOR_APP_INVOLVE = "involve";
    private static final String OPERATOR_EXISTS = "exists";
    private static final String OPERATOR_NOT_EXISTS = "not exists";
    private static final String OPERATOR_CONTAINING = "containing";
    private static final String OPERATOR_NOT_CONTAINING = "not containing";
    private static final String OPERATOR_AUTHORED_BY = "authored by";
    private static final String OPERATOR_PART_OF = "is part of";
    private static final String OPERATOR_NOT_PART_OF = "is not part of";
    private static final String OPERATOR_IN_SUBTREE = "in subtree";
    private static final String OPERATOR_NOT_IN_SUBTREE = "not in subtree";
    private static final String OPERATOR_SM_OR_EQ = "smaller or equals";
    private static final String OPERATOR_GT_OR_EQ = "greater or equals";
    private static final String OPERATOR_BEFORE = "before";
    private static final String OPERATOR_AFTER = "after";
    private static final String OPERATOR_EQUALS = "is";
    private static final String OPERATOR_NOT_EQUALS = "is not";
    private static final String OPERATOR_MATCHES = "matches";
    private static final String OPERATOR_NOT_MATCHES = "does not match";
    private static final String OPERATOR_STARTS_WITH = "starts with";
    private static final String OPERATOR_ENDS_WITH = "ends with";
    private static final String OPERATOR_CONTAINS = "contains";
    private static final String OPERATOR_NOT_CONTAINS = "does not contain";
    private static final String OPERATOR_TA_EQUALS = "teamarea.equals";
    private static final String OPERATOR_TA_NOT_EQUALS = "teamarea.not.equals";
    private static final String OPERATOR_LINK_EXISTS = "link.exists";
    private static final String OPERATOR_LINK_NOT_EXISTS = "link.not.exists";
    private static Map<String, AttributeOperation> fgRegistry = new HashMap<String, AttributeOperation>();
    public static final AttributeOperation CONTAINS = new AttributeOperation("contains", Messages.getString("AttributeOperation.CONTAINS")){

        public boolean evaluate(Object left, Object right) {
            if (left instanceof String && right instanceof String) {
                String content = ((String)left).toLowerCase();
                String[] terms = ((String)right).split("\\s");
                boolean contained = terms.length > 0;
                int i = 0;
                while (i < terms.length) {
                    String term = terms[i].toLowerCase();
                    if (term.endsWith("*")) {
                        term = term.substring(0, term.length() - 1);
                    }
                    contained &= content.indexOf(term) != -1;
                    ++i;
                }
                return contained;
            }
            return false;
        }

        public IPredicate getPredicate(ITransformationContext context) {
            IStringField field = (IStringField)context.getField();
            context.addLikeParameter("%%%s%%", context.getValue().toString());
            return field._like((IString)context.getQuery().newStringArg(), '\\');
        }
    };
    public static final AttributeOperation NOT_CONTAINS = new InvertedOperation("does not contain", Messages.getString("AttributeOperation.NOT_CONTAINS"), CONTAINS);
    public static final AttributeOperation STARTS_WITH = new AttributeOperation("starts with", Messages.getString("AttributeOperation.STARTS_WITH")){

        public boolean evaluate(Object left, Object right) {
            if (left instanceof String && right instanceof String) {
                return ((String)left).startsWith((String)right);
            }
            return false;
        }

        public IPredicate getPredicate(ITransformationContext context) {
            IStringField field = (IStringField)context.getField();
            context.addLikeParameter("%s%%", context.getValue().toString());
            return field._like((IString)context.getQuery().newStringArg(), '\\');
        }
    };
    public static final AttributeOperation ENDS_WITH = new AttributeOperation("ends with", Messages.getString("AttributeOperation.ENDS_WITH")){

        public boolean evaluate(Object left, Object right) {
            if (left instanceof String && right instanceof String) {
                return ((String)left).endsWith((String)right);
            }
            return false;
        }

        public IPredicate getPredicate(ITransformationContext context) {
            IStringField field = (IStringField)context.getField();
            context.addLikeParameter("%%%s", context.getValue().toString());
            return field._like((IString)context.getQuery().newStringArg(), '\\');
        }
    };
    public static final AttributeOperation EQUALS = new AttributeOperation("is", Messages.getString("AttributeOperation.EQUALS")){

        public boolean evaluate(Object left, Object right) {
            if (left == right) {
                return true;
            }
            if (left == null) {
                return false;
            }
            if (left instanceof IItemHandle && right instanceof IItemHandle) {
                return ((IItemHandle)left).sameItemId((IItemHandle)right);
            }
            if (right instanceof Collection) {
                Collection collection = (Collection)right;
                boolean equals = false;
                for (Object object : collection) {
                    equals |= this.evaluate(left, object);
                }
                return equals;
            }
            return left.equals(right);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IPredicate getPredicate(ITransformationContext context) {
            IPredicate predicate;
            if (context.isField()) {
                IField field = context.getField();
                if (context.getValue() == null) {
                    predicate = field._isNull();
                } else if (field instanceof IStringField) {
                    predicate = ((IStringField)field)._eq((IString)context.getQuery().newStringArg());
                } else {
                    if (field instanceof IDateTimeField) {
                        return this.handleDateTimeField(context);
                    }
                    if (field instanceof INumericField) {
                        predicate = ((INumericField)field)._eq(this.createNumericInputArg(context));
                    } else if (field instanceof IBooleanField) {
                        predicate = ((IBooleanField)field)._eq((IBoolean)context.getQuery().newBooleanArg());
                    } else if (field instanceof IUUIDField) {
                        predicate = ((IUUIDField)field)._eq((IUUID)context.getQuery().newUUIDArg());
                    } else {
                        if (!(field instanceof IEnumField)) throw new IllegalArgumentException("Unknown field type");
                        predicate = ((IEnumField)field)._eq((IEnum)context.getQuery().newEnumArg());
                    }
                }
            } else {
                predicate = context.getValue() == null ? context.getReference()._isNull() : ((ISingleItemQueryModel)context.getReference())._eq(context.getQuery().newItemHandleArg());
            }
            if (context.getValue() == null) return predicate;
            context.addParameter(context.getValue());
            return predicate;
        }

        private IPredicate handleDateTimeField(ITransformationContext context) {
            IDateTimeField field = (IDateTimeField)context.getField();
            TimeSpan timeSpan = this.createTimeSpan(context);
            context.addParameter(timeSpan.getStart());
            context.addParameter(timeSpan.getEnd());
            return field._gtOrEq((IDateTime)context.getQuery().newDateTimeArg())._and(field._ltOrEq((IDateTime)context.getQuery().newDateTimeArg()));
        }

        private TimeSpan createTimeSpan(ITransformationContext context) {
            Object value = context.getValue();
            if (value instanceof Timestamp) {
                return TimeSpan.createTimeSpan((Timestamp)value, 5, context.getTimeZone());
            }
            return (TimeSpan)value;
        }
    };
    public static final AttributeOperation NOT_EQUALS = new InvertedOperation("is not", Messages.getString("AttributeOperation.NOT_EQUALS"), EQUALS);
    public static final AttributeOperation MATCHES = new AttributeOperation("matches", Messages.getString("AttributeOperation.MATCHES")){

        public boolean evaluate(Object left, Object right) {
            if (left == null && right == null) {
                return true;
            }
            if (left instanceof String && right instanceof String) {
                return ((String)left).equalsIgnoreCase((String)right);
            }
            return false;
        }

        public IPredicate getPredicate(ITransformationContext context) {
            IStringField field = (IStringField)context.getField();
            context.addLikeParameter("%s", context.getValue().toString());
            return field._like((IString)context.getQuery().newStringArg(), '\\');
        }
    };
    public static final AttributeOperation NOT_MATCHES = new InvertedOperation("does not match", Messages.getString("AttributeOperation.NOT_MATCHES"), MATCHES);
    public static final AttributeOperation SMALLER_OR_EQUALS = new AttributeOperation("smaller or equals", Messages.getString("AttributeOperation.SMALLER_OR_EQUALS")){

        public boolean evaluate(Object left, Object right) {
            if (left instanceof Comparable && right instanceof Comparable) {
                return ((Comparable)left).compareTo(right) <= 0;
            }
            return false;
        }

        public IPredicate getPredicate(ITransformationContext context) {
            IPredicate predicate;
            IField field = context.getField();
            if (field instanceof IDateTimeField) {
                if (context.getValue() instanceof Timestamp) {
                    TimeSpan timeSpan = TimeSpan.createTimeSpan((Timestamp)context.getValue(), 5, context.getTimeZone());
                    context.addParameter(timeSpan.getEnd());
                } else {
                    TimeSpan timeSpan = (TimeSpan)context.getValue();
                    context.addParameter(timeSpan.getReference());
                }
                predicate = ((IDateTimeField)field)._ltOrEq((IDateTime)context.getQuery().newDateTimeArg());
            } else if (field instanceof INumericField) {
                context.addParameter(context.getValue());
                predicate = ((INumericField)field)._ltOrEq(this.createNumericInputArg(context));
            } else {
                throw new IllegalArgumentException("Unsupported field type");
            }
            return predicate;
        }
    };
    public static final AttributeOperation GREATER_OR_EQUALS = new AttributeOperation("greater or equals", Messages.getString("AttributeOperation.GREATER_OR_EQUALS")){

        public boolean evaluate(Object left, Object right) {
            if (left instanceof Comparable && right instanceof Comparable) {
                return ((Comparable)left).compareTo(right) >= 0;
            }
            return false;
        }

        public IPredicate getPredicate(ITransformationContext context) {
            IPredicate predicate;
            IField field = context.getField();
            if (field instanceof IDateTimeField) {
                if (context.getValue() instanceof Timestamp) {
                    TimeSpan timeSpan = TimeSpan.createTimeSpan((Timestamp)context.getValue(), 5, context.getTimeZone());
                    context.addParameter(timeSpan.getStart());
                } else {
                    TimeSpan timeSpan = (TimeSpan)context.getValue();
                    context.addParameter(timeSpan.getReference());
                }
                predicate = ((IDateTimeField)field)._gtOrEq((IDateTime)context.getQuery().newDateTimeArg());
            } else if (field instanceof INumericField) {
                context.addParameter(context.getValue());
                predicate = ((INumericField)field)._gtOrEq(this.createNumericInputArg(context));
            } else {
                throw new IllegalArgumentException("Unsupported field type");
            }
            return predicate;
        }
    };
    public static final AttributeOperation AFTER = new AliasOperation("after", Messages.getString("AttributeOperation.AFTER"), GREATER_OR_EQUALS);
    public static final AttributeOperation BEFORE = new AliasOperation("before", Messages.getString("AttributeOperation.BEFORE"), SMALLER_OR_EQUALS);
    public static final AttributeOperation IN_CATEGORY = new AttributeOperation("in subtree", Messages.getString("AttributeOperation.IN_SUBTREE")){

        public boolean evaluate(Object left, Object right) {
            if (left instanceof ICategory && right instanceof ICategory) {
                String categoryId = ((ICategory)left).getCategoryId().getInternalRepresentation();
                return categoryId.startsWith(((ICategory)right).getCategoryId().getInternalRepresentation());
            }
            return false;
        }

        public IPredicate getPredicate(ITransformationContext context) throws TeamRepositoryException {
            IStringField categoryIdField = (IStringField)context.getReference().getField(ICategory.CATEGORY_ID);
            String categoryPath = this.getCategoryPath(context);
            context.addParameter(categoryPath);
            return categoryIdField._like((IString)context.getQuery().newStringArg());
        }

        private String getCategoryPath(ITransformationContext context) throws TeamRepositoryException {
            ICategoryHandle categoryHandle = (ICategoryHandle)context.getValue();
            ICategory category = context.getAuditableCommon().resolveAuditable(categoryHandle, ICategory.DEFAULT_PROFILE, null);
            return category.getCategoryId().getSubtreePattern();
        }
    };
    public static final AttributeOperation NOT_IN_CATEGORY = new InvertedOperation("not in subtree", Messages.getString("AttributeOperation.NOT_IN_SUBTREE"), IN_CATEGORY);
    public static final AttributeOperation PART_OF_INTERVAL = new AttributeOperation("is part of", Messages.getString("AttributeOperation.PART_OF")){

        public boolean evaluate(Object left, Object right) {
            return false;
        }

        public IPredicate getPredicate(ITransformationContext context) throws TeamRepositoryException {
            if (context.getValue() == null) {
                return context.getReference()._isNull();
            }
            IIterationHandle parent = (IIterationHandle)context.getValue();
            List<IIteration> iterations = IterationsHelper.findAllIterations(context.getAuditableCommon(), new IIterationHandle[]{parent}, ItemProfile.ITERATION_DEFAULT, true, null);
            ArrayList<IItemHandleInputArg> arguments = new ArrayList<IItemHandleInputArg>(iterations.size());
            if (!iterations.isEmpty()) {
                for (IIteration iteration : iterations) {
                    arguments.add(context.getQuery().newItemHandleArg());
                    context.addParameter(iteration.getItemHandle());
                }
            } else {
                arguments.add(context.getQuery().newItemHandleArg());
                context.addParameter(parent);
            }
            return ((ISingleItemQueryModel)context.getReference())._in(arguments.toArray(new IItemHandleInputArg[arguments.size()]));
        }
    };
    public static final AttributeOperation NOT_PART_OF_INTERVAL = new InvertedOperation("is not part of", Messages.getString("AttributeOperation.NOT_PART_OF"), PART_OF_INTERVAL);
    public static final AttributeOperation AUTHORED_BY = new AttributeOperation("authored by", Messages.getString("AttributeOperation.AUTHORED_BY"), false, "contributor"){

        public boolean evaluate(Object left, Object right) {
            if (left instanceof List && right instanceof IContributorHandle) {
                for (Object next : (List)left) {
                    IComment comment;
                    if (!(next instanceof IComment) || !((IContributorHandle)right).sameItemId((IItemHandle)((Comment)(comment = (IComment)next)).getCreator())) continue;
                    return true;
                }
            }
            return false;
        }

        public IPredicate getPredicate(ITransformationContext context) {
            context.addParameter(context.getValue());
            IDynamicQueryModel subReference = context.getReference().getReference(ModelPackage.eINSTANCE.getComment_Creator().getName());
            return ((ISingleItemQueryModel)subReference)._eq(context.getQuery().newItemHandleArg());
        }
    };
    public static final AttributeOperation CONTAINING = new AttributeOperation("containing", Messages.getString("AttributeOperation.CONTAINING"), false, "contributor"){

        public boolean evaluate(Object left, Object right) {
            if (left instanceof List && right instanceof IItemHandle) {
                for (Object next : (List)left) {
                    IItemHandle contributor;
                    if (!(next instanceof IItemHandle) || !(contributor = (IItemHandle)next).sameItemId((IItemHandle)right)) continue;
                    return true;
                }
            }
            return false;
        }

        public IPredicate getPredicate(ITransformationContext context) {
            context.addParameter(context.getValue());
            return ((IManyItemQueryModel)context.getReference())._contains(context.getQuery().newItemHandleArg());
        }
    };
    public static final AttributeOperation NOT_CONTAINING = new InvertedOperation("not containing", Messages.getString("AttributeOperation.NOT_CONTAINING"), CONTAINING, false);
    private static final AttributeOperation NOT_EXISTS = new AttributeOperation("not exists", Messages.getString("AttributeOperation.NOT_EXISTS"), true){

        public boolean evaluate(Object left, Object right) {
            return left == null;
        }

        public IPredicate getPredicate(ITransformationContext context) throws TeamRepositoryException {
            IField field = context.getField();
            IPredicate predicate = field._isNull();
            return predicate;
        }
    };
    public static final AttributeOperation LINK_EXISTS = new AttributeOperation("link.exists", Messages.getString("AttributeOperation.SET_EXIST"), true){

        public boolean evaluate(Object left, Object right) {
            throw new UnsupportedOperationException();
        }

        public IPredicate getPredicate(ITransformationContext context) throws TeamRepositoryException {
            IStringField field = (IStringField)context.getField(LinksPackage.eINSTANCE.getAuditableLink_Name().getName());
            context.addParameter(context.getValue());
            return field._eq((IString)context.getQuery().newStringArg());
        }
    };
    public static final AttributeOperation LINK_NOT_EXISTS = new AttributeOperation("link.not.exists", Messages.getString("AttributeOperation.SET_NOT_EXIST"), true){

        public boolean evaluate(Object left, Object right) {
            throw new UnsupportedOperationException();
        }

        public IPredicate getPredicate(ITransformationContext context) throws TeamRepositoryException {
            IStringField field = (IStringField)context.getField(LinksPackage.eINSTANCE.getAuditableLink_Name().getName());
            context.addParameter(context.getValue());
            return field._notEq((IString)context.getQuery().newStringArg());
        }
    };
    public static final AttributeOperation TEAM_AREA_EQUALS = new AttributeOperation("teamarea.equals", Messages.getString("AttributeOperation.EQUALS")){
        private final String DEVELOPMENTLINE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"developmentLine");

        public boolean evaluate(Object left, Object right) {
            return false;
        }

        public IPredicate getPredicate(ITransformationContext context) throws TeamRepositoryException {
            IQuery query = context.getQuery();
            ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)context.getValue();
            IDevelopmentLine devLine = context.getAuditableCommon().getDevelopmentLine(teamAreaHandle, null);
            IManyItemQueryModel categoryTeamAreas = (IManyItemQueryModel)context.getReference(IWorkItem.CATEGORY_PROPERTY).getReference(Category.TEAM_AREAS_PROPERTY);
            IDynamicQueryModel target = context.getReference(IWorkItem.TARGET_PROPERTY);
            ISingleItemQueryModel targetDevelopmentLine = (ISingleItemQueryModel)target.getReference(this.DEVELOPMENTLINE_PROPERTY);
            ISingleItemQueryModel categoryDefaultTeamArea = (ISingleItemQueryModel)context.getReference(IWorkItem.CATEGORY_PROPERTY).getReference(Category.DEFAULT_TEAM_AREA_PROPERTY);
            IItemHandleInputArg teamAreaInputArg = query.newItemHandleArg();
            IItemHandleInputArg devLineInputArg = query.newItemHandleArg();
            IPredicate predicate = categoryTeamAreas._contains(teamAreaInputArg)._and(targetDevelopmentLine._eq(devLineInputArg));
            predicate = predicate._or(categoryDefaultTeamArea._eq(teamAreaInputArg)._and(target._isNull()));
            context.addParameter(teamAreaHandle);
            context.addParameter(devLine.getItemHandle());
            return predicate;
        }
    };
    public static final AttributeOperation TEAM_AREA_NOT_EQUALS = new InvertedOperation("teamarea.not.equals", Messages.getString("AttributeOperation.NOT_EQUALS"), TEAM_AREA_EQUALS, false);
    public static final AttributeOperation EXISTS = new InvertedOperation("exists", Messages.getString("AttributeOperation.EXISTS"), NOT_EXISTS, false);
    public static final AttributeOperation INVOLVES = new ApprovalOperation("involve", Messages.getString("AttributeOperation.APPROVAL_INVOLVE"), null);
    public static final AttributeOperation TO_BE_APPROVED_BY = new ApprovalOperation("pending by", Messages.getString("AttributeOperation.APPROVAL_PENDING_BY"), WorkItemApprovals.PENDING_STATE);
    public static final AttributeOperation APPROVED_BY = new ApprovalOperation("approved by", Messages.getString("AttributeOperation.APPROVAL_APPROVED_BY"), WorkItemApprovals.APPROVED_STATE);
    public static final AttributeOperation REJECTED_BY = new ApprovalOperation("rejected by", Messages.getString("AttributeOperation.APPROVAL_REJECTED_BY"), WorkItemApprovals.REJECTED_STATE);
    private final String fDisplayName;
    private final String fIdentifier;
    private final String fTargetAttributeType;
    private final boolean fIsUnary;

    public static AttributeOperation find(String id) {
        if ("similar".equals(id)) {
            return CONTAINS;
        }
        return fgRegistry.get(id);
    }

    private AttributeOperation(String identifier, String displayName) {
        this(identifier, displayName, false, "");
    }

    private AttributeOperation(String identifier, String displayName, boolean isUnary) {
        this(identifier, displayName, isUnary, "");
    }

    private AttributeOperation(String identifier, String displayName, boolean isUnary, String targetAttributeType) {
        this.fIdentifier = identifier;
        this.fDisplayName = displayName;
        this.fIsUnary = isUnary;
        this.fTargetAttributeType = targetAttributeType;
        fgRegistry.put(identifier, this);
    }

    public String getIdentifier() {
        return this.fIdentifier;
    }

    public String getDisplayName() {
        return this.fDisplayName;
    }

    public String getTargetAttributeType() {
        return this.fTargetAttributeType;
    }

    public boolean isUnary() {
        return this.fIsUnary;
    }

    public boolean isNegation() {
        return false;
    }

    protected INumeric createNumericInputArg(ITransformationContext context) {
        Object value = context.getValue();
        if (value instanceof Integer) {
            return context.getQuery().newIntegerArg();
        }
        if (value instanceof Long) {
            return context.getQuery().newLongArg();
        }
        if (value instanceof BigDecimal) {
            return context.getQuery().newBigDecimalArg();
        }
        throw new IllegalArgumentException("Numeric value must be Integer, Long or BigDecimal");
    }

    public abstract boolean evaluate(Object var1, Object var2);

    public abstract IPredicate getPredicate(ITransformationContext var1) throws TeamRepositoryException;

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AttributeOperation) {
            return this.getIdentifier().equals(((AttributeOperation)obj).getIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.getIdentifier().hashCode();
    }

    /* synthetic */ AttributeOperation(String string, String string2, AttributeOperation attributeOperation) {
        this(string, string2);
    }

    /* synthetic */ AttributeOperation(String string, String string2, boolean bl, String string3, AttributeOperation attributeOperation) {
        this(string, string2, bl, string3);
    }

    /* synthetic */ AttributeOperation(String string, String string2, boolean bl, AttributeOperation attributeOperation) {
        this(string, string2, bl);
    }

    private static class AliasOperation
    extends AttributeOperation {
        private AttributeOperation fOperation;

        public AliasOperation(String identifier, String displayName, AttributeOperation operation) {
            super(identifier, displayName, null);
            this.fOperation = operation;
        }

        public boolean evaluate(Object left, Object right) {
            return this.fOperation.evaluate(left, right);
        }

        public IPredicate getPredicate(ITransformationContext context) throws TeamRepositoryException {
            return this.fOperation.getPredicate(context);
        }

        public String getTargetAttributeType() {
            return this.fOperation.getTargetAttributeType();
        }

        public boolean isNegation() {
            return this.fOperation.isNegation();
        }

        public boolean isUnary() {
            return this.fOperation.isUnary();
        }
    }

    private static class ApprovalOperation
    extends AttributeOperation {
        private final IApprovalState fApprovalState;

        public ApprovalOperation(String identifier, String name, IApprovalState approvalState) {
            super(identifier, name, null);
            this.fApprovalState = approvalState;
        }

        public boolean evaluate(Object left, Object right) {
            return false;
        }

        public IPredicate getPredicate(ITransformationContext context) {
            IPredicate predicate;
            IDynamicQueryModel approvals = context.getReference();
            ISingleItemQueryModel approver = (ISingleItemQueryModel)approvals.getReference(ModelPackage.eINSTANCE.getApproval_Approver().getName());
            IStringField stateIdentifier = (IStringField)approvals.getField(ModelPackage.eINSTANCE.getApproval_StateIdentifier().getName());
            if (context.getValue() == null) {
                predicate = approvals._isEmpty()._not();
            } else {
                context.addParameter(context.getValue());
                predicate = approver._eq(context.getQuery().newItemHandleArg());
            }
            if (this.fApprovalState != null) {
                context.addParameter(this.fApprovalState.getIdentifier());
                IPredicate statePredicate = stateIdentifier._eq((IString)context.getQuery().newStringArg());
                predicate = predicate._and(statePredicate);
            }
            return predicate;
        }
    }

    private static class InvertedOperation
    extends AttributeOperation {
        private AttributeOperation fOperation;
        private boolean fHandleNull;

        public InvertedOperation(String identifier, String displayName, AttributeOperation operation) {
            this(identifier, displayName, operation, true);
        }

        public InvertedOperation(String identifier, String displayName, AttributeOperation operation, boolean handleNull) {
            super(identifier, displayName, null);
            this.fOperation = operation;
            this.fHandleNull = handleNull;
        }

        public boolean evaluate(Object left, Object right) {
            return !this.fOperation.evaluate(left, right);
        }

        public IPredicate getPredicate(ITransformationContext context) throws TeamRepositoryException {
            IPredicate predicate = this.fOperation.getPredicate(context);
            return predicate != null ? this.invert(context, predicate) : null;
        }

        private IPredicate invert(ITransformationContext context, IPredicate predicate) {
            IPredicate nullPredicate = null;
            if (this.fHandleNull && context.getValue() != null) {
                nullPredicate = context.isField() ? context.getField()._isNull() : context.getReference()._isNull();
            }
            return nullPredicate == null ? predicate._not() : predicate._not()._or(nullPredicate);
        }

        public String getTargetAttributeType() {
            return this.fOperation.getTargetAttributeType();
        }

        public boolean isUnary() {
            return this.fOperation.isUnary();
        }

        public boolean isNegation() {
            return true;
        }
    }
}

