/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.workflow;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.ResourceLocation;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.workflow.EclipseWayWorkflow;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkflowInfo
implements IWorkflowInfo {
    private String fWorkflowId;
    private String fName;
    private String fPluginId;
    private Map<String, IMemento> fStates = new HashMap<String, IMemento>();
    private ArrayList<Identifier<IState>> fStateIds2 = new ArrayList();
    private Map<String, IMemento> fResolutions = new HashMap<String, IMemento>();
    private ArrayList<Identifier<IResolution>> fResolutionIds2 = new ArrayList();
    private Map<String, IMemento> fActions = new HashMap<String, IMemento>();
    private ArrayList<Identifier<IWorkflowAction>> fActionIds2 = new ArrayList();
    private Identifier<IWorkflowAction> fResolveActionId;
    private Identifier<IWorkflowAction> fReopenActionId;
    private Map<String, URL> fImageURLs = new HashMap<String, URL>();
    private IProjectAreaHandle fProjectArea;
    private String fRepositoryUrl;

    public WorkflowInfo(IProjectAreaHandle projectArea, String workflowId, IMemento root, String repositoryUrl) {
        String reopenAction;
        this.fProjectArea = projectArea;
        this.fRepositoryUrl = repositoryUrl;
        this.fWorkflowId = workflowId;
        this.fName = root.getString("name");
        this.fPluginId = root.getString("pluginId");
        IMemento[] states = root.getChildren("state");
        int i = 0;
        while (i < states.length) {
            IMemento memento2 = states[i];
            String id2 = memento2.getString("id");
            if (id2 != null && id2.length() > 0) {
                this.fStates.put(id2, memento2);
                id2 = WorkflowInfo.stripOffPrefix(id2, 's');
                this.fStateIds2.add(Identifier.create(IState.class, id2));
            }
            ++i;
        }
        IMemento[] resolutions = root.getChildren("resolution");
        int i2 = 0;
        while (i2 < resolutions.length) {
            IMemento memento2 = resolutions[i2];
            String id2 = memento2.getString("id");
            if (id2 != null && id2.length() > 0) {
                this.fResolutions.put(id2, memento2);
                id2 = WorkflowInfo.stripOffPrefix(id2, 'r');
                this.fResolutionIds2.add(Identifier.create(IResolution.class, id2));
            }
            ++i2;
        }
        IMemento[] actions = root.getChildren("action");
        int i3 = 0;
        while (i3 < actions.length) {
            IMemento memento2 = actions[i3];
            String id2 = memento2.getString("id");
            if (id2 != null && id2.length() > 0) {
                this.fActions.put(id2, memento2);
                this.fActionIds2.add(Identifier.create(IWorkflowAction.class, id2));
            }
            ++i3;
        }
        String resolveAction = root.getString("resolveActionId");
        if (resolveAction != null && resolveAction.length() > 0) {
            this.fResolveActionId = Identifier.create(IWorkflowAction.class, resolveAction);
        }
        if ((reopenAction = root.getString("reopenActionId")) != null && reopenAction.length() > 0) {
            this.fReopenActionId = Identifier.create(IWorkflowAction.class, reopenAction);
        }
    }

    @Override
    public String getIdentifier() {
        return this.fWorkflowId;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public boolean equals(Object object) {
        if (object instanceof WorkflowInfo) {
            WorkflowInfo info = (WorkflowInfo)object;
            return info.fWorkflowId.equals(this.fWorkflowId);
        }
        return false;
    }

    public int hashCode() {
        return this.fWorkflowId.hashCode();
    }

    @Override
    public Identifier<IState>[] getAllStateIds() {
        return this.fStateIds2.toArray(new Identifier[this.fStateIds2.size()]);
    }

    @Override
    public Identifier<IState>[] getStateIds(int stateGroups) {
        ArrayList<Identifier<IState>> result = new ArrayList<Identifier<IState>>();
        for (IMemento memento2 : this.fStates.values()) {
            String group = memento2.getString("group");
            boolean matches = false;
            if ((stateGroups & 1) != 0) {
                matches = "open".equals(group);
            }
            if (!matches && (stateGroups & 4) != 0) {
                matches = "inprogress".equals(group);
            }
            if (!matches && (stateGroups & 2) != 0) {
                matches = "closed".equals(group);
            }
            if (!matches) continue;
            String id2 = memento2.getString("id");
            id2 = WorkflowInfo.stripOffPrefix(id2, 's');
            result.add(Identifier.create(IState.class, id2));
        }
        return result.toArray(new Identifier[result.size()]);
    }

    @Override
    public boolean stateGroupContains(int stateGroups, Identifier<IState> state) {
        if (state != null) {
            Identifier<IState>[] s = this.getStateIds(stateGroups);
            int i = 0;
            while (i < s.length) {
                if (state.equals(s[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public int getStateGroup(Identifier<IState> state) {
        IMemento m;
        if (state != null && (m = this.getState(state.getStringIdentifier())) != null) {
            String group = m.getString("group");
            if ("open".equals(group)) {
                return 1;
            }
            if ("inprogress".equals(group)) {
                return 4;
            }
            if ("closed".equals(group)) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public String getStateName(Identifier<IState> state) {
        IMemento m;
        if (state != null && (m = this.getState(state.getStringIdentifier())) != null) {
            return m.getString("name");
        }
        return null;
    }

    @Override
    public URL getStateIconName(Identifier<IState> state) {
        IMemento m;
        if (state != null && (m = this.getState(state.getStringIdentifier())) != null) {
            return this.fImageURLs.get(m.getString("icon"));
        }
        return null;
    }

    @Override
    public Identifier<IWorkflowAction>[] getActionIds(Identifier<IState> state) {
        IMemento m;
        if (state != null && (m = this.getState(state.getStringIdentifier())) != null) {
            IMemento[] actions = m.getChildren("action");
            Identifier[] actionIds = new Identifier[actions.length];
            int i = 0;
            while (i < actionIds.length) {
                IMemento action = actions[i];
                actionIds[i] = Identifier.create(IWorkflowAction.class, action.getString("id"));
                ++i;
            }
            return actionIds;
        }
        return new Identifier[0];
    }

    @Override
    public Identifier<IResolution>[] getStateResolutionIds(Identifier<IState> state) {
        Identifier<IState>[] resolvedStates = this.getStateIds(2);
        if (state != null) {
            int i = 0;
            while (i < resolvedStates.length) {
                if (state.equals(resolvedStates[i])) {
                    return this.getAllResolutionIds();
                }
                ++i;
            }
        }
        return new Identifier[0];
    }

    @Override
    public Identifier<IWorkflowAction> getResolveActionId() {
        return this.fResolveActionId;
    }

    @Override
    public Identifier<IWorkflowAction> getReopenActionId() {
        return this.fReopenActionId;
    }

    @Override
    public Identifier<IWorkflowAction>[] getAllActionIds() {
        return this.fActionIds2.toArray(new Identifier[this.fActionIds2.size()]);
    }

    @Override
    public String getActionName(Identifier<IWorkflowAction> actionId) {
        IMemento m = this.getAction(actionId.getStringIdentifier());
        if (m != null) {
            return m.getString("name");
        }
        return null;
    }

    @Override
    public URL getActionIconName(Identifier<IWorkflowAction> id) {
        IMemento m = this.getAction(id.getStringIdentifier());
        if (m != null) {
            return this.fImageURLs.get(m.getString("icon"));
        }
        return null;
    }

    @Override
    public Identifier<IResolution>[] getResolutionIds(Identifier<IWorkflowAction> actionId) {
        IMemento m = this.getAction(actionId.getStringIdentifier());
        if (m != null) {
            IMemento[] resolutions = m.getChildren("resolution");
            Identifier[] rs = new Identifier[resolutions.length];
            int j = 0;
            while (j < resolutions.length) {
                String id = resolutions[j].getString("id");
                id = WorkflowInfo.stripOffPrefix(id, 'r');
                rs[j] = Identifier.create(IResolution.class, id);
                ++j;
            }
            return rs;
        }
        return new Identifier[0];
    }

    @Override
    public Identifier<IState> getActionResultState(Identifier<IWorkflowAction> actionId) {
        String id;
        IMemento m = this.getAction(actionId.getStringIdentifier());
        if (m != null && (id = m.getString("state")) != null && id.length() > 0) {
            return Identifier.create(IState.class, id);
        }
        return null;
    }

    @Override
    public Identifier<IResolution> getUnresolvedResolutionId() {
        return EclipseWayWorkflow.RESOLUTION_UNRESOLVED;
    }

    @Override
    public Identifier<IResolution>[] getAllResolutionIds() {
        return this.fResolutionIds2.toArray(new Identifier[this.fResolutionIds2.size()]);
    }

    @Override
    public String getResolutionName(Identifier<IResolution> resolution) {
        IMemento m;
        if (resolution == null) {
            resolution = EclipseWayWorkflow.RESOLUTION_UNRESOLVED;
        }
        if ((m = this.getResolution(resolution.getStringIdentifier())) != null) {
            return m.getString("name");
        }
        return null;
    }

    @Override
    public URL getResolutionIconName(Identifier<IResolution> resolution) {
        IMemento m;
        if (resolution == null) {
            resolution = EclipseWayWorkflow.RESOLUTION_UNRESOLVED;
        }
        if ((m = this.getResolution(resolution.getStringIdentifier())) != null) {
            return this.fImageURLs.get(m.getString("icon"));
        }
        return null;
    }

    IProjectAreaHandle getProjectAreaHandle() {
        return this.fProjectArea;
    }

    private IMemento getState(String id) {
        if (this.fStates == null) {
            return null;
        }
        try {
            Integer.parseInt(id);
            id = "s" + id;
        }
        catch (NumberFormatException numberFormatException) {}
        return this.fStates.get(id);
    }

    private IMemento getAction(String id) {
        if (this.fActions == null) {
            return null;
        }
        return this.fActions.get(id);
    }

    private IMemento getResolution(String id) {
        if (this.fResolutions == null) {
            return null;
        }
        try {
            Integer.parseInt(id);
            id = "r" + id;
        }
        catch (NumberFormatException numberFormatException) {}
        return this.fResolutions.get(id);
    }

    private String internalGetStateIconName(Identifier<IState> state) {
        IMemento m;
        if (state != null && (m = this.getState(state.getStringIdentifier())) != null) {
            return m.getString("icon");
        }
        return null;
    }

    private String internalGetActionIconName(Identifier<IWorkflowAction> id) {
        IMemento m = this.getAction(id.getStringIdentifier());
        if (m != null) {
            return m.getString("icon");
        }
        return null;
    }

    private String internalGetResolutionIconName(Identifier<IResolution> resolution) {
        IMemento m;
        if (resolution == null) {
            resolution = EclipseWayWorkflow.RESOLUTION_UNRESOLVED;
        }
        if ((m = this.getResolution(resolution.getStringIdentifier())) != null) {
            return m.getString("icon");
        }
        return null;
    }

    public void resolveImageURLs(IAuditableCommon auditableCommon, IProgressMonitor monitor) {
        String iconName;
        WorkItemCommon workItemCommon = (WorkItemCommon)auditableCommon.getPeer(IWorkItemCommon.class);
        Identifier<Comparable<IState>>[] identifierArray = this.getAllStateIds();
        int n = identifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            Identifier<IState> stateId = identifierArray[n2];
            iconName = this.internalGetStateIconName(stateId);
            this.cacheImageURL(workItemCommon, iconName, monitor);
            ++n2;
        }
        identifierArray = this.getAllActionIds();
        n = identifierArray.length;
        n2 = 0;
        while (n2 < n) {
            Identifier<Comparable<IState>> action = identifierArray[n2];
            iconName = this.internalGetActionIconName(action);
            this.cacheImageURL(workItemCommon, iconName, monitor);
            ++n2;
        }
        identifierArray = this.getAllResolutionIds();
        n = identifierArray.length;
        n2 = 0;
        while (n2 < n) {
            Identifier<Comparable<IState>> resolution = identifierArray[n2];
            iconName = this.internalGetResolutionIconName(resolution);
            this.cacheImageURL(workItemCommon, iconName, monitor);
            ++n2;
        }
    }

    private void cacheImageURL(WorkItemCommon service, String iconName, IProgressMonitor monitor) {
        URL resourceUrl = this.getResourceUrl(iconName);
        if (resourceUrl != null) {
            try {
                URL localUrl = service.resolveURL(resourceUrl, monitor);
                this.fImageURLs.put(iconName, localUrl);
            }
            catch (TeamRepositoryException e) {
                WorkItemCommonPlugin.log(NLS.bind((String)"Error while retrieving image: {0}", (Object[])new Object[]{iconName}), (Exception)((Object)e));
            }
        }
    }

    private URL getResourceUrl(String path) {
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        try {
            URL resourceURL = ResourceLocation.getResourceURL((IProcessContainerHandle)this.fProjectArea, new URI(path), this.fRepositoryUrl);
            if (resourceURL != null) {
                return resourceURL;
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (URISyntaxException uRISyntaxException) {}
        if (this.fPluginId == null) {
            return null;
        }
        return WorkflowInfo.getResourceUrl(this.fPluginId, path);
    }

    private static URL getResourceUrl(String pluginId, String resourceFilePath) {
        if (pluginId == null || resourceFilePath == null) {
            throw new IllegalArgumentException();
        }
        try {
            return new URL(String.format("platform:/plugin/%s/%s", pluginId, resourceFilePath));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static String stripOffPrefix(String s, char prefix) {
        int l;
        if (s != null && (l = s.length()) > 1 && s.charAt(0) == prefix) {
            int i = 1;
            while (i < l) {
                if (!Character.isDigit(s.charAt(i))) {
                    return s;
                }
                ++i;
            }
            return s.substring(1);
        }
        return s;
    }
}

