/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.workflow;

import com.ibm.team.workitem.common.internal.workflow.WorkflowInfo;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.ICombinedWorkflowInfos;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedWorkflowInfos
implements ICombinedWorkflowInfos {
    private IWorkflowInfo[] fWorkflowInfos;

    public CombinedWorkflowInfos(IWorkflowInfo[] workflowinfos) {
        this.fWorkflowInfos = workflowinfos;
    }

    @Override
    public Identifier<IState>[] getAllStateIds() {
        if (this.fWorkflowInfos.length == 1) {
            return this.fWorkflowInfos[0].getAllStateIds();
        }
        ArrayList<Identifier<IState>> set = new ArrayList<Identifier<IState>>();
        int i = 0;
        while (i < this.fWorkflowInfos.length) {
            Identifier<IState>[] stateIds = this.fWorkflowInfos[i].getAllStateIds();
            int j = 0;
            while (j < stateIds.length) {
                Identifier<IState> in = stateIds[j];
                if (!set.contains(in)) {
                    set.add(in);
                }
                ++j;
            }
            ++i;
        }
        Identifier[] states = new Identifier[set.size()];
        Iterator iter = set.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            states[i2] = (Identifier)iter.next();
            ++i2;
        }
        return states;
    }

    @Override
    public Identifier<IResolution>[] getAllResolutionIds() {
        if (this.fWorkflowInfos.length == 1) {
            return this.fWorkflowInfos[0].getAllResolutionIds();
        }
        ArrayList<Identifier<IResolution>> set = new ArrayList<Identifier<IResolution>>();
        int i = 0;
        while (i < this.fWorkflowInfos.length) {
            Identifier<IResolution>[] resolutionIds = this.fWorkflowInfos[i].getAllResolutionIds();
            int j = 0;
            while (j < resolutionIds.length) {
                Identifier<IResolution> in = resolutionIds[j];
                if (!set.contains(in)) {
                    set.add(in);
                }
                ++j;
            }
            ++i;
        }
        Identifier[] resolutions = new Identifier[set.size()];
        Iterator iter = set.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            resolutions[i2] = (Identifier)iter.next();
            ++i2;
        }
        return resolutions;
    }

    @Override
    public String getStateName(Identifier<IState> stateId) {
        if (this.fWorkflowInfos.length == 1) {
            return this.fWorkflowInfos[0].getStateName(stateId);
        }
        int i = 0;
        while (i < this.fWorkflowInfos.length) {
            String stateName = this.fWorkflowInfos[i].getStateName(stateId);
            if (stateName != null) {
                return stateName;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getResolutionName(Identifier<IResolution> resolutionId) {
        if (this.fWorkflowInfos.length == 1) {
            return this.fWorkflowInfos[0].getResolutionName(resolutionId);
        }
        int i = 0;
        while (i < this.fWorkflowInfos.length) {
            String resolutionName = this.fWorkflowInfos[i].getResolutionName(resolutionId);
            if (resolutionName != null) {
                return resolutionName;
            }
            ++i;
        }
        return null;
    }

    @Override
    public Identifier<IResolution>[] getStateResolutions(Identifier<IState> stateId) {
        if (this.fWorkflowInfos.length == 1) {
            return this.fWorkflowInfos[0].getStateResolutionIds(stateId);
        }
        ArrayList<Identifier<IResolution>> set = new ArrayList<Identifier<IResolution>>();
        int i = 0;
        while (i < this.fWorkflowInfos.length) {
            Identifier<IResolution>[] resolutionIds = this.fWorkflowInfos[i].getStateResolutionIds(stateId);
            int j = 0;
            while (j < resolutionIds.length) {
                Identifier<IResolution> in = resolutionIds[j];
                if (!set.contains(in)) {
                    set.add(in);
                }
                ++j;
            }
            ++i;
        }
        Identifier[] resolutions = new Identifier[set.size()];
        Iterator iter = set.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            resolutions[i2] = (Identifier)iter.next();
            ++i2;
        }
        return resolutions;
    }

    @Override
    public Identifier<IState>[] getStateIds(int groups) {
        if (this.fWorkflowInfos.length == 1) {
            return this.fWorkflowInfos[0].getStateIds(groups);
        }
        ArrayList<Identifier<IState>> set = new ArrayList<Identifier<IState>>();
        int i = 0;
        while (i < this.fWorkflowInfos.length) {
            Identifier<IState>[] stateIds = this.fWorkflowInfos[i].getStateIds(groups);
            int j = 0;
            while (j < stateIds.length) {
                Identifier<IState> in = stateIds[j];
                if (!set.contains(in)) {
                    set.add(in);
                }
                ++j;
            }
            ++i;
        }
        Identifier[] resolutions = new Identifier[set.size()];
        Iterator iter = set.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            resolutions[i2] = (Identifier)iter.next();
            ++i2;
        }
        return resolutions;
    }

    @Override
    public Identifier<IState>[] getStateIds2(int groups) {
        return this.getStateIds(groups);
    }

    @Override
    public int getStateGroup(Identifier<IState> state) {
        int i = 0;
        while (i < this.fWorkflowInfos.length) {
            IWorkflowInfo workflowInfo = this.fWorkflowInfos[i];
            int stateGroup = workflowInfo.getStateGroup(state);
            if (stateGroup != 0) {
                return stateGroup;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public URL getResolutionIconName(Identifier<IResolution> resolutionId) {
        if (this.fWorkflowInfos.length == 1) {
            return this.fWorkflowInfos[0].getResolutionIconName(resolutionId);
        }
        int i = 0;
        while (i < this.fWorkflowInfos.length) {
            URL resolutionIconName = this.fWorkflowInfos[i].getResolutionIconName(resolutionId);
            if (resolutionIconName != null) {
                return resolutionIconName;
            }
            ++i;
        }
        return null;
    }

    @Override
    public URL getStateIconName(Identifier<IState> stateId) {
        if (this.fWorkflowInfos.length == 1) {
            return this.fWorkflowInfos[0].getStateIconName(stateId);
        }
        int i = 0;
        while (i < this.fWorkflowInfos.length) {
            URL stateIconName = this.fWorkflowInfos[i].getStateIconName(stateId);
            if (stateIconName != null) {
                return stateIconName;
            }
            ++i;
        }
        return null;
    }

    boolean containsOnlyBuiltinWorkflows() {
        int i = 0;
        while (i < this.fWorkflowInfos.length) {
            IWorkflowInfo workflowInfo = this.fWorkflowInfos[i];
            if (workflowInfo instanceof WorkflowInfo && ((WorkflowInfo)workflowInfo).getProjectAreaHandle() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

