/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.process.common.IProcessAttachmentHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ISimpleFileHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.common.query.BaseProcessAttachmentQueryModel;
import com.ibm.team.process.internal.common.query.BaseProjectAreaQueryModel;
import com.ibm.team.process.internal.common.query.BaseTeamAreaQueryModel;
import com.ibm.team.process.internal.common.simplefile.query.BaseSimpleFileQueryModel;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IChangeEventHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.query.BaseChangeEventQueryModel;
import com.ibm.team.repository.common.model.query.BaseContributorQueryModel;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IDateTime;
import com.ibm.team.repository.common.query.ast.IDynamicItemQueryModel;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IItemQueryModel;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.INumericInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.query.ast.IUUIDField;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.model.query.BaseAttachmentQueryModel;
import com.ibm.team.workitem.common.internal.model.query.BaseAttributeQueryModel;
import com.ibm.team.workitem.common.internal.model.query.BaseCategoryQueryModel;
import com.ibm.team.workitem.common.internal.model.query.BaseDeliverableQueryModel;
import com.ibm.team.workitem.common.internal.model.query.BaseWorkItemQueryModel;
import com.ibm.team.workitem.common.internal.query.query.BaseQueryDescriptorQueryModel;
import com.ibm.team.workitem.common.internal.util.DataQueryIterator;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.model.CategoryId;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IDeliverableHandle;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemQueries {
    private static final char ESCAPE_CHARACTER = '\\';
    private static IItemQuery fgWorkItemById;
    private static IItemQuery fgAttachmentById;
    private static IItemQuery fgWorkItemByIdRange;
    private static IItemQuery fgAttributeByIdentifier;
    private static IItemQuery fgAttributesByProjectArea;
    private static IItemQuery fgBuiltInAttributes;
    private static IItemQuery fgCategoryByProjectArea;
    private static IItemQuery fgCategoryByIdentifier;
    private static IItemQuery fgCategoryByName;
    private static IItemQuery fgCategoriesByContributor;
    private static IItemQuery fgCategoriesByTeamArea;
    private static IItemQuery fgRootCategory;
    private static IItemQuery fgContributorByName;
    private static IItemQuery fgContributorByEmail;
    private static IItemQuery fgProjectAreaByName;
    private static IItemQuery fgProjectAreaByUUID;
    private static IItemQuery fgTeamsByContributorAndProjectArea;
    private static IItemQuery fgChangeEventsModifiedByUserAndTime;
    private static IItemQuery fgChangeEventsModifiedByUser;
    private static IItemQuery fgChangeEventsByTeamArea;
    private static IItemQuery fgChangeEventsByTeamAreaAndTime;
    private static IItemQuery fgChangeEventsByCategoryName;
    private static IItemQuery fgAllChangeEventsByTimeRangeAndType;
    private static IItemQuery fgTeamAreasByContributor;
    private static IItemQuery fgQueryDescriptorByName;
    private static IItemQuery fgQueryDescriptorById;
    private static IItemQuery fgSimpleFileByPath;
    private static IItemQuery fgProcessAttachmentByPath;
    private static IItemQuery fgDeliverableByProjectArea;
    private static IItemQuery fgActiveDeliverableByProjectArea;
    private static IItemQuery fgDeliverableByName;
    private static IItemQuery fgDeliverableByArtifact;
    private static Map<IItemType, IItemQuery> fgAll;
    private static Map<IItemType, IItemQuery> fgExists;
    private static Map<IItemType, IItemQuery> fgNewer;
    private static IDataQuery fgDistinctWorkItemTags;
    private static IDataQuery fgDistinctWorkItemTagsByProjectArea;
    private static IDataQuery fgMaxWorkItemId;
    private static IDataQuery fgMaxAttachmentId;
    private static IDataQuery fgCountWorkItems;
    private static IDataQuery fgApprovalDescriptorNames;
    private static IDataQuery fgTeamAreaMemberCount;
    private static IItemQuery fgWorkItemsWithOpenApprovalsWithDueDatesEarlierThan;

    static {
        fgAll = new HashMap<IItemType, IItemQuery>();
        fgExists = new HashMap<IItemType, IItemQuery>();
        fgNewer = new HashMap<IItemType, IItemQuery>();
    }

    public static ItemQueryIterator<IWorkItemHandle> workItemById(IAuditableCommon auditableCommon, int id) {
        if (fgWorkItemById == null) {
            BaseWorkItemQueryModel.WorkItemQueryModel model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.id()._eq((INumeric)query.newIntegerArg()));
            fgWorkItemById = query;
        }
        return new ItemQueryIterator<IWorkItemHandle>(auditableCommon, fgWorkItemById, new Object[]{id});
    }

    public static ItemQueryIterator<IAttachmentHandle> attachmentById(IAuditableCommon auditableCommon, int id) {
        if (fgAttachmentById == null) {
            BaseAttachmentQueryModel.AttachmentQueryModel model = BaseAttachmentQueryModel.AttachmentQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.id()._eq((INumeric)query.newIntegerArg()));
            fgAttachmentById = query;
        }
        return new ItemQueryIterator<IAttachmentHandle>(auditableCommon, fgAttachmentById, new Object[]{id});
    }

    public static ItemQueryIterator<IWorkItemHandle> workItemsById(IAuditableCommon auditableCommon, List<Integer> ids) {
        BaseWorkItemQueryModel.WorkItemQueryModel model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
        ArrayList<INumericInputArg> args = new ArrayList<INumericInputArg>();
        int i = 0;
        while (i < ids.size()) {
            args.add(query.newIntegerArg());
            ++i;
        }
        query.filter(model.id()._in(args.toArray(new INumeric[args.size()])));
        return new ItemQueryIterator<IWorkItemHandle>(auditableCommon, query, ids.toArray());
    }

    public static ItemQueryIterator<IWorkItemHandle> workItemByIdRange(IAuditableCommon auditableCommon, int from, int to) {
        if (fgWorkItemByIdRange == null) {
            BaseWorkItemQueryModel.WorkItemQueryModel model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            IPredicate predicate = model.id()._gtOrEq((INumeric)query.newIntegerArg());
            predicate = predicate._and(model.id()._lt((INumeric)query.newIntegerArg()));
            query.filter(predicate);
            fgWorkItemByIdRange = query;
        }
        return new ItemQueryIterator<IWorkItemHandle>(auditableCommon, fgWorkItemByIdRange, new Object[]{from, to});
    }

    public static ItemQueryIterator<IAttributeHandle> attributeByIdentifier(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String identifier) {
        if (fgAttributeByIdentifier == null) {
            BaseAttributeQueryModel.AttributeQueryModel model = BaseAttributeQueryModel.AttributeQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.identifier()._eq((IString)query.newStringArg())));
            fgAttributeByIdentifier = query;
        }
        return new ItemQueryIterator<IAttributeHandle>(auditableCommon, fgAttributeByIdentifier, new Object[]{projectArea, identifier});
    }

    public static ItemQueryIterator<IAttributeHandle> attributesByProjectArea(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgAttributesByProjectArea == null) {
            BaseAttributeQueryModel.AttributeQueryModel model = BaseAttributeQueryModel.AttributeQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg()));
            fgAttributesByProjectArea = query;
        }
        return new ItemQueryIterator<IAttributeHandle>(auditableCommon, fgAttributesByProjectArea, new Object[]{projectArea});
    }

    public static ItemQueryIterator<IAttributeHandle> builtInAttributes(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgBuiltInAttributes == null) {
            BaseAttributeQueryModel.AttributeQueryModel model = BaseAttributeQueryModel.AttributeQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.builtIn()._isTrue()));
            fgBuiltInAttributes = query;
        }
        return new ItemQueryIterator<IAttributeHandle>(auditableCommon, fgBuiltInAttributes, new Object[]{projectArea});
    }

    public static ItemQueryIterator<ICategoryHandle> categoryByIdentifier(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, CategoryId identifier) {
        if (fgCategoryByIdentifier == null) {
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.internalCategoryId()._eq((IString)query.newStringArg())));
            fgCategoryByIdentifier = query;
        }
        return new ItemQueryIterator<ICategoryHandle>(auditableCommon, fgCategoryByIdentifier, new Object[]{projectArea, identifier.getInternalRepresentation()});
    }

    public static ItemQueryIterator<ICategoryHandle> categoryByProjectArea(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgCategoryByProjectArea == null) {
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg()));
            fgCategoryByProjectArea = query;
        }
        return new ItemQueryIterator<ICategoryHandle>(auditableCommon, fgCategoryByProjectArea, new Object[]{projectArea});
    }

    public static ItemQueryIterator<ICategoryHandle> categoryByName(IAuditableCommon auditableCommon, String name) {
        if (fgCategoryByName == null) {
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.name()._eq((IString)query.newStringArg()));
            fgCategoryByName = query;
        }
        return new ItemQueryIterator<ICategoryHandle>(auditableCommon, fgCategoryByName, new Object[]{name});
    }

    public static ItemQueryIterator<ICategoryHandle> categoriesByContributor(IAuditableCommon auditableCommon, IContributorHandle contributor) {
        if (fgCategoriesByContributor == null) {
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            IItemHandleInputArg contributorArg = query.newItemHandleArg();
            query.filter(model.defaultTeamArea().contributors()._contains(contributorArg)._or(model.teamAreas().contributors()._contains(contributorArg)));
            query.distinct();
            fgCategoriesByContributor = query;
        }
        return new ItemQueryIterator<ICategoryHandle>(auditableCommon, fgCategoriesByContributor, new Object[]{contributor});
    }

    public static ItemQueryIterator<ICategoryHandle> categoriesByTeamArea(IAuditableCommon auditableCommon, ITeamAreaHandle teamArea) {
        if (fgCategoriesByTeamArea == null) {
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            IItemHandleInputArg teamAreaArg = query.newItemHandleArg();
            query.filter(model.defaultTeamArea()._eq(teamAreaArg)._or(model.teamAreas()._contains(teamAreaArg)));
            query.distinct();
            fgCategoriesByTeamArea = query;
        }
        return new ItemQueryIterator<ICategoryHandle>(auditableCommon, fgCategoriesByTeamArea, new Object[]{teamArea});
    }

    public static ItemQueryIterator<ICategoryHandle> rootCategory(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgRootCategory == null) {
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg()));
            query.orderByAsc((IField)model.internalCategoryId());
            fgRootCategory = query;
        }
        return new ItemQueryIterator<ICategoryHandle>(auditableCommon, fgRootCategory, new Object[]{projectArea}, 1);
    }

    public static ItemQueryIterator<IContributorHandle> contributorByName(IAuditableCommon auditableCommon, String name) {
        if (fgContributorByName == null) {
            BaseContributorQueryModel.ContributorQueryModel c = BaseContributorQueryModel.ContributorQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)c);
            query.filter(c.name()._eq((IString)query.newStringArg()));
            fgContributorByName = query;
        }
        return new ItemQueryIterator<IContributorHandle>(auditableCommon, fgContributorByName, new Object[]{name});
    }

    public static ItemQueryIterator<IContributorHandle> contributorByEmail(IAuditableCommon auditableCommon, String email) {
        if (fgContributorByEmail == null) {
            BaseContributorQueryModel.ContributorQueryModel c = BaseContributorQueryModel.ContributorQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)c);
            query.filter(c.emailAddress()._eq((IString)query.newStringArg()));
            fgContributorByEmail = query;
        }
        return new ItemQueryIterator<IContributorHandle>(auditableCommon, fgContributorByEmail, new Object[]{email});
    }

    public static ItemQueryIterator<ITeamAreaHandle> teamAreasByContributorAndProjectArea(IAuditableCommon auditableCommon, IContributorHandle user, IProjectAreaHandle projectArea) {
        if (fgTeamsByContributorAndProjectArea == null) {
            BaseTeamAreaQueryModel.TeamAreaQueryModel teamModel = BaseTeamAreaQueryModel.TeamAreaQueryModel.ROOT;
            IItemQuery teamQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)teamModel);
            teamQuery.filter(teamModel.projectArea()._eq(teamQuery.newItemHandleArg())._and(teamModel.contributors()._contains(teamQuery.newItemHandleArg())));
            teamQuery.distinct();
            fgTeamsByContributorAndProjectArea = teamQuery;
        }
        return new ItemQueryIterator<ITeamAreaHandle>(auditableCommon, fgTeamsByContributorAndProjectArea, new Object[]{projectArea, user});
    }

    public static ItemQueryIterator<ITeamAreaHandle> teamAreasByContributor(IAuditableCommon auditableCommon, IContributorHandle user) {
        if (fgTeamAreasByContributor == null) {
            BaseTeamAreaQueryModel.TeamAreaQueryModel teamModel = BaseTeamAreaQueryModel.TeamAreaQueryModel.ROOT;
            IItemQuery teamQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)teamModel);
            teamQuery.filter(teamModel.contributors()._contains(teamQuery.newItemHandleArg()));
            teamQuery.distinct();
            fgTeamAreasByContributor = teamQuery;
        }
        return new ItemQueryIterator<ITeamAreaHandle>(auditableCommon, fgTeamAreasByContributor, new Object[]{user});
    }

    public static ItemQueryIterator<IQueryDescriptorHandle> queryDescriptorByName(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String name) {
        if (fgQueryDescriptorByName == null) {
            BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel queryModel = BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
            query.filter(queryModel.projectArea()._eq(query.newItemHandleArg())._and(queryModel.name()._eq((IString)query.newStringArg())));
            fgQueryDescriptorByName = query;
        }
        return new ItemQueryIterator<IQueryDescriptorHandle>(auditableCommon, fgQueryDescriptorByName, new Object[]{projectArea, name});
    }

    public static ItemQueryIterator<IQueryDescriptorHandle> queryDescriptorById(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String identifier) {
        if (fgQueryDescriptorById == null) {
            BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel queryModel = BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
            query.filter(queryModel.projectArea()._eq(query.newItemHandleArg())._and(queryModel.id()._eq((IString)query.newStringArg())));
            fgQueryDescriptorById = query;
        }
        return new ItemQueryIterator<IQueryDescriptorHandle>(auditableCommon, fgQueryDescriptorById, new Object[]{projectArea, identifier});
    }

    public static ItemQueryIterator<IQueryDescriptorHandle> queryDescriptorsById(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String[] ids) {
        BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel queryModel = BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        ArrayList<String> parameters = new ArrayList<String>(ids.length);
        IString[] args = new IString[ids.length];
        int i = 0;
        while (i < ids.length) {
            args[i] = query.newStringArg();
            parameters.add(ids[i]);
            ++i;
        }
        parameters.add((String)projectArea);
        query.filter(queryModel.projectArea()._eq(query.newItemHandleArg())._and(queryModel.id()._in(args)));
        return new ItemQueryIterator<IQueryDescriptorHandle>(auditableCommon, query, parameters.toArray());
    }

    public static <T extends IAuditableHandle> ItemQueryIterator<T> all(IAuditableCommon auditableCommon, IItemType itemType) {
        IItemQuery query = fgAll.get(itemType);
        if (query == null) {
            IDynamicItemQueryModel model = itemType.getQueryModel();
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)((IItemQueryModel)model));
            fgAll.put(itemType, query);
        }
        return new ItemQueryIterator(auditableCommon, query);
    }

    public static ItemQueryIterator<IAuditableHandle> exists(IAuditableCommon auditableCommon, IAuditableHandle handle) {
        IItemQuery query = fgExists.get(handle.getItemType());
        if (query == null) {
            IDynamicItemQueryModel model = handle.getItemType().getQueryModel();
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)((IItemQueryModel)model));
            IUUIDField itemId = (IUUIDField)model.getField(IItem.ITEM_ID_PROPERTY);
            query.filter(itemId._eq((IUUID)query.newUUIDArg()));
            fgExists.put(handle.getItemType(), query);
        }
        return new ItemQueryIterator<IAuditableHandle>(auditableCommon, query, new Object[]{handle.getItemId()});
    }

    public static ItemQueryIterator<IAuditableHandle> newer(IAuditableCommon auditableCommon, IAuditableHandle stateHandle) {
        Assert.isTrue((boolean)stateHandle.hasStateId());
        IItemQuery query = fgNewer.get(stateHandle.getItemType());
        if (query == null) {
            IDynamicItemQueryModel model = stateHandle.getItemType().getQueryModel();
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)((IItemQueryModel)model));
            IUUIDField itemId = (IUUIDField)model.getField(IItem.ITEM_ID_PROPERTY);
            IUUIDField stateId = (IUUIDField)model.getField(IItem.STATE_ID_PROPERTY);
            query.filter(itemId._eq((IUUID)query.newUUIDArg())._and(query.not(stateId._eq((IUUID)query.newUUIDArg()))));
            fgNewer.put(stateHandle.getItemType(), query);
        }
        return new ItemQueryIterator<IAuditableHandle>(auditableCommon, query, new Object[]{stateHandle.getItemId(), stateHandle.getStateId()});
    }

    public static ItemQueryIterator<IProjectAreaHandle> projectAreaByName(IAuditableCommon auditableCommon, String projectAreaName) {
        if (fgProjectAreaByName == null) {
            BaseProjectAreaQueryModel.ProjectAreaQueryModel model = BaseProjectAreaQueryModel.ProjectAreaQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.name()._like((IString)query.newStringArg()));
            fgProjectAreaByName = query;
        }
        return new ItemQueryIterator<IProjectAreaHandle>(auditableCommon, fgProjectAreaByName, new Object[]{projectAreaName});
    }

    public static ItemQueryIterator<IProjectAreaHandle> projectAreaByUUID(IAuditableCommon auditableCommon, UUID projectAreaUUID) {
        if (fgProjectAreaByUUID == null) {
            BaseProjectAreaQueryModel.ProjectAreaQueryModel model = BaseProjectAreaQueryModel.ProjectAreaQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.itemId()._eq((IUUID)query.newUUIDArg()));
            fgProjectAreaByUUID = query;
        }
        return new ItemQueryIterator<IProjectAreaHandle>(auditableCommon, fgProjectAreaByUUID, new Object[]{projectAreaUUID});
    }

    public static ItemQueryIterator<IChangeEventHandle> changeEventsByTeamArea(IAuditableCommon auditableCommon, ITeamAreaHandle teamArea, Timestamp since, List<String> categoryFilter, int maxResults) {
        int i;
        IPredicate predicate;
        IItemQuery changeQuery;
        BaseChangeEventQueryModel.ChangeEventQueryModel changeModel;
        Assert.isTrue((categoryFilter.size() == 2 ? 1 : 0) != 0);
        if (since != null && fgChangeEventsByTeamAreaAndTime == null) {
            changeModel = BaseChangeEventQueryModel.ChangeEventQueryModel.ROOT;
            changeQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)changeModel);
            changeQuery.setResultLimit(maxResults);
            predicate = changeModel.modified()._gtOrEq((IDateTime)changeQuery.newDateTimeArg());
            predicate = predicate._and(changeModel.eventProcessArea()._eq(changeQuery.newItemHandleArg()));
            i = 0;
            while (i < categoryFilter.size()) {
                predicate = predicate._and(changeModel.eventCategory()._notEq((IString)changeQuery.newStringArg()));
                ++i;
            }
            changeQuery.filter(predicate);
            changeQuery.orderByDsc((IField)changeModel.eventTime());
            fgChangeEventsByTeamAreaAndTime = changeQuery;
        } else if (fgChangeEventsByTeamArea == null) {
            changeModel = BaseChangeEventQueryModel.ChangeEventQueryModel.ROOT;
            changeQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)changeModel);
            changeQuery.setResultLimit(maxResults);
            predicate = changeModel.eventProcessArea()._eq(changeQuery.newItemHandleArg());
            i = 0;
            while (i < categoryFilter.size()) {
                predicate = predicate._and(changeModel.eventCategory()._notEq((IString)changeQuery.newStringArg()));
                ++i;
            }
            changeQuery.filter(predicate);
            changeQuery.orderByDsc((IField)changeModel.eventTime());
            fgChangeEventsByTeamArea = changeQuery;
        }
        ArrayList<Object> params = new ArrayList<Object>(5);
        ItemQueryIterator<Object> query = null;
        if (since != null) {
            params.add(since);
            params.add(teamArea);
            for (String category : categoryFilter) {
                params.add(category);
            }
            query = new ItemQueryIterator(auditableCommon, fgChangeEventsByTeamAreaAndTime, params.toArray(), maxResults);
        } else {
            params.add(teamArea);
            for (String category : categoryFilter) {
                params.add(category);
            }
            query = new ItemQueryIterator<IChangeEventHandle>(auditableCommon, fgChangeEventsByTeamArea, params.toArray(), maxResults);
        }
        return query;
    }

    public static ItemQueryIterator<IChangeEventHandle> allChangeEventsByCategoryName(IAuditableCommon auditableCommon, String categoryName) {
        if (fgChangeEventsByCategoryName == null) {
            BaseChangeEventQueryModel.ChangeEventQueryModel model = BaseChangeEventQueryModel.ChangeEventQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.eventCategory()._eq((IString)query.newStringArg()));
            query.orderByDsc((IField)model.modified());
            fgChangeEventsByCategoryName = query;
        }
        return new ItemQueryIterator<IChangeEventHandle>(auditableCommon, fgChangeEventsByCategoryName, new Object[]{categoryName});
    }

    public static ItemQueryIterator<IChangeEventHandle> allChangeEventsModifiedByUser(IAuditableCommon auditableCommon, IContributorHandle user, Date since, int maxResults) {
        IPredicate predicate;
        IItemQuery query;
        BaseChangeEventQueryModel.ChangeEventQueryModel model;
        if (since != null && fgChangeEventsModifiedByUserAndTime == null) {
            model = BaseChangeEventQueryModel.ChangeEventQueryModel.ROOT;
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.setResultLimit(maxResults);
            predicate = model.modifiedBy()._eq(query.newItemHandleArg());
            predicate._and(model.modified()._gt((IDateTime)query.newDateTimeArg()));
            query.filter(predicate);
            query.orderByDsc((IField)model.eventTime());
            fgChangeEventsModifiedByUserAndTime = query;
        }
        if (since == null && fgChangeEventsModifiedByUser == null) {
            model = BaseChangeEventQueryModel.ChangeEventQueryModel.ROOT;
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            predicate = model.modifiedBy()._eq(query.newItemHandleArg());
            query.filter(predicate);
            query.orderByDsc((IField)model.eventTime());
            fgChangeEventsModifiedByUser = query;
        }
        if (since != null) {
            return new ItemQueryIterator<IChangeEventHandle>(auditableCommon, fgChangeEventsModifiedByUserAndTime, new Object[]{user, since});
        }
        return new ItemQueryIterator<IChangeEventHandle>(auditableCommon, fgChangeEventsModifiedByUser, new Object[]{user});
    }

    public static ItemQueryIterator<IChangeEventHandle> changeEventsByTimeRangeAndType(IAuditableCommon auditableCommon, Date start, Date end, IItemType type) {
        if (fgAllChangeEventsByTimeRangeAndType == null) {
            BaseChangeEventQueryModel.ChangeEventQueryModel model = BaseChangeEventQueryModel.ChangeEventQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.modified()._gtOrEq((IDateTime)query.newDateTimeArg())._and(model.modified()._lt((IDateTime)query.newDateTimeArg()))._and(model.item()._isTypeOf(query.newItemTypeArg())));
            query.orderByAsc((IField)model.eventTime());
            fgAllChangeEventsByTimeRangeAndType = query;
        }
        return new ItemQueryIterator<IChangeEventHandle>(auditableCommon, fgAllChangeEventsByTimeRangeAndType, new Object[]{start, end, type});
    }

    public static ItemQueryIterator<IWorkItemHandle> workitemsContainingOpenApprovalsWithDueDatesEarlierThan(IAuditableCommon auditableCommon, Date maxDueDate) {
        if (fgWorkItemsWithOpenApprovalsWithDueDatesEarlierThan == null) {
            BaseWorkItemQueryModel.WorkItemQueryModel model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.internalApprovalDescriptors().cumulativeStateIdentifier()._eq(WorkItemApprovals.PENDING_STATE.getIdentifier())._and(model.internalApprovalDescriptors().dueDate()._lt((IDateTime)query.newDateTimeArg())));
            fgWorkItemsWithOpenApprovalsWithDueDatesEarlierThan = query;
        }
        return new ItemQueryIterator<IWorkItemHandle>(auditableCommon, fgWorkItemsWithOpenApprovalsWithDueDatesEarlierThan, new Object[]{maxDueDate});
    }

    public static ItemQueryIterator<ISimpleFileHandle> simpleFileByPath(IAuditableCommon auditableCommon, String path) {
        if (fgSimpleFileByPath == null) {
            BaseSimpleFileQueryModel.SimpleFileQueryModel simpleFile = BaseSimpleFileQueryModel.SimpleFileQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)simpleFile);
            query.filter(simpleFile.path()._like((IString)query.newStringArg(), '\\'));
            fgSimpleFileByPath = query;
        }
        return new ItemQueryIterator<ISimpleFileHandle>(auditableCommon, fgSimpleFileByPath, new Object[]{WorkItemQueries.escapeLikeParameter(path)});
    }

    public static ItemQueryIterator<IProcessAttachmentHandle> processAttachmentByPath(IAuditableCommon auditableCommon, UUID owningItem, String path) {
        if (fgProcessAttachmentByPath == null) {
            BaseProcessAttachmentQueryModel.ProcessAttachmentQueryModel processAttachment = BaseProcessAttachmentQueryModel.ProcessAttachmentQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)processAttachment);
            query.filter(processAttachment.internalOwningItem().itemId()._eq((IUUID)query.newUUIDArg())._and(processAttachment.path()._like((IString)query.newStringArg(), '\\')));
            fgProcessAttachmentByPath = query;
        }
        return new ItemQueryIterator<IProcessAttachmentHandle>(auditableCommon, fgProcessAttachmentByPath, new Object[]{owningItem, WorkItemQueries.escapeLikeParameter(path)});
    }

    public static ItemQueryIterator<IDeliverableHandle> deliverableByProjectArea(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgDeliverableByProjectArea == null) {
            BaseDeliverableQueryModel.DeliverableQueryModel model = BaseDeliverableQueryModel.DeliverableQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg()));
            query.orderByAsc((IField)model.creationDate());
            fgDeliverableByProjectArea = query;
        }
        return new ItemQueryIterator<IDeliverableHandle>(auditableCommon, fgDeliverableByProjectArea, new Object[]{projectArea});
    }

    public static ItemQueryIterator<IDeliverableHandle> activeDeliverableByProjectArea(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgActiveDeliverableByProjectArea == null) {
            BaseDeliverableQueryModel.DeliverableQueryModel model = BaseDeliverableQueryModel.DeliverableQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.archived()._isFalse()));
            query.orderByAsc((IField)model.creationDate());
            fgActiveDeliverableByProjectArea = query;
        }
        return new ItemQueryIterator<IDeliverableHandle>(auditableCommon, fgActiveDeliverableByProjectArea, new Object[]{projectArea});
    }

    public static ItemQueryIterator<IDeliverableHandle> deliverableByName(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String name) {
        if (fgDeliverableByName == null) {
            BaseDeliverableQueryModel.DeliverableQueryModel model = BaseDeliverableQueryModel.DeliverableQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.name()._eq((IString)query.newStringArg())));
            fgDeliverableByName = query;
        }
        return new ItemQueryIterator<IDeliverableHandle>(auditableCommon, fgDeliverableByName, new Object[]{projectArea, name});
    }

    public static ItemQueryIterator<IDeliverableHandle> deliverableByArtifact(IAuditableCommon auditableCommon, IItemHandle artifact) {
        if (fgDeliverableByArtifact == null) {
            BaseDeliverableQueryModel.DeliverableQueryModel model = BaseDeliverableQueryModel.DeliverableQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.artifact()._eq(query.newItemHandleArg()));
            fgDeliverableByArtifact = query;
        }
        return new ItemQueryIterator<IDeliverableHandle>(auditableCommon, fgDeliverableByArtifact, new Object[]{artifact});
    }

    @Deprecated
    public static DataQueryIterator<String> distinctWorkItemTags(IAuditableCommon auditableCommon) {
        if (fgDistinctWorkItemTags == null) {
            BaseWorkItemQueryModel.WorkItemQueryModel model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            query.select((ISelectionElement)model.tags()).distinct();
            fgDistinctWorkItemTags = query;
        }
        return new DataQueryIterator<String>(auditableCommon, fgDistinctWorkItemTags);
    }

    public static DataQueryIterator<String> distinctWorkItemTagsByProjectArea(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgDistinctWorkItemTagsByProjectArea == null) {
            BaseWorkItemQueryModel.WorkItemQueryModel model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg()));
            query.select((ISelectionElement)model.tags()).distinct();
            fgDistinctWorkItemTagsByProjectArea = query;
        }
        return new DataQueryIterator<String>(auditableCommon, fgDistinctWorkItemTagsByProjectArea, new Object[]{projectArea});
    }

    public static DataQueryIterator<Number> maxWorkItemId(IAuditableCommon auditableCommon) {
        if (fgMaxWorkItemId == null) {
            BaseWorkItemQueryModel.WorkItemQueryModel model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            query.select(query.max((IField)model.id()));
            fgMaxWorkItemId = query;
        }
        return new DataQueryIterator<Number>(auditableCommon, fgMaxWorkItemId);
    }

    public static DataQueryIterator<Number> maxAttachmentId(IAuditableCommon auditableCommon) {
        if (fgMaxAttachmentId == null) {
            BaseAttachmentQueryModel.AttachmentQueryModel model = BaseAttachmentQueryModel.AttachmentQueryModel.ROOT;
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            query.select(query.max((IField)model.id()));
            fgMaxAttachmentId = query;
        }
        return new DataQueryIterator<Number>(auditableCommon, fgMaxAttachmentId);
    }

    public static DataQueryIterator<Number> countWorkItems(IAuditableCommon auditableCommon) {
        if (fgCountWorkItems == null) {
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)BaseWorkItemQueryModel.WorkItemQueryModel.ROOT);
            query.select(query.count());
            fgCountWorkItems = query;
        }
        return new DataQueryIterator<Number>(auditableCommon, fgCountWorkItems);
    }

    public static DataQueryIterator<String> approvalDescriptorNames(IAuditableCommon auditableCommon) {
        if (fgApprovalDescriptorNames == null) {
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)BaseWorkItemQueryModel.WorkItemQueryModel.ROOT);
            query.select((ISelectionElement)BaseWorkItemQueryModel.WorkItemQueryModel.ROOT.internalApprovalDescriptors().name()).distinct().orderByAsc((IField)BaseWorkItemQueryModel.WorkItemQueryModel.ROOT.internalApprovalDescriptors().name());
            fgApprovalDescriptorNames = query;
        }
        return new DataQueryIterator<String>(auditableCommon, fgApprovalDescriptorNames);
    }

    public static DataQueryIterator<Integer> teamAreaMemberCount(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IContributorHandle contributor) {
        if (fgTeamAreaMemberCount == null) {
            BaseTeamAreaQueryModel.TeamAreaQueryModel model = BaseTeamAreaQueryModel.TeamAreaQueryModel.ROOT;
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.contributors()._contains(query.newItemHandleArg())));
            query.distinct();
            query.select(query.count());
            fgTeamAreaMemberCount = query;
        }
        return new DataQueryIterator<Integer>(auditableCommon, fgTeamAreaMemberCount, new Object[]{projectArea, contributor});
    }

    private static String escapeLikeParameter(String prefix) {
        return prefix.replace("%", "\\%").replace("_", "\\_");
    }
}

