/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.query.BaseItemHandleQueryModel;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.repository.common.query.ast.ISingleItemQueryModel;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.model.query.BaseWorkItemQueryModel;
import com.ibm.team.workitem.common.internal.util.DataQueryIterator;
import com.ibm.team.workitem.common.internal.util.DataRowQueryIterator;
import com.ibm.team.workitem.common.internal.util.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemDataIntegrity {
    private IAuditableCommon fAuditableCommon;

    public WorkItemDataIntegrity(IAuditableCommon auditableCommon) {
        this.fAuditableCommon = auditableCommon;
    }

    public IStatus verify(IProgressMonitor monitor) throws TeamRepositoryException {
        MultiStatus status = new MultiStatus("com.ibm.team.workitem.common", 0, Messages.getString("WorkItemDataIntegrity.NAME"), null);
        BaseWorkItemQueryModel.WorkItemQueryModel model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
        status.add(this.verify(model, (BaseItemHandleQueryModel)model.projectArea(), "WorkItem.projectArea", "ProjectArea", monitor));
        status.add(this.verify(model, (BaseItemHandleQueryModel)model.category(), "WorkItem.category", "Category", monitor));
        status.add(this.verify(model, (BaseItemHandleQueryModel)model.target(), "WorkItem.target", "Iteration", monitor));
        status.add(this.verify(model, (BaseItemHandleQueryModel)model.foundIn(), "WorkItem.foundIn", "Deliverable", monitor));
        return status;
    }

    private IStatus verify(BaseWorkItemQueryModel.WorkItemQueryModel model, BaseItemHandleQueryModel property, String propertyName, String typeName, IProgressMonitor monitor) throws TeamRepositoryException {
        DataQueryIterator<UUID> missingIter = this.danglingReferences(model, property);
        if (missingIter.hasNext(monitor)) {
            StringBuilder builder = new StringBuilder();
            int size = missingIter.getResultSize(monitor);
            builder.append(NLS.bind((String)Messages.getString("WorkItemDataIntegrity.DANGLING_REFERENCES"), (Object[])new Object[]{propertyName, size, typeName}));
            builder.append('\n');
            int i = 0;
            while (i < 10 && missingIter.hasNext(monitor)) {
                UUID missing = missingIter.next(monitor);
                DataRowQueryIterator affectedItems = this.affectedItems(model, property, missing);
                String workItems = "";
                int j = 0;
                while (j < 10 && affectedItems.hasNext(monitor)) {
                    IDataRow row = affectedItems.next(monitor);
                    String tmp = NLS.bind((String)Messages.getString("WorkItemDataIntegrity.REFERENCE"), (Object[])new Object[]{row.getUUID(0).getUuidValue(), row.getInt(1)});
                    workItems = j == 0 ? tmp : NLS.bind((String)Messages.getString("WorkItemDataIntegrity.REFERENCE_LIST"), (Object[])new Object[]{workItems, tmp});
                    ++j;
                }
                if (affectedItems.hasNext(monitor)) {
                    builder.append(NLS.bind((String)Messages.getString("WorkItemDataIntegrity.DANGLING_REFERENCE_CONTINUED"), (Object[])new Object[]{typeName, missing.getUuidValue(), affectedItems.getResultSize(monitor), workItems}));
                } else {
                    builder.append(NLS.bind((String)Messages.getString("WorkItemDataIntegrity.DANGLING_REFERENCE"), (Object[])new Object[]{typeName, missing.getUuidValue(), affectedItems.getResultSize(monitor), workItems}));
                }
                builder.append('\n');
                ++i;
            }
            if (missingIter.hasNext(monitor)) {
                builder.append(Messages.getString("WorkItemDataIntegrity.CONTINUED"));
            }
            return new Status(4, "com.ibm.team.workitem.common", builder.toString().trim());
        }
        return new Status(0, "com.ibm.team.workitem.common", NLS.bind((String)Messages.getString("WorkItemDataIntegrity.NO_DANGLING_REFERENCES"), (Object[])new Object[]{propertyName}));
    }

    private DataQueryIterator<UUID> danglingReferences(BaseWorkItemQueryModel.WorkItemQueryModel model, BaseItemHandleQueryModel property) {
        IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
        query.filter(((ISingleItemQueryModel)property)._isNull()._not()._and(((ISingleItemQueryModel)property)._isMissing()));
        query.select((ISelectionElement)property.itemId());
        query.distinct();
        return new DataQueryIterator<UUID>(this.fAuditableCommon, query);
    }

    private DataRowQueryIterator affectedItems(BaseWorkItemQueryModel.WorkItemQueryModel model, BaseItemHandleQueryModel property, UUID uuid) {
        IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
        query.filter(property.itemId()._eq((IUUID)query.newUUIDArg()));
        query.select((ISelectionElement)model.itemId(), (ISelectionElement)model.id());
        return new DataRowQueryIterator(this.fAuditableCommon, query, uuid);
    }
}

