/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeoutCacheHelper<K, V> {
    private static final long TIMEOUT = 600000L;
    private ItemHandleAwareHashMap<K, V> fOldCache = new ItemHandleAwareHashMap();
    private ItemHandleAwareHashMap<K, V> fCache = new ItemHandleAwareHashMap();
    private long fTimeout = -1L;

    public synchronized void put(K key, V value) {
        this.invalidateCache();
        this.fCache.put(key, value);
        this.fOldCache.remove(key);
    }

    public synchronized V get(K key) {
        this.invalidateCache();
        if (this.fCache.containsKey(key)) {
            return this.fCache.get(key);
        }
        return this.fOldCache.get(key);
    }

    private void invalidateCache() {
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.fTimeout) {
            ItemHandleAwareHashMap<K, V> tmp = this.fOldCache;
            tmp.clear();
            this.fOldCache = this.fCache;
            this.fCache = tmp;
            this.fTimeout = currentTime + 600000L;
        }
    }
}

