/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query.util;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.ExpressionVisitor;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.SelectClause;
import com.ibm.team.workitem.common.expression.SimilarityExpression;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.expression.Statement;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.WorkItemExpression;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.expression.variables.WorkItemTypeVariable;
import com.ibm.team.workitem.common.internal.expression.ASTExpression;
import com.ibm.team.workitem.common.internal.expression.AbstractSimilarityExpression;
import com.ibm.team.workitem.common.internal.expression.EditableAttributeExpression;
import com.ibm.team.workitem.common.internal.expression.EditableTerm;
import com.ibm.team.workitem.common.internal.query.util.LinkAttributeVisitor;
import com.ibm.team.workitem.common.internal.query.util.Messages;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryUtils {
    public static Expression orderByScore(Expression expression) {
        SortCriteria sortOrder = new SortCriteria("score", false);
        return QueryUtils.createSortedStatement(expression, Collections.singletonList(sortOrder));
    }

    public static Expression createSortedStatement(Expression expression, SortCriteria[] sortCriteria) {
        return QueryUtils.createSortedStatement(expression, sortCriteria == null ? Collections.emptyList() : Arrays.asList(sortCriteria));
    }

    public static Expression createSortedStatement(Expression expression, List<SortCriteria> sortCriteria) {
        if (expression instanceof Term || expression instanceof AttributeExpression || expression instanceof AbstractSimilarityExpression) {
            return new Statement(new SelectClause(), expression, sortCriteria);
        }
        if (expression instanceof Statement) {
            Statement statement = (Statement)expression;
            SelectClause selectClause = statement.getSelectClause();
            if (selectClause == null) {
                selectClause = new SelectClause();
            }
            return new Statement(selectClause, statement.getConditions(), sortCriteria);
        }
        return expression;
    }

    public static List<String> getFulltextTerms(Expression expression) {
        if (expression == null) {
            return Collections.emptyList();
        }
        FullTextTermVisitor visitor = new FullTextTermVisitor();
        expression.accept(visitor);
        return visitor.getFullTextTerms();
    }

    public static boolean isFullTextExpression(Expression expression) {
        IsFullTextVisitor visitor = new IsFullTextVisitor();
        expression.accept(visitor);
        return visitor.hasFullTextConditions();
    }

    public static boolean isLinkExpression(Expression expression) {
        LinkAttributeVisitor visitor = new LinkAttributeVisitor();
        expression.accept(visitor);
        return visitor.getLinkDirection() != LinkAttributeVisitor.LinkDirection.NONE;
    }

    public static boolean isSortable(IQueryableAttribute attribute) {
        return attribute.getSortIdentifier() != null;
    }

    public static AttributeExpression createProjectAreaExpression(IAuditableCommon auditableCommon, IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryableAttribute projectAreaAttribute = QueryUtils.findWorkItemAttribute(projectAreaHandle, IWorkItem.PROJECT_AREA_PROPERTY, auditableCommon, monitor);
        return new AttributeExpression(projectAreaAttribute, AttributeOperation.EQUALS, projectAreaHandle);
    }

    public static VariableAttributeExpression createTypeCategoryExpression(IAuditableCommon auditableCommon, IProjectAreaHandle projectAreaHandle, String typeCategory, IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryableAttribute workItemTypeAttribute = QueryUtils.findWorkItemAttribute(projectAreaHandle, IWorkItem.TYPE_PROPERTY, auditableCommon, monitor);
        return new VariableAttributeExpression(workItemTypeAttribute, AttributeOperation.EQUALS, new WorkItemTypeVariable(typeCategory));
    }

    public static EditableTerm createScopeTerm(IAuditableCommon auditableCommon, IProjectAreaHandle projectAreaHandle, String typeCategory, IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryableAttribute projectAreaAttribute = QueryUtils.findWorkItemAttribute(projectAreaHandle, IWorkItem.PROJECT_AREA_PROPERTY, auditableCommon, monitor);
        IQueryableAttribute workItemTypeAttribute = QueryUtils.findWorkItemAttribute(projectAreaHandle, IWorkItem.TYPE_PROPERTY, auditableCommon, monitor);
        EditableTerm scope = new EditableTerm(Term.Operator.AND);
        scope.add(new EditableAttributeExpression(projectAreaAttribute, AttributeOperation.EQUALS, (Collection)Collections.singleton(projectAreaHandle)));
        scope.add(new EditableAttributeExpression(workItemTypeAttribute, AttributeOperation.EQUALS, (Collection)Collections.singleton(new WorkItemTypeVariable(typeCategory))));
        scope.setInternal(true);
        return scope;
    }

    public static Expression scopeToProjectArea(IAuditableCommon auditableCommon, Expression expression, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        AttributeExpression projectAreaScope = QueryUtils.createProjectAreaExpression(auditableCommon, projectArea, monitor);
        Term scopedTerm = new Term(Term.Operator.AND);
        scopedTerm.add(projectAreaScope);
        scopedTerm.add(QueryUtils.getConditions(expression));
        return scopedTerm;
    }

    public static Expression createFullTextExpression(IAuditableCommon auditableCommon, IProjectAreaHandle projectAreaHandle, String text, IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryableAttribute allAttribute = QueryUtils.findWorkItemAttribute(projectAreaHandle, "all", auditableCommon, monitor);
        return new AttributeExpression(allAttribute, AttributeOperation.CONTAINS, text);
    }

    public static boolean containsVariable(Expression expression, String variableId) {
        ContainsVariableVisitor visitor = new ContainsVariableVisitor(variableId);
        expression.accept(visitor);
        return visitor.isContained();
    }

    public static boolean containsAttribute(Expression expression, String attributeIdentifier) {
        ContainsAttributeVisitor visitor = new ContainsAttributeVisitor(attributeIdentifier);
        expression.accept(visitor);
        return visitor.isContained();
    }

    public static List<SortCriteria> getSortCriteria(Expression expression) {
        GetSortCriteriaVisitor visitor = new GetSortCriteriaVisitor();
        expression.accept(visitor);
        return visitor.getSortCriteria();
    }

    public static List<String> getColumnIdentifiers(Expression expression) {
        GetColumnsVisitor visitor = new GetColumnsVisitor();
        expression.accept(visitor);
        return visitor.getColumnIdentifiers();
    }

    public static IProjectAreaHandle getProjectArea(Expression expression) {
        if (expression == null) {
            return null;
        }
        GetProjectAreaVisitor visitor = new GetProjectAreaVisitor();
        expression.accept(visitor);
        return visitor.getProjectArea();
    }

    public static ASTExpression getASTExpression(Expression expression) {
        GetASTExpressionVisitor visitor = new GetASTExpressionVisitor();
        expression.accept(visitor);
        return visitor.getExpression();
    }

    public static AbstractSimilarityExpression getSimilarityExpression(Expression expression) {
        GetSimilarityExpressionVisitor visitor = new GetSimilarityExpressionVisitor();
        expression.accept(visitor);
        return visitor.getExpression();
    }

    private static IQueryableAttribute findWorkItemAttribute(IProjectAreaHandle projectAreaHandle, String attributeId, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryableAttributeFactory factory = QueryableAttributes.getFactory(IWorkItem.ITEM_TYPE);
        return factory.findAttribute(projectAreaHandle, attributeId, auditableCommon, monitor);
    }

    public static Expression getConditions(Expression expression) {
        if (expression instanceof Statement) {
            return ((Statement)expression).getConditions();
        }
        return expression;
    }

    public static IItemType getItemType(Expression expression) {
        GetItemTypeVisitor visitor = new GetItemTypeVisitor();
        expression.accept(visitor);
        return visitor.getItemType();
    }

    public static Expression removeRestrictions(Expression expression) {
        if (expression instanceof Statement) {
            return QueryUtils.removeRestrictions(((Statement)expression).getConditions());
        }
        if (expression instanceof AttributeExpression) {
            AttributeExpression attributeExpression = (AttributeExpression)expression;
            if (IWorkItem.PROJECT_AREA_PROPERTY.equals(attributeExpression.getAttributeIdentifier())) {
                return null;
            }
            if (attributeExpression instanceof VariableAttributeExpression && ((IAttributeVariable)attributeExpression.getValue()).getId().equals("typeCategory")) {
                return null;
            }
            return expression;
        }
        if (expression instanceof Term) {
            Term term = (Term)expression;
            LinkedList<Expression> filtered = new LinkedList<Expression>();
            int i = 0;
            while (i < term.expressions.length) {
                Expression processed = QueryUtils.removeRestrictions(term.expressions[i]);
                if (processed != null) {
                    filtered.add(processed);
                }
                ++i;
            }
            return filtered.size() > 0 ? new Term(term.operator, filtered.toArray(new Expression[filtered.size()])) : null;
        }
        return expression;
    }

    public static Expression addRestrictions(Expression expression, Expression projectAreaExpression, Expression typeExpression) {
        if (expression instanceof Statement) {
            return QueryUtils.restrictStatement((Statement)expression, projectAreaExpression, typeExpression);
        }
        if (expression != null && QueryUtils.containsAttribute(expression, IWorkItem.TYPE_PROPERTY)) {
            if (expression instanceof AttributeExpression) {
                return new Term(0, new Expression[]{projectAreaExpression, expression});
            }
            if (expression instanceof Term) {
                Term term = (Term)expression;
                Expression[] processed = new Expression[term.expressions.length + 1];
                System.arraycopy(term.expressions, 0, processed, 1, term.expressions.length);
                processed[0] = projectAreaExpression;
                return new Term(term.operator, processed);
            }
        } else {
            if (expression instanceof AttributeExpression) {
                return new Term(0, new Expression[]{projectAreaExpression, typeExpression, expression});
            }
            if (expression instanceof Term) {
                Term term = (Term)expression;
                Expression[] processed = new Expression[term.expressions.length + 2];
                System.arraycopy(term.expressions, 0, processed, 2, term.expressions.length);
                processed[0] = projectAreaExpression;
                processed[1] = typeExpression;
                return new Term(term.operator, processed);
            }
        }
        return expression == null ? new Term(0, new Expression[]{projectAreaExpression, typeExpression}) : expression;
    }

    private static Statement restrictStatement(Statement statement, Expression projectAreaExpression, Expression typeExpression) {
        Expression restricted = QueryUtils.addRestrictions(statement.getConditions(), projectAreaExpression, typeExpression);
        statement.setConditions(restricted);
        return statement;
    }

    public static IProjectAreaHandle findSomeProjectArea(IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IProjectArea> projectAreas = auditableCommon.findAllCachedAuditables(ItemProfile.PROJECT_AREA_DEFAULT);
        if (!projectAreas.isEmpty()) {
            return (IProjectAreaHandle)projectAreas.get(0);
        }
        projectAreas = auditableCommon.findAuditables(ItemProfile.PROJECT_AREA_DEFAULT, monitor);
        if (!projectAreas.isEmpty()) {
            return (IProjectAreaHandle)projectAreas.get(0);
        }
        throw new IllegalStateException(Messages.getString("QueryUtils.ERROR_NO_PROJECT_AREAS"));
    }

    public static Expression migrateWorkItemQuery(IEvaluationContext context, Expression expression, IProgressMonitor monitor) throws TeamRepositoryException {
        if (expression == null) {
            return null;
        }
        MigrationVisitor visitor = new MigrationVisitor();
        expression.accept(visitor);
        if (visitor.getProjectAreaExpression() != null) {
            VariableAttributeExpression typeExpression = visitor.getTypeExpression();
            if (typeExpression == null) {
                typeExpression = QueryUtils.createTypeCategoryExpression(context.getAuditableCommon(), context.getProjectArea(), "com.ibm.team.workitem.workItemType", monitor);
            }
            Term scope = new Term(0, new Expression[]{visitor.getProjectAreaExpression(), typeExpression});
            scope.setInternal(true);
            Term oldRoot = QueryUtils.getTerm(expression);
            Term newRoot = new Term(0, new Expression[]{scope, oldRoot});
            Statement statement = QueryUtils.getStatement(expression);
            statement.setConditions(newRoot);
            return statement;
        }
        return expression;
    }

    private static Statement getStatement(Expression expression) {
        if (expression instanceof Statement) {
            return (Statement)expression;
        }
        return new Statement(new SelectClause(), expression);
    }

    private static Term getTerm(Expression expression) {
        if (expression instanceof Statement) {
            return QueryUtils.getTerm(((Statement)expression).getConditions());
        }
        if (expression instanceof Term) {
            Term term = (Term)expression;
            if (term.getExpressions().size() == 1) {
                return QueryUtils.getTerm(term.getExpressions().get(0));
            }
            return (Term)expression;
        }
        Term wrapper = new Term(1, new Expression[]{expression});
        return new Term(0, new Expression[]{wrapper});
    }

    private static class ContainsAttributeVisitor
    extends ExpressionVisitor {
        private final String fAttributeIdentifier;
        private boolean fIsContained;

        public ContainsAttributeVisitor(String attributeIdentifier) {
            this.fAttributeIdentifier = attributeIdentifier;
            this.fIsContained = false;
        }

        public boolean isContained() {
            return this.fIsContained;
        }

        public boolean visit(AttributeExpression expression) {
            if (this.fAttributeIdentifier.equals(expression.getAttributeIdentifier())) {
                this.fIsContained = true;
            }
            return super.visit(expression);
        }
    }

    private static class ContainsVariableVisitor
    extends ExpressionVisitor {
        private final String fVariableId;
        private boolean fIsContained;

        public ContainsVariableVisitor(String variableId) {
            this.fVariableId = variableId;
            this.fIsContained = false;
        }

        public boolean isContained() {
            return this.fIsContained;
        }

        public boolean visit(VariableAttributeExpression expression) {
            if (this.fVariableId.equals(expression.getVariable().getId())) {
                this.fIsContained = true;
            }
            return super.visit(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FullTextTermVisitor
    extends ExpressionVisitor {
        private List<String> fFullTextTerms = new ArrayList<String>();

        private FullTextTermVisitor() {
        }

        public List<String> getFullTextTerms() {
            return this.fFullTextTerms;
        }

        @Override
        public boolean visit(AttributeExpression expression) {
            if ("all".equals(expression.getAttributeIdentifier()) && expression.getValue() != null) {
                this.fFullTextTerms.add(expression.getValue().toString());
            }
            return super.visit(expression);
        }
    }

    private static class GetASTExpressionVisitor
    extends ExpressionVisitor {
        private ASTExpression fASTExpression;

        private GetASTExpressionVisitor() {
        }

        public ASTExpression getExpression() {
            return this.fASTExpression;
        }

        public boolean visit(ASTExpression expression) {
            this.fASTExpression = expression;
            return super.visit(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetColumnsVisitor
    extends ExpressionVisitor {
        private List<String> fColumns = Collections.emptyList();

        private GetColumnsVisitor() {
        }

        public List<String> getColumnIdentifiers() {
            return this.fColumns;
        }

        @Override
        public boolean visit(SelectClause selectClause) {
            this.fColumns = selectClause.getColumnIdentifiers();
            return super.visit(selectClause);
        }
    }

    private static class GetItemTypeVisitor
    extends ExpressionVisitor {
        private IItemType fItemType = IWorkItem.ITEM_TYPE;

        private GetItemTypeVisitor() {
        }

        public IItemType getItemType() {
            return this.fItemType;
        }

        public boolean visit(SelectClause selectClause) {
            this.fItemType = selectClause.getItemType();
            return super.visit(selectClause);
        }
    }

    private static class GetProjectAreaVisitor
    extends ExpressionVisitor {
        private IProjectAreaHandle fProjectArea;

        private GetProjectAreaVisitor() {
        }

        public IProjectAreaHandle getProjectArea() {
            return this.fProjectArea;
        }

        public boolean visit(AttributeExpression expression) {
            if (IWorkItem.PROJECT_AREA_PROPERTY.equals(expression.getAttributeIdentifier())) {
                this.fProjectArea = (IProjectAreaHandle)expression.getValue();
            }
            return super.visit(expression);
        }
    }

    private static class GetSimilarityExpressionVisitor
    extends ExpressionVisitor {
        private AbstractSimilarityExpression fSimilarityExpression;

        private GetSimilarityExpressionVisitor() {
        }

        public AbstractSimilarityExpression getExpression() {
            return this.fSimilarityExpression;
        }

        public boolean visit(SimilarityExpression expression) {
            this.fSimilarityExpression = expression;
            return super.visit(expression);
        }

        public boolean visit(WorkItemExpression expression) {
            this.fSimilarityExpression = expression;
            return super.visit(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetSortCriteriaVisitor
    extends ExpressionVisitor {
        private List<SortCriteria> fSortCriteria = Collections.emptyList();

        private GetSortCriteriaVisitor() {
        }

        public List<SortCriteria> getSortCriteria() {
            return this.fSortCriteria;
        }

        @Override
        public boolean visit(Statement expression) {
            this.fSortCriteria = expression.getSortCriteria();
            return super.visit(expression);
        }
    }

    private static class IsFullTextVisitor
    extends ExpressionVisitor {
        private boolean fHasFullTextConditions = false;

        private IsFullTextVisitor() {
        }

        public boolean hasFullTextConditions() {
            return this.fHasFullTextConditions;
        }

        public boolean visit(SimilarityExpression similarityExpression) {
            this.fHasFullTextConditions = true;
            return super.visit(similarityExpression);
        }

        public boolean visit(WorkItemExpression similarityExpression) {
            this.fHasFullTextConditions = true;
            return super.visit(similarityExpression);
        }

        public boolean visit(AttributeExpression expression) {
            if ("all".equals(expression.getAttributeIdentifier())) {
                this.fHasFullTextConditions = true;
            }
            return super.visit(expression);
        }

        public boolean visit(VariableAttributeExpression expression) {
            if ("all".equals(expression.getAttributeIdentifier())) {
                this.fHasFullTextConditions = true;
            }
            return super.visit(expression);
        }
    }

    private static class MigrationVisitor
    extends ExpressionVisitor {
        private AttributeExpression fProjectAreaExpression;
        private VariableAttributeExpression fTypeExpression;

        private MigrationVisitor() {
        }

        public boolean visit(Term term) {
            if (term.isInternal()) {
                return false;
            }
            AttributeExpression projectAreaExpression = null;
            VariableAttributeExpression typeExpression = null;
            for (Expression expression : term.getExpressions()) {
                AttributeExpression ae;
                if (expression instanceof VariableAttributeExpression) {
                    VariableAttributeExpression vae = (VariableAttributeExpression)expression;
                    if (!vae.getVariable().getId().equals("typeCategory")) continue;
                    typeExpression = vae;
                    continue;
                }
                if (!(expression instanceof AttributeExpression) || !IWorkItem.PROJECT_AREA_PROPERTY.equals((ae = (AttributeExpression)expression).getAttributeIdentifier())) continue;
                projectAreaExpression = ae;
            }
            if (projectAreaExpression != null) {
                term.remove(projectAreaExpression);
                this.fProjectAreaExpression = projectAreaExpression;
            }
            if (typeExpression != null) {
                term.remove(typeExpression);
                this.fTypeExpression = typeExpression;
            }
            return super.visit(term);
        }

        public AttributeExpression getProjectAreaExpression() {
            return this.fProjectAreaExpression;
        }

        public VariableAttributeExpression getTypeExpression() {
            return this.fTypeExpression;
        }
    }
}

