/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query.util;

import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.ExpressionVisitor;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.internal.expression.QueryableLinkAttribute;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;

public class LinkAttributeVisitor
extends ExpressionVisitor {
    private boolean fSource = false;
    private boolean fTarget = false;

    public LinkDirection getLinkDirection() {
        if (this.fSource && this.fTarget) {
            return LinkDirection.BOTH;
        }
        if (this.fSource) {
            return LinkDirection.SOURCE;
        }
        if (this.fTarget) {
            return LinkDirection.TARGET;
        }
        return LinkDirection.NONE;
    }

    public boolean visit(AttributeExpression expression) {
        this.checkExpression(expression);
        return super.visit(expression);
    }

    public boolean visit(VariableAttributeExpression expression) {
        this.checkExpression(expression);
        return super.visit(expression);
    }

    private void checkExpression(AttributeExpression expression) {
        String identifier = expression.getAttributeIdentifier();
        if (QueryableLinkAttribute.isLinkAttributeIdentifier(identifier)) {
            IEndPointDescriptor descriptor = QueryableLinkAttribute.getEndPointDescriptor(identifier);
            if (WorkItemLinkTypes.isSymmetric(descriptor) || expression.getOperation() == AttributeOperation.LINK_NOT_EXISTS) {
                this.fSource = true;
                this.fTarget = true;
            } else if (descriptor.isSource()) {
                this.fSource = true;
            } else {
                this.fTarget = true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LinkDirection {
        SOURCE,
        TARGET,
        BOTH,
        NONE;

    }
}

