/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.presentations;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.common.internal.presentations.TabDescriptor;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorPresentationManager
extends CacheHelper {
    public static final String DEFAULT_EDITOR = "com.ibm.team.workitem.editor.default";
    public static final String DO_NOT_SHOW_KIND = "com.ibm.team.workitem.kind.special.doNotShow";
    public static final String SEPARATOR_KIND = "com.ibm.team.workitem.kind.separator";
    public static final String LAYOUT_BINDING = "workitemTypeEditorIdBinding";
    public static final String WORKITEM_TYPE = "workitemType";
    public static final String ATTRIBUTE = "attribute";
    public static final String ATTRIBUTE_ID = "attributeId";
    public static final String SEPARATOR = "separator";
    public static final String SIMPLE = "simple";
    public static final String SIMPLE_ID = "simpleId";
    public static final String EDITOR = "editor";
    public static final String EDITOR_ID = "editorId";
    public static final String TAB = "tab";
    public static final String TAB_ID = "tabId";
    public static final String LAYOUT = "layout";
    public static final String SECTION = "section";
    public static final String SECTION_ID = "sectionId";
    public static final String SLOT = "slot";
    public static final String PRESENTATION = "presentation";
    public static final String KIND = "kind";
    public static final String ID = "id";
    public static final String PROPERTY = "property";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String AUTOCOLLECT = "autocollect";
    public static final String HIDEIFEMPTY = "hideIfEmpty";
    public static final String READONLY = "readonly";
    public static final String CONTRIBUTOR_ATTRIBUTE_ID = "contributorAttributeId";
    public static final String WARNMESSAGE = "warningMessage";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String TITLE = "title";
    public static final String WIDTH = "width";
    public static final String TOBELINKEDPARTID = "toBeLinkedPartId";
    public static final String SMALL = "small";
    public static final String WIDE = "wide";
    public static final String[] ALL_KEYS = new String[]{"hideIfEmpty", "readonly", "warningMessage", "autocollect", "width", "toBeLinkedPartId"};
    public static final String[] ALL_VALUES = new String[]{"true", "false", "", "small", "wide"};
    private static final String EDITOR_PRESENTATION = "com.ibm.team.workitem.editor.configuration.presentations";
    private static final String EDITOR_LAYOUT_BINDING = "com.ibm.team.workitem.editor.configuration.workitemTypeEditorIdBinding";
    private Map<UUID, Map<String, List<AbstractPresentationDescriptor>>> fCachedPresentations = Collections.synchronizedMap(new HashMap());
    private Map<UUID, Map<String, String>> fCachedLayouts = Collections.synchronizedMap(new HashMap());
    private Map<UUID, Map<String, String>> fChachedTabLayouts = Collections.synchronizedMap(new HashMap());
    private Map<UUID, List<String>> fChachedEditorIds = Collections.synchronizedMap(new HashMap());
    private Map<UUID, List<String>> fChachedTabIds = Collections.synchronizedMap(new HashMap());
    private Map<UUID, List<String>> fChachedSectionIds = Collections.synchronizedMap(new HashMap());

    public EditorPresentationManager(IAuditableCommon auditableCommon) {
        super(auditableCommon);
    }

    public Map<String, List<AbstractPresentationDescriptor>> getPresentationsMap(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        Map<String, List<AbstractPresentationDescriptor>> presentations = this.fCachedPresentations.get(projectArea.getItemId());
        return presentations != null ? Collections.unmodifiableMap(presentations) : new HashMap<String, List<AbstractPresentationDescriptor>>();
    }

    public Map<String, String> getTabLayouts(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        Map<String, String> tabLayouts = this.fChachedTabLayouts.get(projectArea.getItemId());
        return tabLayouts != null ? Collections.unmodifiableMap(tabLayouts) : new HashMap<String, String>();
    }

    public List<String> getEditorIds(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        List<String> editorIds = this.fChachedEditorIds.get(projectArea.getItemId());
        return editorIds != null ? Collections.unmodifiableList(editorIds) : new ArrayList<String>();
    }

    public List<String> getTabIds(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        List<String> tabIds = this.fChachedTabIds.get(projectArea.getItemId());
        return tabIds != null ? Collections.unmodifiableList(tabIds) : new ArrayList<String>();
    }

    public List<String> getSectionIds(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        List<String> sectionIds = this.fChachedSectionIds.get(projectArea.getItemId());
        return sectionIds != null ? Collections.unmodifiableList(sectionIds) : new ArrayList<String>();
    }

    @Override
    protected void updateCache(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.updatePresentations(projectAreaHandle, monitor);
        this.updateLayoutBindings(projectAreaHandle, monitor);
    }

    private void updatePresentations(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<String, List<AbstractPresentationDescriptor>> definitions = new HashMap<String, List<AbstractPresentationDescriptor>>();
        HashMap<String, String> tabLayouts = new HashMap<String, String>();
        ArrayList<String> editorIds = new ArrayList<String>();
        ArrayList<String> tabIds = new ArrayList<String>();
        ArrayList<String> sectionIds = new ArrayList<String>();
        IAuditableCommonProcess process = this.getAuditableCommon().getProcess((IProcessAreaHandle)projectArea, monitor);
        IProcessConfigurationData processConfiguration = process.findProcessConfiguration(EDITOR_PRESENTATION, monitor);
        if (processConfiguration != null) {
            ArrayList elements = new ArrayList(Arrays.asList(processConfiguration.getElements()));
            EditorPresentationManager.readPresentations(elements, definitions, tabLayouts, editorIds, tabIds, sectionIds);
        }
        for (String key : definitions.keySet()) {
            definitions.put(key, Collections.unmodifiableList((List)definitions.get(key)));
        }
        this.fCachedPresentations.put(projectArea.getItemId(), definitions);
        this.fChachedTabLayouts.put(projectArea.getItemId(), tabLayouts);
        this.fChachedEditorIds.put(projectArea.getItemId(), editorIds);
        this.fChachedTabIds.put(projectArea.getItemId(), tabIds);
        this.fChachedSectionIds.put(projectArea.getItemId(), sectionIds);
    }

    public static void readPresentations(List<? extends ModelElement> elements, Map<String, List<AbstractPresentationDescriptor>> definitions, Map<String, String> tabLayouts, List<String> editorIds, List<String> tabIds, List<String> sectionIds) {
        for (ModelElement modelElement : elements) {
            String sectionId;
            AbstractPresentationDescriptor desc;
            String value;
            String key;
            HashMap<String, String> properties;
            Object tabId;
            String id;
            if (EDITOR.equals(modelElement.getName())) {
                id = modelElement.getAttribute(ID);
                if (id == null) continue;
                editorIds.add(id);
                for (ModelElement element : modelElement.getChildElements()) {
                    if (!TAB.equals(element.getName()) || (tabId = element.getAttribute(TAB_ID)) == null) continue;
                    String title = element.getAttribute(TITLE);
                    HashMap<String, String> properties2 = new HashMap<String, String>();
                    for (ModelElement e : element.getChildElements()) {
                        if (!PROPERTY.equals(e.getName())) continue;
                        String key2 = e.getAttribute(KEY);
                        String value2 = e.getAttribute(VALUE);
                        if (key2 == null || value2 == null) continue;
                        properties2.put(key2, value2);
                    }
                    TabDescriptor desc2 = new TabDescriptor((String)tabId, title, properties2);
                    if (definitions.get(id) == null) {
                        definitions.put(id, new ArrayList());
                    }
                    definitions.get(id).add(desc2);
                }
                continue;
            }
            if (TAB.equals(modelElement.getName())) {
                id = modelElement.getAttribute(ID);
                if (id == null) continue;
                tabIds.add(id);
                String layout = modelElement.getAttribute(LAYOUT);
                if (layout != null) {
                    tabLayouts.put(id, layout);
                }
                tabId = modelElement.getChildElements().iterator();
                while (tabId.hasNext()) {
                    String sectionId2;
                    ModelElement element = (ModelElement)tabId.next();
                    if (!SECTION.equals(element.getName()) || (sectionId2 = element.getAttribute(SECTION_ID)) == null) continue;
                    String title = element.getAttribute(TITLE);
                    String slot = element.getAttribute(SLOT);
                    properties = new HashMap<String, String>();
                    for (ModelElement e : element.getChildElements()) {
                        if (!PROPERTY.equals(e.getName())) continue;
                        key = e.getAttribute(KEY);
                        value = e.getAttribute(VALUE);
                        if (key == null || value == null) continue;
                        properties.put(key, value);
                    }
                    desc = new SectionDescriptor(sectionId2, title, slot, properties);
                    if (definitions.get(id) == null) {
                        definitions.put(id, new ArrayList());
                    }
                    definitions.get(id).add(desc);
                }
                continue;
            }
            if (!SECTION.equals(modelElement.getName()) || (sectionId = modelElement.getAttribute(ID)) == null) continue;
            sectionIds.add(sectionId);
            for (ModelElement element : modelElement.getChildElements()) {
                if (!PRESENTATION.equals(element.getName())) continue;
                String id2 = element.getAttribute(ID);
                String kind = element.getAttribute(KIND);
                String attributeId = element.getAttribute(ATTRIBUTE_ID);
                if (WorkItemAttributes.VERSION.getStringIdentifier().equals(attributeId) && "com.ibm.team.workitem.kind.enumeration".equals(kind)) {
                    kind = "com.ibm.team.workitem.kind.internal.deliverable";
                }
                if (kind == null && attributeId == null) continue;
                Identifier<IAttribute> attIdent = null;
                if (attributeId != null) {
                    attIdent = Identifier.create(IAttribute.class, attributeId);
                }
                properties = new HashMap();
                for (ModelElement e : element.getChildElements()) {
                    if (!PROPERTY.equals(e.getName())) continue;
                    key = e.getAttribute(KEY);
                    value = e.getAttribute(VALUE);
                    if (key == null || value == null) continue;
                    properties.put(key, value);
                }
                desc = new PresentationDescriptor(id2, kind, attIdent, properties);
                if (definitions.get(sectionId) == null) {
                    definitions.put(sectionId, new ArrayList());
                }
                definitions.get(sectionId).add(desc);
            }
        }
    }

    public String getEditorLayout(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle projectArea = workItem.getProjectArea();
        this.checkCache(projectArea, monitor);
        Map<String, String> layouts = this.fCachedLayouts.get(projectArea.getItemId());
        if (layouts == null || layouts.get(workItem.getWorkItemType()) == null) {
            return DEFAULT_EDITOR;
        }
        return layouts.get(workItem.getWorkItemType());
    }

    private void updateLayoutBindings(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<String, String> layouts = new HashMap<String, String>();
        IAuditableCommonProcess process = this.getAuditableCommon().getProcess((IProcessAreaHandle)projectArea, monitor);
        IProcessConfigurationData processConfiguration = process.findProcessConfiguration(EDITOR_LAYOUT_BINDING, monitor);
        if (processConfiguration != null) {
            IProcessConfigurationElement[] iProcessConfigurationElementArray = processConfiguration.getElements();
            int n = iProcessConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessConfigurationElement configurationElement = iProcessConfigurationElementArray[n2];
                if (LAYOUT_BINDING.equals(configurationElement.getName())) {
                    String workitemType = configurationElement.getAttribute(WORKITEM_TYPE);
                    String editorId = configurationElement.getAttribute(EDITOR_ID);
                    if (workitemType != null && editorId != null && layouts.get(workitemType) == null) {
                        layouts.put(workitemType, editorId);
                    }
                }
                ++n2;
            }
        }
        this.fCachedLayouts.put(projectArea.getItemId(), layouts);
    }
}

