/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.model;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.ConfigurationItemManager;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.model.WorkItemType;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.RegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemTypeManager
extends ConfigurationItemManager<WorkItemType> {
    private static final String EXTENSION_NAME = "workItemType";
    private static final String EXTENSION_POINT_ID = "com.ibm.team.workitem.common.workItemType";
    public static final String ID_ATTRIBUTE = "id";
    private static final String CATEGORY_ATTRIBUTE = "category";
    public static final String NAME_ATTRIBUTE = "name";
    private static final String ICON_ATTRIBUTE = "icon";
    private static final String DIMMEDICON_ATTRIBUTE = "dimmedicon";
    private static final String ALIAS_ELEMENT = "alias";
    private static final List<WorkItemType> fgTypes = new ArrayList<WorkItemType>();
    public static final String WORK_ITEM_TYPES_CONFIGURATION_DATA_POINT = "com.ibm.team.workitem.configuration.workItemTypes";
    public static final String TYPE_ELEMENT = "type";
    private static final String TYPE_GROUP = "types";
    private static final String TYPE_ATTRIBUTE = "type";
    public static final String CUSTOM_ATTRIBUTES_ELEMENT = "customAttributes";
    public static final String CUSTOM_ATTRIBUTE_ELEMENT = "customAttribute";
    private Map<UUID, Map<String, ItemHandleAwareHashSet>> fCustomAttributeCache = new HashMap<UUID, Map<String, ItemHandleAwareHashSet>>();
    private Map<UUID, Map<String, WorkItemType>> fStaticTypesCache = new HashMap<UUID, Map<String, WorkItemType>>();

    static {
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals(EXTENSION_NAME)) {
                        String id = element.getAttribute(ID_ATTRIBUTE);
                        String category = element.getAttribute(CATEGORY_ATTRIBUTE);
                        String name = element.getAttribute(NAME_ATTRIBUTE);
                        IConfigurationElement[] aliases = element.getChildren(ALIAS_ELEMENT);
                        ArrayList<String> aliasList = new ArrayList<String>();
                        IConfigurationElement[] iConfigurationElementArray = aliases;
                        int n = aliases.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConfigurationElement alias = iConfigurationElementArray[n2];
                            aliasList.add(alias.getAttribute(NAME_ATTRIBUTE));
                            ++n2;
                        }
                        if (id != null && category != null && name != null) {
                            String dimmedIcon;
                            URL url = null;
                            URL dimmedUrl = null;
                            String icon = element.getAttribute(ICON_ATTRIBUTE);
                            if (icon != null && icon.length() > 0 && (url = FileLocator.find((String)extensions[i].getNamespaceIdentifier(), (IPath)new Path(icon), null)) == null) {
                                try {
                                    url = new URL(icon);
                                }
                                catch (MalformedURLException x) {
                                    WorkItemCommonPlugin.log(x.getMessage(), x);
                                }
                            }
                            if ((dimmedIcon = element.getAttribute(DIMMEDICON_ATTRIBUTE)) != null && dimmedIcon.length() > 0 && (dimmedUrl = FileLocator.find((String)extensions[i].getNamespaceIdentifier(), (IPath)new Path(dimmedIcon), null)) == null) {
                                try {
                                    dimmedUrl = new URL(dimmedIcon);
                                }
                                catch (MalformedURLException x) {
                                    WorkItemCommonPlugin.log(x.getMessage(), x);
                                }
                            }
                            WorkItemTypeManager.put(id, new WorkItemType(null, id, category, Collections.<IAttributeHandle>emptyList(), name, aliasList, url, dimmedUrl));
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static WorkItemType[] getWorkItemTypes() {
        return fgTypes.toArray(new WorkItemType[fgTypes.size()]);
    }

    private static void put(String identifier, WorkItemType type) {
        fgTypes.add(type);
    }

    public WorkItemTypeManager(IAuditableCommon auditableCommon) {
        super(auditableCommon);
    }

    @Override
    public WorkItemType findConfigurationItem(IProjectAreaHandle projectArea, String identifier, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItemType type = (WorkItemType)super.findConfigurationItem(projectArea, identifier, monitor);
        if (type == null) {
            return this.findStaticConfigurationItem(projectArea, identifier);
        }
        return type;
    }

    @Override
    public WorkItemType findCachedConfigurationItem(IProjectAreaHandle projectArea, String identifier) {
        WorkItemType type = (WorkItemType)super.findCachedConfigurationItem(projectArea, identifier);
        if (type == null) {
            return this.findStaticConfigurationItem(projectArea, identifier);
        }
        return type;
    }

    private WorkItemType findStaticConfigurationItem(IProjectAreaHandle projectArea, String identifier) {
        Map<String, WorkItemType> map = this.fStaticTypesCache.get(projectArea.getItemId());
        if (map == null) {
            return null;
        }
        return map.get(identifier);
    }

    @Override
    protected String getConfigurationDataPoint() {
        return WORK_ITEM_TYPES_CONFIGURATION_DATA_POINT;
    }

    @Override
    protected String getElement() {
        return "type";
    }

    @Override
    protected String getGroupElement() {
        return TYPE_GROUP;
    }

    @Override
    protected WorkItemType readElement(IProjectAreaHandle projectArea, IProcessConfigurationElement configurationElement, IProgressMonitor monitor) throws TeamRepositoryException {
        String identifier = configurationElement.getAttribute(ID_ATTRIBUTE);
        if (identifier == null) {
            return null;
        }
        String category = configurationElement.getAttribute(CATEGORY_ATTRIBUTE);
        if (category == null) {
            return null;
        }
        String displayName = configurationElement.getAttribute(NAME_ATTRIBUTE);
        if (displayName == null) {
            return null;
        }
        IProcessConfigurationElement[] aliases = configurationElement.getChildren();
        ArrayList<String> aliasList = new ArrayList<String>();
        if (aliases != null) {
            IProcessConfigurationElement[] iProcessConfigurationElementArray = aliases;
            int n = aliases.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                IProcessConfigurationElement element = iProcessConfigurationElementArray[n2];
                if (element.getName().equals(ALIAS_ELEMENT) && (name = element.getAttribute(NAME_ATTRIBUTE)) != null) {
                    aliasList.add(name);
                }
                ++n2;
            }
        }
        String icon = configurationElement.getAttribute(ICON_ATTRIBUTE);
        URL iconURL = this.createResourceURL((IProcessContainerHandle)projectArea, icon, monitor);
        String dimmedIcon = configurationElement.getAttribute(DIMMEDICON_ATTRIBUTE);
        URL dimmedIconURL = this.createResourceURL((IProcessContainerHandle)projectArea, dimmedIcon, monitor);
        List<IAttributeHandle> attributes = Collections.emptyList();
        ItemHandleAwareHashSet list = this.getCustomAttributesMap(projectArea, monitor).get(category);
        if (list != null) {
            attributes = new ArrayList(list);
        }
        return new WorkItemType(projectArea, identifier, category, attributes, displayName, aliasList, iconURL, dimmedIconURL);
    }

    @Override
    protected List<WorkItemType> readStaticConfigurationItems(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItemType[] staticTypes;
        HashMap<String, WorkItemType> types = new HashMap<String, WorkItemType>();
        WorkItemType[] workItemTypeArray = staticTypes = WorkItemTypeManager.getWorkItemTypes();
        int n = staticTypes.length;
        int n2 = 0;
        while (n2 < n) {
            WorkItemType type = workItemTypeArray[n2];
            ItemHandleAwareHashSet list = this.getCustomAttributesMap(projectArea, monitor).get(type.getCategory());
            ArrayList<IAttributeHandle> attributes = list != null ? new ArrayList<IAttributeHandle>(list) : Collections.emptyList();
            WorkItemType newType = new WorkItemType(projectArea, type.getIdentifier(), type.getCategory(), attributes, type.getDisplayName(), type.getAliases(), type.getIconURL(), type.getDimmedIconURL());
            types.put(newType.getIdentifier(), newType);
            ++n2;
        }
        this.fStaticTypesCache.put(projectArea.getItemId(), types);
        return Collections.emptyList();
    }

    @Override
    protected void readConfigurationItems(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fCustomAttributeCache.remove(projectArea.getItemId());
        super.readConfigurationItems(projectArea, monitor);
    }

    public void updateWorkItemTypes(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            this.getAuditableCommon().resolveAuditable((IAuditableHandle)projectArea, ItemProfile.createFullProfile(IProjectArea.ITEM_TYPE), monitor);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return;
        }
        IAuditableCommonProcess process = this.getAuditableCommon().getProcess((IProcessAreaHandle)projectArea, monitor);
        IProcessConfigurationData processConfiguration = process.findProcessConfiguration(WORK_ITEM_TYPES_CONFIGURATION_DATA_POINT, null);
        HashMap<String, ItemHandleAwareHashSet> customAttributes = new HashMap<String, ItemHandleAwareHashSet>();
        if (processConfiguration != null) {
            this.computeCustomAttributes(projectArea, customAttributes, processConfiguration, true, monitor);
        }
    }

    private Map<String, ItemHandleAwareHashSet> getCustomAttributesMap(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        Map<String, ItemHandleAwareHashSet> customAttributes = this.fCustomAttributeCache.get(projectArea.getItemId());
        if (customAttributes == null) {
            IAuditableCommonProcess process = this.getAuditableCommon().getProcess((IProcessAreaHandle)projectArea, monitor);
            IProcessConfigurationData processConfiguration = process.findProcessConfiguration(WORK_ITEM_TYPES_CONFIGURATION_DATA_POINT, null);
            customAttributes = new HashMap<String, ItemHandleAwareHashSet>();
            if (processConfiguration != null) {
                this.computeCustomAttributes(projectArea, customAttributes, processConfiguration, false, monitor);
            }
            this.fCustomAttributeCache.put(projectArea.getItemId(), customAttributes);
        }
        return customAttributes;
    }

    private void computeCustomAttributes(IProjectAreaHandle projectArea, Map<String, ItemHandleAwareHashSet> customAttributes, IProcessConfigurationData processConfiguration, boolean create, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessConfigurationElement[] configurationElements = processConfiguration.getElements();
        int i = 0;
        while (i < configurationElements.length) {
            String category;
            IProcessConfigurationElement configurationElement = configurationElements[i];
            if (CUSTOM_ATTRIBUTES_ELEMENT.equals(configurationElement.getName()) && (category = configurationElement.getAttribute(CATEGORY_ATTRIBUTE)) != null) {
                ItemHandleAwareHashSet list = customAttributes.get(category);
                if (list == null) {
                    list = new ItemHandleAwareHashSet();
                    customAttributes.put(category, list);
                }
                this.computeCustomAttributes(projectArea, list, configurationElement.getChildren(), create, monitor);
            }
            ++i;
        }
    }

    private void computeCustomAttributes(IProjectAreaHandle projectArea, ItemHandleAwareHashSet customAttributes, IProcessConfigurationElement[] elements, boolean create, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = this.getAuditableCommon().getPeer(IWorkItemCommon.class);
        IProcessConfigurationElement[] iProcessConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                IAttribute attribute;
                block5: {
                    String name;
                    IProcessConfigurationElement configurationElement;
                    block4: {
                        String name2;
                        String identifier;
                        configurationElement = iProcessConfigurationElementArray[n2];
                        if (!CUSTOM_ATTRIBUTE_ELEMENT.equals(configurationElement.getName()) || (identifier = configurationElement.getAttribute(ID_ATTRIBUTE)) == null) break block3;
                        attribute = workItemCommon.findAttribute(projectArea, identifier, monitor);
                        if (attribute != null || !create) break block4;
                        String type = configurationElement.getAttribute("type");
                        if (type == null || !AttributeTypes.isSupportedCustomAttributeType(type) || (name2 = configurationElement.getAttribute(NAME_ATTRIBUTE)) == null) break block3;
                        attribute = workItemCommon.createNewAttribute(projectArea, identifier, type, "_meta", monitor);
                        attribute.setDisplayName(name2);
                        workItemCommon.saveAttribute(attribute, monitor);
                        break block5;
                    }
                    if (attribute != null && create && (name = configurationElement.getAttribute(NAME_ATTRIBUTE)) != null && !name.equals(attribute.getDisplayName())) {
                        IAttribute workingCopy = (IAttribute)attribute.getWorkingCopy();
                        workingCopy.setDisplayName(name);
                        attribute = workItemCommon.saveAttribute(workingCopy, monitor);
                    }
                }
                if (attribute != null) {
                    customAttributes.add(attribute.getItemHandle());
                }
            }
            ++n2;
        }
    }

    @Override
    public void doFlushCache(IProjectAreaHandle projectArea) {
        super.doFlushCache(projectArea);
        this.fCustomAttributeCache.remove(projectArea.getItemId());
        this.fStaticTypesCache.remove(projectArea.getItemId());
    }
}

