/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.model;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.workflow.WorkflowManager;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class TypeAttributeType
extends AttributeType {
    public TypeAttributeType(String identifier, Class instanceType, AttributeOperation[] operations) {
        super(identifier, instanceType, operations);
    }

    public Object getDefaultValue(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        return "defect";
    }

    public Object[] getValueSet(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        if (workItem == null) {
            return TypeAttributeType.findWorkItemTypes(auditableCommon, null, monitor);
        }
        IProcessAreaHandle processArea = workItemCommon.findProcessArea(workItem, monitor);
        if (!(processArea instanceof ITeamAreaHandle)) {
            return TypeAttributeType.findWorkItemTypes(auditableCommon, workItem.getProjectArea(), monitor);
        }
        WorkflowManager workflowManager = (WorkflowManager)workItemCommon.getWorkflowManager();
        String oldWorkflowId = workItem.isNewItem() ? null : (workItem.isWorkingCopy() ? workflowManager.getWorkflowId(auditableCommon.resolveAuditable(workItem, IWorkItem.SMALL_PROFILE, monitor), monitor) : workflowManager.getWorkflowId(workItem, monitor));
        return ((WorkItemCommon)workItemCommon).findAvailableWorkItemTypes((ITeamAreaHandle)processArea, oldWorkflowId, monitor);
    }

    public static Object[] findWorkItemTypes(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        List<IWorkItemType> types = workItemCommon.findWorkItemTypes(projectArea, monitor);
        ArrayList<String> identifiers = new ArrayList<String>();
        for (IWorkItemType type : types) {
            identifiers.add(type.getIdentifier());
        }
        return identifiers.toArray();
    }
}

