/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.model;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerationAttributeType
extends AttributeType {
    private Class<? extends ILiteral> fBaseType;

    public EnumerationAttributeType(String identifier, Class<? extends ILiteral> baseType) {
        super(identifier, Identifier.class, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS});
        this.fBaseType = baseType;
    }

    @Override
    public Object getNullValue(IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }

    @Override
    public Object getDefaultValue(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        IEnumeration<? extends ILiteral> enumerations = workItemCommon.resolveEnumeration(attribute, monitor);
        ILiteral def = enumerations.findDefaultEnumerationLiteral();
        return def != null ? def.getIdentifier2() : null;
    }

    @Override
    public Object[] getValueSet(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workItem == null) {
            return new Object[0];
        }
        ArrayList<Identifier<? extends ILiteral>> identifiers = new ArrayList<Identifier<? extends ILiteral>>();
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        IEnumeration<? extends ILiteral> enumerations = workItemCommon.resolveEnumeration(attribute, monitor);
        List<? extends ILiteral> items = enumerations.getEnumerationLiterals();
        for (ILiteral iLiteral : items) {
            identifiers.add(iLiteral.getIdentifier2());
        }
        return identifiers.toArray(new Identifier[identifiers.size()]);
    }

    public Class<? extends ILiteral> getEnumerationType() {
        return this.fBaseType;
    }

    @Override
    public String toString(Object value) {
        if (value instanceof Identifier) {
            return ((Identifier)value).getStringIdentifier();
        }
        throw new IllegalArgumentException("Argument must be an instance of Identifier");
    }

    @Override
    public Object valueOf(String stringValue, Object origin) {
        return Identifier.create(this.getEnumerationType(), stringValue);
    }
}

