/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.model;

import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.internal.model.Approval;
import com.ibm.team.workitem.common.internal.model.ApprovalDescriptor;
import com.ibm.team.workitem.common.internal.model.ModelFactory;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.model.impl.ApprovalDescriptorImpl;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovals;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Approvals
implements IApprovals {
    private WorkItem fWorkItem;

    public Approvals(WorkItem workItem) {
        this.fWorkItem = workItem;
    }

    @Override
    public List<IApproval> getContents() {
        return new ArrayList<IApproval>(this.fWorkItem.getInternalApprovals());
    }

    @Override
    public List<IApprovalDescriptor> getDescriptors() {
        return new ArrayList<IApprovalDescriptor>(this.fWorkItem.getInternalApprovalDescriptors());
    }

    @Override
    public List<IApproval> getContents(IApprovalDescriptor descriptor) {
        ArrayList<IApproval> approvals = new ArrayList<IApproval>();
        List allApprovals = this.fWorkItem.getInternalApprovals();
        for (IApproval approval : allApprovals) {
            if (approval.getDescriptor() != descriptor) continue;
            approvals.add(approval);
        }
        return approvals;
    }

    @Override
    public boolean contains(IApprovalDescriptor descriptor, IContributorHandle approver) {
        List approvals = this.fWorkItem.getInternalApprovals();
        for (IApproval approval : approvals) {
            if (approval.getDescriptor() != descriptor || !approval.getApprover().sameItemId((IItemHandle)approver)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isClosed(IApprovalDescriptor descriptor) {
        List<IApproval> approvals = this.getContents(descriptor);
        for (IApproval approval : approvals) {
            if (!WorkItemApprovals.PENDING_STATE.getIdentifier().equals(approval.getStateIdentifier())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isClosed(IApproval approval) {
        return !WorkItemApprovals.PENDING_STATE.getIdentifier().equals(approval.getStateIdentifier());
    }

    @Override
    public IApprovalState getCumulativeState(IApprovalDescriptor descriptor) {
        return WorkItemApprovals.getState(descriptor.getCumulativeStateIdentifier());
    }

    @Override
    public void add(IApprovalDescriptor descriptor) {
        if (!this.fWorkItem.getInternalApprovalDescriptors().contains(descriptor)) {
            this.fWorkItem.getInternalApprovalDescriptors().add(descriptor);
        }
    }

    @Override
    public boolean remove(IApprovalDescriptor descriptor) {
        List<IApproval> approvals = this.getContents(descriptor);
        for (IApproval approval : approvals) {
            this.remove(approval);
        }
        return this.fWorkItem.getInternalApprovalDescriptors().remove(descriptor);
    }

    @Override
    public void add(IApproval approval) {
        ApprovalDescriptor descriptor = null;
        List descriptors = this.fWorkItem.getInternalApprovalDescriptors();
        for (ApprovalDescriptor approvalDescriptor : descriptors) {
            if (((Approval)approval).getDescriptorId() != approvalDescriptor.getId()) continue;
            descriptor = approvalDescriptor;
            break;
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Approval descriptor with id " + ((Approval)approval).getDescriptorId() + " not found");
        }
        for (IApproval iApproval : this.fWorkItem.getApprovals().getContents(descriptor)) {
            if (!iApproval.getApprover().sameItemId((IItemHandle)approval.getApprover())) continue;
            throw new IllegalArgumentException("Approval descriptor already has an approval with the same approver");
        }
        this.fWorkItem.getInternalApprovals().add(approval);
        ((ApprovalDescriptorImpl)descriptor).updateCumulativeState();
    }

    @Override
    public boolean remove(IApproval approval) {
        ApprovalDescriptorImpl descriptor = (ApprovalDescriptorImpl)approval.getDescriptor();
        boolean result = this.fWorkItem.getInternalApprovals().remove(approval);
        if (result && descriptor != null) {
            descriptor.updateCumulativeState();
        }
        return result;
    }

    @Override
    public IApproval createApproval(IApprovalDescriptor descriptor, IContributorHandle approver) {
        Approval approval = ModelFactory.eINSTANCE.createApproval();
        Utils.initNew(approval);
        approval.setDescriptorId(((ApprovalDescriptor)descriptor).getId());
        approval.setApprover(approver);
        approval.setStateIdentifier(WorkItemApprovals.PENDING_STATE.getIdentifier());
        return approval;
    }

    @Override
    public IApprovalDescriptor createDescriptor(String typeIdentifier, String name) {
        ApprovalDescriptor descriptor2;
        int maxId = -1;
        List descriptors = this.fWorkItem.getInternalApprovalDescriptors();
        for (ApprovalDescriptor descriptor2 : descriptors) {
            if (maxId >= descriptor2.getId()) continue;
            maxId = descriptor2.getId();
        }
        descriptor2 = ModelFactory.eINSTANCE.createApprovalDescriptor();
        Utils.initNew(descriptor2);
        descriptor2.setId(maxId + 1);
        descriptor2.setTypeIdentifier(typeIdentifier);
        descriptor2.setName(name);
        descriptor2.setCumulativeStateIdentifier(WorkItemApprovals.PENDING_STATE.getIdentifier());
        this.add(descriptor2);
        return descriptor2;
    }
}

