/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.linkdetection;

import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.TextLinkDetector;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaStackTraceDetector
extends TextLinkDetector {
    protected static final String JAVA_IDENTIFIER_PATTERN = "[\\w\\p{Sc}|<init>|<clinit>|<cinit>]+";
    protected static final String JAVA_CLASS_NAME_PATTERN = "(([\\w\\p{Sc}|<init>|<clinit>|<cinit>]+\\.)*[\\w\\p{Sc}|<init>|<clinit>|<cinit>]+)";
    private static final String JAVA_LINE_SCHEME = "javaline";
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("^\\s*at\\s+(([\\w\\p{Sc}|<init>|<clinit>|<cinit>]+\\.)*[\\w\\p{Sc}|<init>|<clinit>|<cinit>]+)\\.[\\w\\p{Sc}|<init>|<clinit>|<cinit>]+\\(([\\w\\p{Sc}|<init>|<clinit>|<cinit>]+\\.java:(\\S*))\\)");

    private static URI createURI(String simpleType, int line) {
        try {
            String string = simpleType;
            if (line >= 0) {
                string = String.valueOf(string) + ":" + line;
            }
            string = URLEncoder.encode("(" + string + ")", "UTF-8");
            string = "javaline://" + string;
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return null;
    }

    public DetectedTextLink createDetectedLink(Matcher matcher) {
        URI uri = this.createURI(matcher);
        if (uri == null) {
            return null;
        }
        int linkGroup = this.getLinkGroup(matcher);
        if (linkGroup == -1) {
            return null;
        }
        int offset = matcher.start(linkGroup);
        int length = matcher.end(linkGroup) - matcher.start(linkGroup);
        return new JavaStackTraceLink(offset, length, uri);
    }

    protected URI createURI(Matcher matcher) {
        int line = this.getLineNumber(matcher);
        String typeName = this.getTypeName(matcher);
        if (typeName != null) {
            return JavaStackTraceDetector.createURI(typeName, line);
        }
        return null;
    }

    protected int getLineGroup(Matcher matcher) {
        return 4;
    }

    protected final int getLineNumber(Matcher matcher) {
        int lineGroup = this.getLineGroup(matcher);
        if (lineGroup == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(matcher.group(lineGroup));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected int getLinkGroup(Matcher matcher) {
        return 3;
    }

    protected Pattern getPattern() {
        return STACK_TRACE_PATTERN;
    }

    protected int getTypeGroup(Matcher matcher) {
        return 1;
    }

    protected final String getTypeName(Matcher matcher) {
        int typeGroup = this.getTypeGroup(matcher);
        if (typeGroup == -1) {
            return null;
        }
        String typeName = matcher.group(typeGroup);
        int innerClassIndex = typeName.indexOf(36);
        if (innerClassIndex != -1) {
            typeName = typeName.substring(0, innerClassIndex);
        }
        return typeName;
    }

    private static final class JavaStackTraceLink
    extends DetectedTextLink {
        private final URI fURI;

        JavaStackTraceLink(int offset, int length, URI uri) {
            super(offset, length);
            this.fURI = uri;
        }

        public List createURIs() {
            return Collections.singletonList(this.fURI);
        }
    }
}

