/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.internal.expression.AbstractQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.Messages;
import com.ibm.team.workitem.common.internal.expression.QueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableAttributeDescriptor;
import com.ibm.team.workitem.common.internal.expression.QueryableLinkAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableWorkItemAttribute;
import com.ibm.team.workitem.common.internal.model.ModelPackage;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.common.internal.util.QueryableAttributePath;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemQueryAttributeFactory
implements IQueryableAttributeFactory {
    private static final String COMMENT_CREATOR_PROPERTY = ModelPackage.eINSTANCE.getComment_Creator().getName();
    private static final String APPROVAL_DESC_TYPE_IDENTIFIER_PROPERTY = ModelPackage.eINSTANCE.getApprovalDescriptor_TypeIdentifier().getName();
    private static final String APPROVAL_DESC_CUMULATIVE_STATE_IDENTIFIER_PROPERTY = ModelPackage.eINSTANCE.getApprovalDescriptor_CumulativeStateIdentifier().getName();
    private static final String APPROVAL_DESC_DUE_DATE_PROPERTY = ModelPackage.eINSTANCE.getApprovalDescriptor_DueDate().getName();
    public static final String APPROVAL_DESC_NAME_PROPERTY = ModelPackage.eINSTANCE.getApprovalDescriptor_Name().getName();
    private static final String APPROVAL_STATE_IDENTIFIER_PROPERTY = ModelPackage.eINSTANCE.getApproval_StateIdentifier().getName();
    private static final String APPROVAL_APPROVER_PROPERTY = ModelPackage.eINSTANCE.getApproval_Approver().getName();
    private static QueryableAttributeDescriptor[] SYNTHETIC_WORKITEM_ATTRIBUTES = new QueryableAttributeDescriptor[]{new QueryableAttributeDescriptor("all", Messages.getString("WorkItemQueryAttributeFactory.FULL_TEXT_PROPERTY"), "string", true, false, new AttributeOperation[]{AttributeOperation.CONTAINS}), new QueryableAttributeDescriptor("score", Messages.getString("WorkItemQueryAttributeFactory.SCORE_PROPERTY"), "float", true, false), new QueryableAttributeDescriptor("teamArea", Messages.getString("WorkItemQueryAttributeFactory.TEAM_AREA_PROPERTY"), "teamArea", true, false), new QueryableAttributeDescriptor("stateGroup", Messages.getString("WorkItemQueryAttributeFactory.STATE_GROUP_PROPERTY"), "integer", true, false)};
    private static QueryableAttributeDescriptor[] APPROVAL_ATTRIBUTES = new QueryableAttributeDescriptor[]{new QueryableAttributeDescriptor(APPROVAL_APPROVER_PROPERTY, Messages.getString("WorkItemQueryAttributeFactory.APPROVAL_APPROVER_PROPERTY"), "contributor", false, true), new QueryableAttributeDescriptor(APPROVAL_STATE_IDENTIFIER_PROPERTY, Messages.getString("WorkItemQueryAttributeFactory.APPROVAL_STATE_PROPERTY"), "approvalState")};
    private static QueryableAttributeDescriptor[] APPROVAL_DESCRIPTOR_ATTRIBUTES = new QueryableAttributeDescriptor[]{new QueryableAttributeDescriptor(APPROVAL_DESC_CUMULATIVE_STATE_IDENTIFIER_PROPERTY, Messages.getString("WorkItemQueryAttributeFactory.AD_CUMULATIVE_STATE_PROPERTY"), "approvalState"), new QueryableAttributeDescriptor(APPROVAL_DESC_DUE_DATE_PROPERTY, Messages.getString("WorkItemQueryAttributeFactory.AD_DUE_DATE_PROPERTY"), "timestamp", false, true), new QueryableAttributeDescriptor(APPROVAL_DESC_TYPE_IDENTIFIER_PROPERTY, Messages.getString("WorkItemQueryAttributeFactory.AD_TYPE_PROPERTY"), "approvalType"), new QueryableAttributeDescriptor(APPROVAL_DESC_NAME_PROPERTY, Messages.getString("WorkItemQueryAttributeFactory.AD_NAME_PROPERTY"), "smallString")};
    private static QueryableAttributeDescriptor[] COMMENTS_ATTRIBUTES = new QueryableAttributeDescriptor[]{new QueryableAttributeDescriptor(COMMENT_CREATOR_PROPERTY, Messages.getString("WorkItemQueryAttributeFactory.COMMENT_CREATED_BY_PROPERTY"), "contributor")};
    private static QueryableAttributeDescriptor[] ITERATION_ATTRIBUTES = new QueryableAttributeDescriptor[]{new QueryableAttributeDescriptor(IterationsHelper.ITERATION_NAME_PROPERTY, Messages.getString("WorkItemQueryAttributeFactory.ITERATION_NAME_PROPERTY"), "smallString"), new QueryableAttributeDescriptor(IterationsHelper.ITERATION_START_DATE_PROPERTY, Messages.getString("WorkItemQueryAttributeFactory.ITERATION_START_DATE_PROPERTY"), "timestamp", false, true), new QueryableAttributeDescriptor(IterationsHelper.ITERATION_END_DATE_PROPERTY, Messages.getString("WorkItemQueryAttributeFactory.ITERATION_END_DATE_PROPERTY"), "timestamp", false, true)};
    private static Map<String, QueryableAttributeDescriptor[]> fgDescriptorMap = new HashMap<String, QueryableAttributeDescriptor[]>();
    private static Map<String, IItemType> fgItemTypeMap;

    static {
        fgDescriptorMap.put("approvals", APPROVAL_ATTRIBUTES);
        fgDescriptorMap.put("approvalDescriptors", APPROVAL_DESCRIPTOR_ATTRIBUTES);
        fgDescriptorMap.put("comments", COMMENTS_ATTRIBUTES);
        fgDescriptorMap.put("interval", ITERATION_ATTRIBUTES);
        fgItemTypeMap = new HashMap<String, IItemType>();
        fgItemTypeMap.put("contributor", IContributor.ITEM_TYPE);
    }

    @Override
    public IQueryableAttribute findAttribute(IProjectAreaHandle projectArea, String attributeIdentifier, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IEndPointDescriptor endPoint;
        AbstractQueryableAttribute queryAttribute = null;
        String[] path = QueryableAttributePath.createPath(attributeIdentifier);
        String rootAttribute = path[0];
        if (QueryableLinkAttribute.isLinkAttributeIdentifier(rootAttribute) && (endPoint = QueryableLinkAttribute.getEndPointDescriptor(rootAttribute)) != null) {
            queryAttribute = this.createLinkAttribute(endPoint, projectArea, auditableCommon, monitor);
        }
        if (queryAttribute == null) {
            IWorkItemCommon workItemCommon;
            IAttribute attribute;
            QueryableAttributeDescriptor[] queryableAttributeDescriptorArray = SYNTHETIC_WORKITEM_ATTRIBUTES;
            int n = SYNTHETIC_WORKITEM_ATTRIBUTES.length;
            int n2 = 0;
            while (n2 < n) {
                QueryableAttributeDescriptor descriptor = queryableAttributeDescriptorArray[n2];
                if (descriptor.getIdentifier().equals(rootAttribute)) {
                    queryAttribute = this.createQueryAttribute(null, descriptor, auditableCommon, monitor);
                    break;
                }
                ++n2;
            }
            if (queryAttribute == null && (attribute = (workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class)).findAttribute(projectArea, rootAttribute, monitor)) != null && !attribute.isInternal()) {
                QueryableWorkItemAttribute workItemAttribute = new QueryableWorkItemAttribute(attribute);
                workItemAttribute.setNullValue(attribute.getNullValue(auditableCommon, monitor));
                queryAttribute = workItemAttribute;
            }
            this.createChildAttributes(projectArea, queryAttribute, auditableCommon, monitor);
        }
        if (path.length > 1) {
            return QueryableAttributePath.getAttribute(queryAttribute, QueryableAttributePath.removeFirstSegment(path));
        }
        return queryAttribute;
    }

    public List findAllAttributes(IProjectAreaHandle projectArea, IQueryableAttribute parent, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<AbstractQueryableAttribute> attributes = new ArrayList<AbstractQueryableAttribute>();
        List<IAttribute> workItemAttributes = this.findAttributes(auditableCommon, projectArea, monitor);
        for (IAttribute attribute : workItemAttributes) {
            if (attribute.isInternal()) continue;
            QueryableWorkItemAttribute queryAttribute = new QueryableWorkItemAttribute(parent, attribute);
            queryAttribute.setNullValue(attribute.getNullValue(auditableCommon, monitor));
            this.createChildAttributes(projectArea, queryAttribute, auditableCommon, monitor);
            attributes.add(queryAttribute);
        }
        QueryableAttributeDescriptor[] queryableAttributeDescriptorArray = SYNTHETIC_WORKITEM_ATTRIBUTES;
        int n = SYNTHETIC_WORKITEM_ATTRIBUTES.length;
        int n2 = 0;
        while (n2 < n) {
            QueryableAttributeDescriptor descriptor = queryableAttributeDescriptorArray[n2];
            QueryableAttribute queryAttribute = this.createQueryAttribute(parent, descriptor, auditableCommon, monitor);
            attributes.add(queryAttribute);
            ++n2;
        }
        if (parent == null) {
            Collection links = ILinkTypeRegistry.INSTANCE.allEntries();
            for (ILinkType linkType : links) {
                QueryableLinkAttribute linkAttribute;
                IEndPointDescriptor target;
                IEndPointDescriptor source = linkType.getSourceEndPointDescriptor();
                if (this.isSupported(source, target = linkType.getTargetEndPointDescriptor())) {
                    linkAttribute = this.createLinkAttribute(target, projectArea, auditableCommon, monitor);
                    attributes.add(linkAttribute);
                }
                if (WorkItemLinkTypes.isSymmetric(source) || !this.isSupported(target, source)) continue;
                linkAttribute = this.createLinkAttribute(source, projectArea, auditableCommon, monitor);
                attributes.add(linkAttribute);
            }
        }
        return attributes;
    }

    private QueryableLinkAttribute createLinkAttribute(IEndPointDescriptor endPoint, IProjectAreaHandle projectArea, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        QueryableLinkAttribute linkAttribute = new QueryableLinkAttribute(endPoint);
        linkAttribute.setChildAttributes(this.createChildAttributes(projectArea, linkAttribute, endPoint.getReferencedItemType(), auditableCommon, monitor));
        return linkAttribute;
    }

    private boolean isSupported(IEndPointDescriptor source, IEndPointDescriptor target) {
        return source.getReferencedItemType() == IWorkItem.ITEM_TYPE;
    }

    private List<IAttribute> findAttributes(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        if (projectArea != null) {
            return workItemCommon.findAttributes(projectArea, monitor);
        }
        projectArea = QueryUtils.findSomeProjectArea(auditableCommon, monitor);
        List<IAttributeHandle> attributeHandles = workItemCommon.findBuiltInAttributes(projectArea, monitor);
        return auditableCommon.resolveAuditables(attributeHandles, IAttribute.FULL_PROFILE, monitor);
    }

    private void createChildAttributes(IProjectAreaHandle projectArea, AbstractQueryableAttribute parent, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        if (parent == null || parent.getAttributeType() == null) {
            return;
        }
        ArrayList<IQueryableAttribute> children = new ArrayList<IQueryableAttribute>();
        QueryableAttributeDescriptor[] descriptors = fgDescriptorMap.get(parent.getAttributeType());
        if (descriptors != null) {
            QueryableAttributeDescriptor[] queryableAttributeDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                QueryableAttributeDescriptor descriptor = queryableAttributeDescriptorArray[n2];
                QueryableAttribute childAttribute = this.createQueryAttribute(parent, descriptor, auditableCommon, monitor);
                this.createChildAttributes(projectArea, childAttribute, auditableCommon, monitor);
                children.add(childAttribute);
                ++n2;
            }
        }
        IItemType itemType = fgItemTypeMap.get(parent.getAttributeType());
        children.addAll(this.createChildAttributes(projectArea, parent, itemType, auditableCommon, monitor));
        parent.setChildAttributes(children);
    }

    private List<IQueryableAttribute> createChildAttributes(IProjectAreaHandle projectArea, AbstractQueryableAttribute parent, IItemType itemType, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        if (parent == null || itemType == null) {
            return Collections.emptyList();
        }
        ArrayList<IQueryableAttribute> children = new ArrayList<IQueryableAttribute>();
        IQueryableAttributeFactory factory = QueryableAttributes.getFactory(itemType);
        List<IQueryableAttribute> attributes = factory.findAllAttributes(projectArea, parent, auditableCommon, monitor);
        children.addAll(attributes);
        return children;
    }

    private QueryableAttribute createQueryAttribute(IQueryableAttribute parent, QueryableAttributeDescriptor descriptor, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        QueryableAttribute attribute = new QueryableAttribute(parent, descriptor);
        if (attribute.hasNullValue()) {
            AttributeType type = AttributeTypes.getAttributeType(attribute.getAttributeType());
            attribute.setNullValue(type.getNullValue(auditableCommon, monitor));
        }
        return attribute;
    }

    public ItemProfile<IWorkItem> computeProfile(List<IQueryableAttribute> attributes) {
        HashSet<String> properties = new HashSet<String>(AuditablesHelper.AUDITABLE_SMALL_PROFILE);
        properties.add(IWorkItem.PROJECT_AREA_PROPERTY);
        properties.add(IWorkItem.WORKFLOW_SURROGATE_PROPERTY);
        properties.add(IWorkItem.ID_PROPERTY);
        properties.add(IWorkItem.STATE_PROPERTY);
        properties.add(IWorkItem.TYPE_PROPERTY);
        properties.add(IWorkItem.DURATION_PROPERTY);
        properties.add(WorkItem.CORRECTED_ESTIMATE_PROPERTY);
        properties.add(WorkItem.TIME_SPENT_PROPERTY);
        boolean hasCustomAttributes = false;
        for (IQueryableAttribute attribute : attributes) {
            if (attribute.isStateExtension()) {
                hasCustomAttributes = true;
                continue;
            }
            if (attribute.isSynthetic()) continue;
            properties.add(attribute.getIdentifier());
        }
        if (hasCustomAttributes) {
            properties.addAll(IWorkItem.CUSTOM_ATTRIBUTE_PROPERTIES);
        }
        return ItemProfile.createProfile(IWorkItem.ITEM_TYPE, properties);
    }

    @Override
    public List<String> getDefaultAttributeSet(IQueryableAttributeFactory.AttributeSet set) {
        return Arrays.asList(IWorkItem.TYPE_PROPERTY, IWorkItem.ID_PROPERTY, IWorkItem.STATE_PROPERTY, IWorkItem.PRIORITY_PROPERTY, IWorkItem.SEVERITY_PROPERTY, IWorkItem.SUMMARY_PROPERTY, IWorkItem.OWNER_PROPERTY, IWorkItem.CREATOR_PROPERTY);
    }
}

