/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.internal.expression.IAttributeValue;
import com.ibm.team.workitem.common.internal.expression.IPersistableElement;
import com.ibm.team.workitem.common.internal.expression.ISerializationContext;
import com.ibm.team.workitem.common.internal.expression.IXMLElementKeys;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import org.eclipse.core.runtime.Assert;

public class AttributeValueFactory
implements IXMLElementKeys {
    private static final AttributeValueFactory fgInstance = new AttributeValueFactory();

    public static AttributeValueFactory getInstance() {
        return fgInstance;
    }

    private AttributeValueFactory() {
    }

    public IAttributeValue getValue() {
        return new ConstantValue();
    }

    public IAttributeValue getValue(String type, Object value) {
        if (value instanceof IAttributeValue) {
            return (IAttributeValue)value;
        }
        AttributeType attributeType = AttributeTypes.getAttributeType(type);
        return new ConstantValue(attributeType, value);
    }

    private static class ConstantValue
    implements IAttributeValue {
        private AttributeType fAttributeType;
        private Object fValue;

        public ConstantValue() {
        }

        public ConstantValue(AttributeType type, Object value) {
            Assert.isNotNull((Object)type);
            this.fAttributeType = type;
            this.fValue = value;
        }

        public void init(IPersistableElement element, ISerializationContext context) throws SerializationException {
            IPersistableElement value;
            IPersistableElement iPersistableElement = value = "value".equals(element.getName()) ? element : null;
            if (value == null && element.hasChild("value")) {
                value = element.getChild("value");
            }
            if (value != null) {
                IPersistableElement attribute = element.getChild("attribute");
                String name = attribute.getAttribute("name");
                String type = value.getAttribute("type");
                String content = value.getAttribute("content");
                this.fAttributeType = AttributeTypes.getAttributeType(context.getAttributeType(name, type));
                String valueString = context.getValue(name, type, content);
                this.fValue = this.fAttributeType.valueOf(valueString, context.getOrigin());
            } else {
                this.fAttributeType = null;
                this.fValue = null;
            }
        }

        public void saveState(IPersistableElement element) throws SerializationException {
            if (this.fValue != null) {
                IPersistableElement value = element.createChild("value");
                value.setAttribute("type", this.fAttributeType.getIdentifier());
                value.setAttribute("content", this.fAttributeType.toString(this.fValue));
            }
        }

        public Object getValue() {
            return this.fValue;
        }
    }
}

