/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.variables.AttributeVariableFactory;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueryableAttribute
implements IQueryableAttribute {
    private List<IQueryableAttribute> fChildAttributes;
    private IQueryableAttribute fParent;

    public AbstractQueryableAttribute(IQueryableAttribute parent) {
        this.fParent = parent;
    }

    @Override
    public IQueryableAttribute getParent() {
        return this.fParent;
    }

    @Override
    public List<AttributeOperation> getOperators() {
        return Arrays.asList(AttributeTypes.getAttributeType(this.getAttributeType()).getOperations());
    }

    @Override
    public List<? extends IAttributeVariable<?>> getVariables() {
        String[] variableIdentifiers;
        ArrayList variables = new ArrayList();
        String[] stringArray = variableIdentifiers = AttributeTypes.getAttributeType(this.getAttributeType()).getVariables();
        int n = variableIdentifiers.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            IAttributeVariable<?> variable = AttributeVariableFactory.getInstance().getVariable(id);
            if (variable != null) {
                variables.add(variable);
            }
            ++n2;
        }
        return variables;
    }

    @Override
    public List<IQueryableAttribute> getChildAttributes() {
        if (this.fChildAttributes != null) {
            return this.fChildAttributes;
        }
        return Collections.emptyList();
    }

    void setChildAttributes(List<IQueryableAttribute> childAttributes) {
        this.fChildAttributes = childAttributes;
    }

    @Override
    public Object getValue(Object element) {
        return null;
    }

    @Override
    public String getSortIdentifier() {
        if (this.isSynthetic()) {
            return null;
        }
        AttributeType type = AttributeTypes.getAttributeType(this.getAttributeType());
        if (IItemHandle.class.isAssignableFrom(type.getInstanceType())) {
            return "name";
        }
        return "";
    }
}

