/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.ISaveParameter;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.Messages;
import com.ibm.team.workitem.common.internal.RequiredPropertiesManager;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.core.runtime.IProgressMonitor;

public class RequiredPropertiesAdvisor
implements IOperationAdvisor {
    public static final String ID = "com.ibm.team.workitem.advisor.requiredProperties";

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object data = operation.getOperationData();
        if (data instanceof ISaveParameter) {
            ISaveParameter saveParameter = (ISaveParameter)data;
            this.addProblems(advisorConfiguration, saveParameter, collector, monitor);
        }
    }

    private void addProblems(IProcessConfigurationElement advisorConfiguration, ISaveParameter saveParameter, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditable auditable = saveParameter.getNewState();
        if (auditable instanceof IWorkItem) {
            IWorkItem workItem;
            IAuditableCommon auditableCommon = saveParameter.getSaveOperationParameter().getAuditableCommon();
            IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
            IWorkItemType workItemType = workItemCommon.findWorkItemType((workItem = (IWorkItem)auditable).getProjectArea(), workItem.getWorkItemType(), monitor);
            if (workItemType == null) {
                return;
            }
            List<String> list = RequiredPropertiesManager.readAdvisorConfiguration(workItemType, advisorConfiguration);
            String[] properties = list.toArray(new String[list.size()]);
            int i = 0;
            while (i < properties.length) {
                IWorkItem oldState;
                IAttribute attribute = workItemCommon.findAttribute(workItem.getProjectArea(), properties[i], monitor);
                if (!(attribute == null || !workItem.isAttributeSet(attribute) || saveParameter.getOldState() instanceof IWorkItem && (oldState = (IWorkItem)saveParameter.getOldState()).isAttributeSet(attribute) && this.equals(this.getValue(workItem, attribute), this.getValue(oldState, attribute)) || !this.equals(this.getValue(workItem, attribute), attribute.getNullValue(auditableCommon, monitor)))) {
                    TimeZone userTimeZone = saveParameter.getSaveOperationParameter().getUserTimeZone();
                    IAdvisorInfo info = collector.createProblemInfo(this.getSummary(attribute), this.getDescription(workItem, attribute, userTimeZone), ID);
                    info.setProblemObject((Object)workItem.getItemHandle());
                    info.setData(attribute.getIdentifier());
                    collector.addInfo((IReportInfo)info);
                }
                ++i;
            }
        }
    }

    private Object getValue(IWorkItem workItem, IAttribute attribute) {
        Object value = workItem.getValue(attribute);
        if (AttributeTypes.STRING_TYPES.contains(attribute.getAttributeType()) && value instanceof String) {
            value = ((String)value).trim();
        } else if (AttributeTypes.HTML_TYPES.contains(attribute.getAttributeType()) && value instanceof String) {
            value = XMLString.createFromXMLText((String)((String)value)).getPlainText().trim();
        }
        return value;
    }

    private boolean equals(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        if (left instanceof IItemHandle && right instanceof IItemHandle) {
            return ((IItemHandle)left).sameItemId((IItemHandle)right);
        }
        return left.equals(right);
    }

    private String getSummary(IAttribute attribute) {
        return NLS.bind((String)Messages.getString("RequiredPropertiesAdvisor.ATTRIBUTE_NOT_SET_SUMMARY"), (Object[])new Object[]{attribute.getDisplayName()});
    }

    private String getDescription(IWorkItem workItem, IAttribute attribute, TimeZone userTimeZone) {
        return NLS.bind((String)Messages.getString("RequiredPropertiesAdvisor.ATTRIBUTE_NOT_SET_DESCRIPTION"), (Object[])new Object[]{attribute.getDisplayName(), WorkItemTextUtilities.formatWorkItemId(workItem, userTimeZone)});
    }
}

