/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.model.Category;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProcessAreaCacheManager {
    private IAuditableCommon fAuditableCommon;
    private Object fLock = new Object();
    private Map<UUID, UUID> fLastSeenStates = new HashMap<UUID, UUID>();
    private Map<UUID, Map<String, IProcessAreaHandle>> fCachedProcessAreas = new HashMap<UUID, Map<String, IProcessAreaHandle>>();

    public ProcessAreaCacheManager(IAuditableCommon auditableCommon) {
        this.fAuditableCommon = auditableCommon;
    }

    public IProcessAreaHandle findProcessArea(IProjectAreaHandle projectAreaHandle, IIterationHandle intervalHandle, ICategoryHandle categoryHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessAreaHandle processAreaHandle = this.getCachedProcessAreaHandle(projectAreaHandle, intervalHandle, categoryHandle);
        if (processAreaHandle == null) {
            processAreaHandle = this.updateCache(projectAreaHandle, intervalHandle, categoryHandle, monitor);
        }
        return processAreaHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProcessAreaHandle updateCache(IProjectAreaHandle projectArea, IIterationHandle target, ICategoryHandle category, IProgressMonitor monitor) throws TeamRepositoryException {
        ICategory resolved = this.getAuditableCommon().resolveAuditable(category, ICategory.DEFAULT_PROFILE, monitor);
        Object object = this.fLock;
        synchronized (object) {
            this.fLastSeenStates.put(resolved.getItemId(), resolved.getStateId());
        }
        IDevelopmentLineHandle developmentLine = null;
        if (target != null) {
            IIteration interval = this.getAuditableCommon().resolveAuditable((IAuditableHandle)target, ItemProfile.ITERATION_DEFAULT, monitor);
            developmentLine = interval.getDevelopmentLine();
        }
        IProcessAreaHandle processArea = this.findProcessArea(resolved, developmentLine, monitor);
        Object object2 = this.fLock;
        synchronized (object2) {
            Map<String, IProcessAreaHandle> processAreas = this.fCachedProcessAreas.get(projectArea.getItemId());
            if (processAreas == null) {
                processAreas = new HashMap<String, IProcessAreaHandle>();
                this.fCachedProcessAreas.put(projectArea.getItemId(), processAreas);
            }
            processAreas.put(this.createKey(target, category), processArea);
        }
        return processArea;
    }

    private IProcessAreaHandle findProcessArea(ICategory category, IDevelopmentLineHandle developmentLine, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamAreaHandle teamArea2;
        if (developmentLine != null) {
            for (ITeamAreaHandle teamArea2 : ((Category)category).getTeamAreas()) {
                IDevelopmentLine line = this.getAuditableCommon().getDevelopmentLine(teamArea2, monitor);
                if (!developmentLine.sameItemId((IItemHandle)line)) continue;
                return teamArea2;
            }
        }
        if ((teamArea2 = ((Category)category).getDefaultTeamArea()) != null) {
            return teamArea2;
        }
        return category.getProjectArea();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProcessAreaHandle getCachedProcessAreaHandle(IProjectAreaHandle projectAreaHandle, IIterationHandle intervalHandle, ICategoryHandle categoryHandle) {
        Object object = this.fLock;
        synchronized (object) {
            Map<String, IProcessAreaHandle> processAreaMap = this.fCachedProcessAreas.get(projectAreaHandle.getItemId());
            return processAreaMap != null ? processAreaMap.get(this.createKey(intervalHandle, categoryHandle)) : null;
        }
    }

    private String createKey(IIterationHandle intervalHandle, ICategoryHandle categoryHandle) {
        return String.valueOf(this.createKey((IItemHandle)intervalHandle)) + this.createKey((IItemHandle)categoryHandle);
    }

    private String createKey(IItemHandle handle) {
        return handle != null ? handle.getItemId().getUuidValue() : "null";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IAuditable> void update(List<T> auditables, IProgressMonitor monitor) throws TeamRepositoryException {
        for (IAuditable auditable : auditables) {
            if (!(auditable instanceof ICategory) || !auditable.isPropertySet(ICategory.PROJECT_AREA_PROPERTY)) continue;
            ICategory category = (ICategory)auditable;
            IProjectAreaHandle projectArea = category.getProjectArea();
            Object object = this.fLock;
            synchronized (object) {
                if (projectArea != null && this.fLastSeenStates.containsKey(category.getItemId()) && !category.getStateId().equals((Object)this.fLastSeenStates.get(category.getItemId()))) {
                    this.fLastSeenStates.put(category.getItemId(), category.getStateId());
                    this.fCachedProcessAreas.remove(projectArea.getItemId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache(IProjectAreaHandle projectArea) {
        Object object = this.fLock;
        synchronized (object) {
            this.fCachedProcessAreas.remove(projectArea.getItemId());
        }
    }

    private IAuditableCommon getAuditableCommon() {
        return this.fAuditableCommon;
    }
}

