/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.workitem.common.internal.model.ConfigurationItem;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enumeration<T extends ILiteral>
implements IEnumeration<T> {
    private List<T> fLiterals;
    private T fDefaultLiteral;

    public Enumeration(List<T> literals) {
        this.fLiterals = Collections.unmodifiableList(literals);
        for (ILiteral literal : this.fLiterals) {
            if (!((ConfigurationItem)literal).isDefault()) continue;
            this.fDefaultLiteral = literal;
            break;
        }
    }

    @Override
    public T findEnumerationLiteral(Identifier<? extends ILiteral> identifier) {
        for (ILiteral literal : this.fLiterals) {
            if (!literal.getIdentifier2().equals(identifier)) continue;
            return (T)literal;
        }
        return null;
    }

    @Override
    public List<T> getEnumerationLiterals() {
        return this.fLiterals;
    }

    @Override
    public T findDefaultEnumerationLiteral() {
        return this.fDefaultLiteral;
    }
}

