/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression.variables;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.expression.variables.AbstractAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.expression.variables.Messages;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyCategoriesVariable
extends AbstractAttributeVariable<ICategoryHandle> {
    public static final String VARIABLE_ID = "my categories";
    private Collection<ICategoryHandle> fCategories;
    private boolean fIsCaching;

    public MyCategoriesVariable() {
        this(false);
    }

    public MyCategoriesVariable(boolean isCaching) {
        this.fIsCaching = isCaching;
    }

    @Override
    public Collection<ICategoryHandle> evaluate(IEvaluationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fCategories == null || !this.fIsCaching) {
            ArrayList<ICategoryHandle> categories = new ArrayList<ICategoryHandle>();
            ItemQueryIterator<ICategoryHandle> iterator = WorkItemQueries.categoriesByContributor(context.getAuditableCommon(), context.getAuditableCommon().getUser());
            while (iterator.hasNext(monitor)) {
                categories.add(iterator.next(monitor));
            }
            if (categories.isEmpty()) {
                IWorkItemCommon workItemCommon = context.getAuditableCommon().getPeer(IWorkItemCommon.class);
                IAttribute categoryAttribute = workItemCommon.findAttribute(context.getProjectArea(), IWorkItem.CATEGORY_PROPERTY, monitor);
                this.fCategories = Collections.singleton((ICategoryHandle)categoryAttribute.getNullValue(context.getAuditableCommon(), monitor));
            } else {
                this.fCategories = categories;
            }
        }
        return this.fCategories;
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("MyCategoriesVariable.MY_CATEGORIES");
    }

    @Override
    public String getId() {
        return VARIABLE_ID;
    }

    public boolean equals(Object obj) {
        return obj instanceof MyCategoriesVariable;
    }

    public int hashCode() {
        return VARIABLE_ID.hashCode();
    }
}

