/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression;

import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.ExpressionVisitor;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.Messages;
import com.ibm.team.workitem.common.expression.ProgressExpressionVisitor;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.expression.AttributeValueFactory;
import com.ibm.team.workitem.common.internal.expression.IAttributeValue;
import com.ibm.team.workitem.common.internal.expression.IPersistableElement;
import com.ibm.team.workitem.common.internal.expression.ISerializationContext;
import com.ibm.team.workitem.common.internal.expression.QueryableWorkItemAttribute;
import com.ibm.team.workitem.common.internal.util.QueryableAttributePath;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AttributeExpression
extends Expression {
    private IQueryableAttribute fAttribute;
    private AttributeOperation fOperator;
    private IAttributeValue fValueProxy;
    private String fAttributeIdentifier;
    private IItemType fItemType;

    public AttributeExpression() {
    }

    public AttributeExpression(IQueryableAttribute attribute, AttributeOperation operator) {
        this(attribute, operator, null);
    }

    public AttributeExpression(IQueryableAttribute attribute, AttributeOperation operator, Object value) {
        this.fAttribute = attribute;
        this.fAttributeIdentifier = QueryableAttributePath.createPathString(attribute);
        this.fOperator = operator;
        this.fValueProxy = AttributeValueFactory.getInstance().getValue(this.getValueType(attribute, operator), value);
    }

    public AttributeExpression(IAuditableCommon auditableCommon, IAttribute attribute, AttributeOperation operation, Object value) {
        this(new QueryableWorkItemAttribute(attribute), operation, value);
    }

    public String getAttributeIdentifier() {
        return this.fAttributeIdentifier;
    }

    public IQueryableAttribute getAttribute(IEvaluationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fAttribute == null) {
            IQueryableAttributeFactory factory = QueryableAttributes.getFactory(this.fItemType);
            this.fAttribute = factory.findAttribute(context.getProjectArea(), this.fAttributeIdentifier, context.getAuditableCommon(), monitor);
            if (this.fAttribute == null) {
                String message = NLS.bind((String)Messages.getString("AttributeExpression.UNKNOWN_ATTRIBUTE"), (Object[])new Object[]{this.fAttributeIdentifier});
                throw new ItemNotFoundException(message);
            }
        }
        return this.fAttribute;
    }

    public AttributeOperation getOperation() {
        return this.fOperator;
    }

    public void setOperation(AttributeOperation operation) {
        this.fOperator = operation;
    }

    public Object getValue() {
        return this.fValueProxy.getValue();
    }

    public Object getResolvedValue(IEvaluationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getValue();
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public void accept(ProgressExpressionVisitor visitor, IProgressMonitor monitor) throws TeamRepositoryException {
        visitor.visit(this, monitor);
    }

    public void init(IPersistableElement condition, ISerializationContext context) throws SerializationException {
        this.fItemType = context.getItemType();
        this.fOperator = AttributeOperation.find(condition.getAttribute("operator"));
        if (this.fOperator == null) {
            String message = NLS.bind((String)Messages.getString("AttributeExpression.UNSUPPORTED_OPERATOR"), (Object[])new Object[]{condition.getAttribute("operator")});
            throw new SerializationException(message);
        }
        IPersistableElement attribute = condition.getChild("attribute");
        this.fAttributeIdentifier = context.getAttribute(attribute.getAttribute("name"), ISerializationContext.AttributeContext.EXPRESSION);
        this.fValueProxy = this.createValueProxy(condition, context);
    }

    public void saveState(IPersistableElement element) throws SerializationException {
        IPersistableElement condition = element.createChild("condition");
        condition.setAttribute("operator", this.getOperation().getIdentifier());
        IPersistableElement attribute = condition.createChild("attribute");
        attribute.setAttribute("name", this.fAttributeIdentifier);
        this.saveValueProxy(condition);
    }

    protected IAttributeValue createValueProxy(IPersistableElement condition, ISerializationContext context) throws SerializationException {
        IAttributeValue value = AttributeValueFactory.getInstance().getValue();
        value.init(condition, context);
        return value;
    }

    protected void saveValueProxy(IPersistableElement condition) throws SerializationException {
        this.fValueProxy.saveState(condition);
    }

    private String getValueType(IQueryableAttribute attribute, AttributeOperation operator) {
        if (IWorkItem.APPROVALS_PROPERTY.equals(attribute.getIdentifier())) {
            return "contributor";
        }
        if (operator.getTargetAttributeType().length() > 0) {
            return operator.getTargetAttributeType();
        }
        return attribute.getAttributeType();
    }

    public static String toString(Object o) {
        EObject eObject;
        EStructuralFeature feature;
        if (o == null) {
            return "";
        }
        if (o instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)o;
            EObject eObject2 = (EObject)adaptable.getAdapter(EObject.class);
            EStructuralFeature feature2 = eObject2.eClass().getEStructuralFeature("name");
            return (String)eObject2.eGet(feature2, false);
        }
        if (o instanceof EObject && (feature = (eObject = (EObject)o).eClass().getEStructuralFeature("name")) != null) {
            return (String)eObject.eGet(feature, false);
        }
        if (o instanceof Timestamp) {
            return DateFormat.getInstance().format((Date)o);
        }
        return o.toString();
    }
}

