/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.utils;

import com.ibm.team.repository.common.utils.HashComputingInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class HashCode {
    long hash = 0L;

    public static Checksum createChecksum(InputStream inputStream, long l, IProgressMonitor iProgressMonitor) throws IOException {
        SubMonitor subMonitor = null;
        FilterInputStream filterInputStream = null;
        try {
            subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)-1);
            filterInputStream = new HashComputingInputStream(inputStream);
            byte[] byArray = new byte[4000];
            int n = 0;
            int n2 = 0;
            try {
                while (-1 != (n = filterInputStream.read(byArray))) {
                    n2 += n;
                    subMonitor.worked(1);
                    if (!subMonitor.isCanceled()) continue;
                    throw (Throwable)new OperationCanceledException();
                }
            }
            finally {
                filterInputStream.close();
            }
            Checksum checksum = ((HashComputingInputStream)filterInputStream).getChecksum();
            return checksum;
        }
        finally {
            if (subMonitor != null) {
                subMonitor.done();
            }
            if (filterInputStream == null) {
                inputStream.close();
            } else {
                filterInputStream.close();
            }
        }
    }

    public static HashCode createHashCode(InputStream inputStream, long l, IProgressMonitor iProgressMonitor) throws IOException {
        return new HashCode(HashCode.createChecksum(inputStream, l, iProgressMonitor));
    }

    public static HashCode createHashCode(InputStream inputStream) throws IOException {
        HashComputingInputStream hashComputingInputStream = new HashComputingInputStream(inputStream);
        byte[] byArray = new byte[4000];
        int n = 0;
        int n2 = 0;
        try {
            while (-1 != (n = hashComputingInputStream.read(byArray))) {
                n2 += n;
            }
        }
        finally {
            hashComputingInputStream.close();
        }
        return new HashCode(hashComputingInputStream.getHash());
    }

    public static Checksum newChecksum() {
        return new Adler32();
    }

    public HashCode(long l) {
        this.hash = l;
    }

    public HashCode(Checksum checksum) {
        this.hash = checksum.getValue();
    }

    public boolean equalsHash(long l) {
        return this.hash == l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HashCode)) {
            return false;
        }
        HashCode hashCode = (HashCode)object;
        return hashCode.hash == this.hash;
    }

    public String toString() {
        return "HashCode(0x" + Long.toHexString(this.hash) + ")";
    }

    public long getValue() {
        return this.hash;
    }

    public static void writeOnto(HashCode hashCode, DataOutputStream dataOutputStream) throws IOException {
        if (hashCode == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeLong(hashCode.hash);
        }
    }

    public static HashCode readFrom(DataInputStream dataInputStream) throws IOException {
        boolean bl = dataInputStream.readBoolean();
        if (bl) {
            long l = dataInputStream.readLong();
            return new HashCode(l);
        }
        return null;
    }
}

