/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl$$Cold;
import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl$MonitorJob;
import com.ibm.team.repository.common.util.HashUtil;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;

public class TeamServiceCallContextImpl {
    private static Log logger = LogFactory.getLog(TeamServiceCallContextImpl.class);
    private static ThreadLocal contextStacks = new ThreadLocal();
    private static Map connectingSockets = new HashMap();
    private static Map _ThreadSocketMap = new HashMap();
    private HttpMethod httpMethod;
    private final IProgressMonitor progressMonitor;
    private final TeamServiceCallContextImpl$MonitorJob monitorJob;
    private Thread methodThread;
    private static boolean logNonCancelableServiceCalls;
    private static Set stackTraces;

    static {
        _ThreadSocketMap = Collections.synchronizedMap(_ThreadSocketMap);
        logNonCancelableServiceCalls = false;
        stackTraces = new HashSet();
    }

    public static Socket getSocketForThread(Thread thread) {
        return (Socket)_ThreadSocketMap.get(thread);
    }

    public Job getMonitorJob() {
        return this.monitorJob;
    }

    public boolean isCanceled() {
        return this.progressMonitor.isCanceled();
    }

    public static void setLogNonCancelableServiceCalls(boolean bl) {
        logNonCancelableServiceCalls = bl;
    }

    static /* synthetic */ Log access$0() {
        return logger;
    }

    static /* synthetic */ Thread access$1(TeamServiceCallContextImpl teamServiceCallContextImpl) {
        return teamServiceCallContextImpl.methodThread;
    }

    public static void setSocketForCurrentThread(Socket socket) {
        if (socket == null) {
            _ThreadSocketMap.remove(Thread.currentThread());
        } else {
            _ThreadSocketMap.put(Thread.currentThread(), socket);
        }
    }

    public static Stack getCurrentStack() {
        Stack stack = (Stack)contextStacks.get();
        if (stack != null) {
            return stack;
        }
        Stack stack2 = new Stack();
        contextStacks.set(stack2);
        return stack2;
    }

    public static TeamServiceCallContextImpl getCurrent() throws  {
        return TeamServiceCallContextImpl$$Cold.getCurrent();
    }

    public static void pushCallContext(IProgressMonitor iProgressMonitor) {
        logger.debug((Object)"pushCallContext()");
        Stack stack = TeamServiceCallContextImpl.getCurrentStack();
        stack.push(new TeamServiceCallContextImpl(iProgressMonitor));
    }

    public static void popCallContext() {
        logger.debug((Object)"popCallContext()");
        Stack stack = TeamServiceCallContextImpl.getCurrentStack();
        stack.pop();
    }

    public static void setUpCall(HttpMethod httpMethod) throws OperationCanceledException {
        String string;
        logger.debug((Object)"setUpCall()");
        TeamServiceCallContextImpl teamServiceCallContextImpl = TeamServiceCallContextImpl.getCurrent();
        if (teamServiceCallContextImpl == null) {
            return;
        }
        if (teamServiceCallContextImpl.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        teamServiceCallContextImpl.httpMethod = httpMethod;
        teamServiceCallContextImpl.methodThread = Thread.currentThread();
        try {
            string = httpMethod == null ? "local service method invocation" : httpMethod.getURI().toString();
        }
        catch (URIException uRIException) {
            string = "???";
        }
        string = "TeamService cancel monitor for: " + string;
        teamServiceCallContextImpl.monitorJob.setName(string);
        if (httpMethod != null) {
            teamServiceCallContextImpl.monitorJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tearDownCall() throws OperationCanceledException {
        logger.debug((Object)"tearDownCall()");
        TeamServiceCallContextImpl teamServiceCallContextImpl = TeamServiceCallContextImpl.getCurrent();
        if (teamServiceCallContextImpl == null) {
            return;
        }
        if (teamServiceCallContextImpl.monitorJob != null) {
            teamServiceCallContextImpl.monitorJob.setFinished();
            teamServiceCallContextImpl.monitorJob.cancel();
        }
        TeamServiceCallContextImpl teamServiceCallContextImpl2 = teamServiceCallContextImpl;
        synchronized (teamServiceCallContextImpl2) {
            teamServiceCallContextImpl.httpMethod = null;
        }
        if (teamServiceCallContextImpl.progressMonitor.isCanceled()) {
            Thread.interrupted();
            throw (Throwable)new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConnectingSocket(SocketChannel socketChannel, Thread thread) {
        Map map = connectingSockets;
        synchronized (map) {
            connectingSockets.put(thread, socketChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterConnectingSocket(Thread thread) {
        Map map = connectingSockets;
        synchronized (map) {
            connectingSockets.remove(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelConnect(Thread thread) {
        Map map = connectingSockets;
        synchronized (map) {
            SocketChannel socketChannel = (SocketChannel)connectingSockets.get(thread);
            if (socketChannel != null) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public TeamServiceCallContextImpl(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            throw (Throwable)new IllegalArgumentException("progressMonitor must not be null");
        }
        logger.debug((Object)"new TeamServiceCallContextImpl()");
        this.progressMonitor = iProgressMonitor;
        this.monitorJob = new TeamServiceCallContextImpl$MonitorJob(this.getClass().getName(), this);
        this.monitorJob.setSystem(true);
        this.monitorJob.setPriority(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelHttpMethod() {
        TeamServiceCallContextImpl teamServiceCallContextImpl = this;
        synchronized (teamServiceCallContextImpl) {
            block7: {
                if (this.httpMethod == null) break block7;
                Socket socket = TeamServiceCallContextImpl.getSocketForThread(this.methodThread);
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
                this.httpMethod.abort();
                this.methodThread.interrupt();
                return true;
            }
            return false;
        }
    }

    public static void checkCancelable() {
        if (logNonCancelableServiceCalls && TeamServiceCallContextImpl.getCurrent() == null) {
            Exception exception = new Exception("Non-cancelable service call detected.  A progress monitor should be provided.");
            String string = HashUtil.getStacktraceHash(exception);
            if (stackTraces.contains(string)) {
                logger.error((Object)(String.valueOf(exception.getMessage()) + "Use the stack trace hash to locate the exception trace: " + string));
            } else {
                stackTraces.add(string);
                logger.error((Object)("Non-cancelable service call stack trace hash: " + string));
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }
}

