/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import com.ibm.team.repository.common.IServerContainerProvider;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.transport.AbstractElementDescriptor;
import com.ibm.team.repository.common.transport.IServerContainerDescriptor;
import com.ibm.team.repository.common.transport.TeamServiceRegistryException;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class ServerContainerDescriptor
extends AbstractElementDescriptor
implements IServerContainerDescriptor {
    private String implementationClassAttribute;
    private IServerContainerProvider provider;

    public ServerContainerDescriptor(IConfigurationElement iConfigurationElement) {
        super(iConfigurationElement, "serverContainer");
    }

    protected void checkElement() {
        this.checkImplementationClass();
    }

    private void checkImplementationClass() {
        String string = this.getImplementationClassAttribute();
        this.checkAttributeIsSet(string, "implementationClass");
    }

    private IServerContainerProvider createProvider() throws TeamServiceRegistryException {
        IServerContainerProvider iServerContainerProvider = null;
        try {
            iServerContainerProvider = (IServerContainerProvider)this.createInstance("implementationClass");
        }
        catch (CoreException coreException) {
            String string = this.getImplementationClassAttribute();
            String string2 = NLS.bind(Messages.getServerString("ServerContainerDescriptor.ErrorContainerCreate"), string);
            throw (Throwable)new TeamServiceRegistryException(string2, coreException);
        }
        return iServerContainerProvider;
    }

    public String getImplementationClassAttribute() {
        return this.implementationClassAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServerContainerProvider getProvider() throws TeamServiceRegistryException {
        ServerContainerDescriptor serverContainerDescriptor = this;
        synchronized (serverContainerDescriptor) {
            if (this.provider == null) {
                IServerContainerProvider iServerContainerProvider = this.createProvider();
                this.setProvider(iServerContainerProvider);
            }
            return this.provider;
        }
    }

    protected void initialize() {
        super.initialize();
        this.setImplementationClassAttribute(this.getAttribute("implementationClass"));
    }

    private void printImplementationClassAttributeOn(StringBuffer stringBuffer) {
        String string = this.getImplementationClassAttribute();
        this.printOn(stringBuffer, "implementationClass", string);
    }

    protected void printOn(StringBuffer stringBuffer) {
        super.printOn(stringBuffer);
        this.printImplementationClassAttributeOn(stringBuffer);
    }

    private void setImplementationClassAttribute(String string) {
        this.implementationClassAttribute = string;
    }

    private void setProvider(IServerContainerProvider iServerContainerProvider) {
        this.provider = iServerContainerProvider;
    }
}

