/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import com.ibm.team.repository.common.internal.util.ComponentRegistry;
import com.ibm.team.repository.common.transport.ITeamServer;
import com.ibm.team.repository.common.transport.ITeamService;
import com.ibm.team.repository.common.transport.TeamServerConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTeamServer
implements ITeamServer {
    private final Map<Class, ITeamService> teamServices = new HashMap<Class, ITeamService>(101);
    private String userid;
    private TeamServerConfiguration configuration;
    private final String repoURL;

    protected AbstractTeamServer(String url) {
        this.repoURL = url;
        this.configuration = new TeamServerConfiguration();
    }

    @Override
    public void setCredentials(String userid, String password) {
        this.userid = userid;
    }

    @Override
    public final String getUserid() {
        return this.userid;
    }

    @Override
    public final String getRepositoryURL() {
        return this.repoURL;
    }

    @Override
    public void setConfiguration(TeamServerConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("TeamServerConfiguration must not be null");
        }
        this.configuration = configuration;
    }

    @Override
    public final TeamServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public abstract ITeamService createTeamService(Class<?> var1, Object var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final ITeamService getService(Class serviceClass) {
        if (serviceClass == null) {
            return null;
        }
        Map<Class, ITeamService> map = this.teamServices;
        synchronized (map) {
            ITeamService teamService = this.teamServices.get(serviceClass);
            if (teamService != null) {
                return teamService;
            }
            try {
                Object implementation = this.buildServiceImplementation(serviceClass);
                String version = this.lookupServiceVersion(serviceClass);
                teamService = this.createTeamService(serviceClass, implementation, version);
                if (teamService == null) {
                    return null;
                }
                this.teamServices.put(serviceClass, teamService);
                return teamService;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }
    }

    private String lookupServiceVersion(Class serviceClass) {
        String serviceUri = serviceClass.getName();
        String version = ComponentRegistry.INSTANCE.getServiceVersion(serviceUri);
        return version;
    }

    protected abstract Object buildServiceImplementation(Class<?> var1);

    @Override
    public final Object getServiceImplementation(Class serviceClass) {
        ITeamService teamService = this.getService(serviceClass);
        if (teamService == null) {
            return null;
        }
        Object implementation = teamService.getImplementation();
        return implementation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ITeamService getServiceByName(String serviceClassName) {
        if (serviceClassName == null) {
            throw new IllegalArgumentException("serviceClassName must not be null");
        }
        Map<Class, ITeamService> map = this.teamServices;
        synchronized (map) {
            Set<Class> classes = this.teamServices.keySet();
            for (Class clazz : classes) {
                String className = clazz.getName();
                boolean match = className.equals(serviceClassName);
                if (!match) continue;
                ITeamService service = this.getService(clazz);
                return service;
            }
        }
        return null;
    }
}

