/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class RepositoryType
extends AbstractEnumerator {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corporation 2007. All Rights Reserved.\n\nNote to U.S. Government Users Restricted Rights:\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corp.";
    public static final int PRODUCTION = 0;
    public static final int DEVELOPMENT = 1;
    public static final RepositoryType PRODUCTION_LITERAL = new RepositoryType(0, "PRODUCTION", "PRODUCTION");
    public static final RepositoryType DEVELOPMENT_LITERAL = new RepositoryType(1, "DEVELOPMENT", "DEVELOPMENT");
    private static final RepositoryType[] VALUES_ARRAY = new RepositoryType[]{PRODUCTION_LITERAL, DEVELOPMENT_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static RepositoryType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RepositoryType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RepositoryType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RepositoryType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RepositoryType get(int value) {
        switch (value) {
            case 0: {
                return PRODUCTION_LITERAL;
            }
            case 1: {
                return DEVELOPMENT_LITERAL;
            }
        }
        return null;
    }

    private RepositoryType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

