/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IItemType$IRegistry;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.IVirtualType;
import com.ibm.team.repository.common.IVirtualType$IRegistry;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil$ItemIdComparator;
import com.ibm.team.repository.common.internal.util.ItemUtil$ProtectAdapter;
import com.ibm.team.repository.common.internal.util.ItemUtil$StateIdComparator;
import com.ibm.team.repository.common.internal.util.ItemUtil$StringLengthViolation;
import com.ibm.team.repository.common.internal.util.ItemUtil$StringSize;
import com.ibm.team.repository.common.internal.util.ItemUtil$TypeAdapter;
import com.ibm.team.repository.common.model.Helper;
import com.ibm.team.repository.common.model.HelperType;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.model.RepositoryFactory;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.model.Type;
import com.ibm.team.repository.common.model.Virtual;
import com.ibm.team.repository.common.model.VirtualType;
import com.ibm.team.repository.common.query.ast.IDynamicQueryModel;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class ItemUtil {
    private static final EReference ITEM_STRING_EXTENSIONS = RepositoryPackage.eINSTANCE.getItem_StringExtensions();
    private static final EReference ITEM_INT_EXTENSIONS = RepositoryPackage.eINSTANCE.getItem_IntExtensions();
    private static final EReference ITEM_BOOLEAN_EXTENSIONS = RepositoryPackage.eINSTANCE.getItem_BooleanExtensions();
    private static final EReference ITEM_TIMESTAMP_EXTENSIONS = RepositoryPackage.eINSTANCE.getItem_TimestampExtensions();
    private static final EReference ITEM_LONG_EXTENSIONS = RepositoryPackage.eINSTANCE.getItem_LongExtensions();
    private static final EReference ITEM_MEDIUM_STRING_EXTENSIONS = RepositoryPackage.eINSTANCE.getItem_MediumStringExtensions();
    private static final EReference ITEM_LARGE_STRING_EXTENSIONS = RepositoryPackage.eINSTANCE.getItem_LargeStringExtensions();
    private static final EReference ITEM_BIG_DECIMAL_EXTENSIONS = RepositoryPackage.eINSTANCE.getItem_BigDecimalExtensions();
    private static final Set EXTENSIONS_FEATURES = new HashSet(10);
    private static final String[] EXTENSIONS_FEATURE_NAMES;
    public static final UUID DELETED_UUID;
    public static final long SMALL_STRING_BYTES = 250L;
    public static final long MEDIUM_STRING_BYTES = 1000L;
    public static final long LARGE_STRING_BYTES = 32768L;
    private static final String TEAM_PACKAGE_ANNOTATION = "teamPackage";
    private static final String TEAM_CLASS_ANNOTATION = "teamClass";
    private static final String BASE_PACKAGE_DETAIL = "clientBasePackage";
    private static final String PACKAGE_SUFFIX_DETAIL = "clientPackageSuffix";
    private static final String QUERYMODEL_PACKAGE_DETAIL = "queryModelPackage";
    private static final String ALLOWS_STATE_EXTENSIONS_DETAIL = "allowsStateExtensions";
    private static String FACADE_FOR_CLASS_DETAIL;
    private static final String TEAM_ATTRIBUTE_ANNOTATION = "teamAttribute";
    private static final String QUERYABLE_PROPERTY_STEREOTYPE = "queryableProperty";
    private static final String UNIQUE_PROPERTY = "unique";
    private static final String ID_DETAIL = "id";
    private static final String TEAM_REFERENCE_ANNOTATION = "teamReference";
    private static final String MIN_RETRIEVAL_PROFILE_DETAIL = "minRetrievalProfile";
    private static final String SMALL_ACCESS_PROFILE = "SMALL";
    private static final String DB_STRING_SIZE_DETAIL = "dbStringSize";
    private static final String SMALL_DB_STRING_SIZE = "SMALL";
    private static final String MEDIUM_DB_STRING_SIZE = "MEDIUM";
    private static final String LARGE_DB_STRING_SIZE = "LARGE";
    private static final EDataType ESTRING;
    public static final Comparator itemIdComparator;
    public static final Comparator stateIdComparator;

    static {
        EXTENSIONS_FEATURES.add(ITEM_STRING_EXTENSIONS);
        EXTENSIONS_FEATURES.add(ITEM_INT_EXTENSIONS);
        EXTENSIONS_FEATURES.add(ITEM_BOOLEAN_EXTENSIONS);
        EXTENSIONS_FEATURES.add(ITEM_TIMESTAMP_EXTENSIONS);
        EXTENSIONS_FEATURES.add(ITEM_LONG_EXTENSIONS);
        EXTENSIONS_FEATURES.add(ITEM_MEDIUM_STRING_EXTENSIONS);
        EXTENSIONS_FEATURES.add(ITEM_LARGE_STRING_EXTENSIONS);
        EXTENSIONS_FEATURES.add(ITEM_BIG_DECIMAL_EXTENSIONS);
        EXTENSIONS_FEATURE_NAMES = new String[8];
        ItemUtil.EXTENSIONS_FEATURE_NAMES[0] = ITEM_STRING_EXTENSIONS.getName();
        ItemUtil.EXTENSIONS_FEATURE_NAMES[1] = ITEM_INT_EXTENSIONS.getName();
        ItemUtil.EXTENSIONS_FEATURE_NAMES[2] = ITEM_BOOLEAN_EXTENSIONS.getName();
        ItemUtil.EXTENSIONS_FEATURE_NAMES[3] = ITEM_TIMESTAMP_EXTENSIONS.getName();
        ItemUtil.EXTENSIONS_FEATURE_NAMES[4] = ITEM_LONG_EXTENSIONS.getName();
        ItemUtil.EXTENSIONS_FEATURE_NAMES[5] = ITEM_MEDIUM_STRING_EXTENSIONS.getName();
        ItemUtil.EXTENSIONS_FEATURE_NAMES[6] = ITEM_LARGE_STRING_EXTENSIONS.getName();
        ItemUtil.EXTENSIONS_FEATURE_NAMES[7] = ITEM_BIG_DECIMAL_EXTENSIONS.getName();
        DELETED_UUID = UUID.valueOf("_PhSpUCSGEdqXm8cK8FbAAQ");
        FACADE_FOR_CLASS_DETAIL = "facadeForClass";
        ESTRING = EcorePackage.eINSTANCE.getEString();
        itemIdComparator = new ItemUtil$ItemIdComparator(null);
        stateIdComparator = new ItemUtil$StateIdComparator(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EClass getTypeEClass(Type type) {
        Type type2 = type;
        synchronized (type2) {
            EClass eClass = type.getAssociatedEClass();
            if (eClass == null) {
                eClass = ItemUtil.getEClass(type.getName(), type.getNamespaceURI());
                type.setAssociatedEClass(eClass);
            }
            return eClass;
        }
    }

    public static EClass getHandleEClass(ItemType itemType) {
        EClass eClass = ItemUtil.getTypeEClass(itemType);
        ItemUtil$TypeAdapter itemUtil$TypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemUtil$TypeAdapter.getHandleEClass();
    }

    public static EClass getItemEClass(ItemType itemType) {
        EClass eClass = ItemUtil.getTypeEClass(itemType);
        ItemUtil$TypeAdapter itemUtil$TypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemUtil$TypeAdapter.getItemEClass();
    }

    public static EClass getItemEClass(EClass eClass) {
        if (eClass == null) {
            throw (Throwable)new IllegalArgumentException("Must specify an EClass");
        }
        if (!RepositoryPackage.eINSTANCE.getItemHandle().isSuperTypeOf(eClass) || eClass == RepositoryPackage.eINSTANCE.getAuditable() || eClass == RepositoryPackage.eINSTANCE.getSimpleItem() || eClass == RepositoryPackage.eINSTANCE.getUnmanagedItem()) {
            throw (Throwable)new IllegalArgumentException("EClass: " + eClass.toString());
        }
        ItemUtil$TypeAdapter itemUtil$TypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemUtil$TypeAdapter.getItemEClass();
    }

    public static EClass resolveReferenceTypeCompletely(EReference eReference) {
        EClass eClass = ItemUtil.getTargetClassIfFacade(eReference.getEReferenceType());
        if (ItemUtil.isHandle(eClass)) {
            return ItemUtil.getItemEClass(eClass);
        }
        return eClass;
    }

    public static IDynamicQueryModel getQueryModel(ItemType itemType) {
        EClass eClass = ItemUtil.getTypeEClass(itemType);
        ItemUtil$TypeAdapter itemUtil$TypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemUtil$TypeAdapter.getQueryModel();
    }

    public static EClass getEClass(String string, String string2) {
        EClassifier eClassifier;
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(string2);
        if (ePackage != null && (eClassifier = ePackage.getEClassifier(string)) instanceof EClass) {
            return (EClass)eClassifier;
        }
        return null;
    }

    public static EPackage getEPackage(String string) {
        return EPackage.Registry.INSTANCE.getEPackage(string);
    }

    public static List getPropertyNames(Type type) {
        EClass eClass = ItemUtil.getTypeEClass(type);
        ItemUtil$TypeAdapter itemUtil$TypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemUtil$TypeAdapter.getPropertyNames();
    }

    public static List getValidFetchPropertyNames(Type type) {
        EClass eClass = ItemUtil.getTypeEClass(type);
        ItemUtil$TypeAdapter itemUtil$TypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemUtil$TypeAdapter.getValidFetchPropertyNames();
    }

    public static long getMaxSizeInBytes(EStructuralFeature eStructuralFeature) {
        if (eStructuralFeature == null) {
            throw (Throwable)new IllegalArgumentException("Feature must not be null");
        }
        if (eStructuralFeature.getEType() == ESTRING) {
            ItemUtil$StringSize itemUtil$StringSize = ItemUtil.getStringSize((EAttribute)eStructuralFeature);
            switch (itemUtil$StringSize) {
                case LARGE: {
                    return 32768L;
                }
                case MEDIUM: {
                    return 1000L;
                }
                case SMALL: {
                    return 250L;
                }
            }
            throw (Throwable)new IllegalArgumentException("Unsupported string size");
        }
        String string = NLS.bind("Property {0} is not a string property", eStructuralFeature.getName());
        throw (Throwable)new IllegalArgumentException(string);
    }

    public static ItemUtil$StringSize getStringSize(EAttribute eAttribute) {
        String string;
        EAnnotation eAnnotation = eAttribute.getEAnnotation(TEAM_ATTRIBUTE_ANNOTATION);
        if (eAnnotation != null && (string = (String)eAnnotation.getDetails().get((Object)DB_STRING_SIZE_DETAIL)) != null) {
            if (string.equals("SMALL")) {
                return ItemUtil$StringSize.SMALL;
            }
            if (string.equals(MEDIUM_DB_STRING_SIZE)) {
                return ItemUtil$StringSize.MEDIUM;
            }
            if (string.equals(LARGE_DB_STRING_SIZE)) {
                return ItemUtil$StringSize.LARGE;
            }
        }
        return ItemUtil$StringSize.SMALL;
    }

    public static long getMaxSize(EStructuralFeature eStructuralFeature) {
        if (eStructuralFeature.getEType() == ESTRING) {
            long l = ItemUtil.getMaxSizeInBytes(eStructuralFeature);
            return l / 2L;
        }
        return -1L;
    }

    public static boolean isStringSmallEnough(EStructuralFeature eStructuralFeature, String string) {
        return ItemUtil.validateStringPropertySize(eStructuralFeature, string) != null;
    }

    public static ItemUtil$StringLengthViolation validateStringPropertySize(EStructuralFeature eStructuralFeature, String string) {
        long l;
        if (eStructuralFeature == null) {
            String string2 = String.format("Feature must not be null", new Object[0]);
            throw (Throwable)new IllegalArgumentException(string2);
        }
        if (eStructuralFeature.getEType() != ESTRING) {
            String string3 = String.format("Feature \"%s\" is not a string property", eStructuralFeature.getName());
            throw (Throwable)new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = String.format("Null value encountered validating string size for %s", eStructuralFeature.getName());
            throw (Throwable)new IllegalArgumentException(string4);
        }
        long l2 = ItemUtil.getUtf8ByteLength(string);
        if (l2 <= (l = ItemUtil.getMaxSizeInBytes(eStructuralFeature))) {
            return null;
        }
        return new ItemUtil$StringLengthViolation(l, l2);
    }

    public static List getMinimalPropertyNames(ItemType itemType) {
        EClass eClass = ItemUtil.getTypeEClass(itemType);
        ItemUtil$TypeAdapter itemUtil$TypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemUtil$TypeAdapter.getMinimalPropertyNames();
    }

    public static boolean allowsStateExtensions(ItemType itemType) {
        EClass eClass = ItemUtil.getTypeEClass(itemType);
        return ItemUtil.allowsStateExtensions(eClass);
    }

    public static boolean allowsStateExtensions(EClass eClass) {
        ItemUtil$TypeAdapter itemUtil$TypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemUtil$TypeAdapter.allowsStateExtensions();
    }

    public static String getIdProperty(ItemType itemType) {
        EClass eClass = ItemUtil.getTypeEClass(itemType);
        return ItemUtil.getIdProperty(eClass);
    }

    public static String getIdProperty(EClass eClass) {
        ItemUtil$TypeAdapter itemUtil$TypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemUtil$TypeAdapter.getIdProperty();
    }

    public static ItemHandle createItemHandle(EClass eClass, UUID uUID, UUID uUID2) {
        EObject eObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
        if (eObject instanceof ItemHandle) {
            ItemHandle itemHandle = (ItemHandle)eObject;
            itemHandle.setItemId(uUID);
            if (uUID2 != null) {
                itemHandle.setStateId(uUID2);
            }
            return itemHandle;
        }
        return null;
    }

    public static ItemHandle createItemHandle(ItemType itemType, UUID uUID, UUID uUID2) {
        EClass eClass = ItemUtil.getHandleEClass(itemType);
        return ItemUtil.createItemHandle(eClass, uUID, uUID2);
    }

    public static ItemHandle newItemHandle(ItemHandle itemHandle, boolean bl) {
        EClass eClass = ItemUtil.getHandleEClass((ItemType)itemHandle.getItemType());
        UUID uUID = itemHandle.getItemId();
        UUID uUID2 = bl ? itemHandle.getStateId() : null;
        ItemHandle itemHandle2 = ItemUtil.createItemHandle(eClass, uUID, uUID2);
        itemHandle2.setOrigin(itemHandle.getOrigin());
        return itemHandle2;
    }

    public static ItemType itemTypeFor(ItemHandle itemHandle) {
        EClass eClass = ((EObject)itemHandle).eClass();
        return ItemUtil.itemTypeFor(eClass);
    }

    public static ItemType itemTypeFor(String string, String string2) {
        EClassifier eClassifier;
        if (string == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (string2 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        EPackage ePackage = null;
        ePackage = EPackage.Registry.INSTANCE.getEPackage(string2);
        if (ePackage != null && (eClassifier = ePackage.getEClassifier(string)) instanceof EClass) {
            return ItemUtil.itemTypeFor((EClass)eClassifier);
        }
        return null;
    }

    public static List itemTypeFor(String string) {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("name must not be null");
        }
        ArrayList<IItemType> arrayList = new ArrayList<IItemType>();
        IItemType[] iItemTypeArray = IItemType$IRegistry.INSTANCE.getAllItemTypes();
        int n = 0;
        while (n < iItemTypeArray.length) {
            if (string.equals(iItemTypeArray[n].getName())) {
                arrayList.add(iItemTypeArray[n]);
            }
            ++n;
        }
        return arrayList;
    }

    public static ItemType itemTypeFor(EClass eClass) {
        if (eClass == null) {
            throw (Throwable)new NullPointerException("Must specify an EClass");
        }
        if (!RepositoryPackage.eINSTANCE.getItemHandle().isSuperTypeOf(eClass) || eClass == RepositoryPackage.eINSTANCE.getAuditable() || eClass == RepositoryPackage.eINSTANCE.getAuditableHandle() || eClass == RepositoryPackage.eINSTANCE.getSimpleItem() || eClass == RepositoryPackage.eINSTANCE.getSimpleItemHandle() || eClass == RepositoryPackage.eINSTANCE.getUnmanagedItem() || eClass == RepositoryPackage.eINSTANCE.getUnmanagedItemHandle()) {
            throw (Throwable)new IllegalArgumentException("EClass: " + eClass.toString());
        }
        ItemUtil$TypeAdapter itemUtil$TypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return (ItemType)itemUtil$TypeAdapter.getType();
    }

    public static HelperType helperTypeFor(Helper helper) {
        EClass eClass = ((EObject)helper).eClass();
        return ItemUtil.helperTypeFor(eClass);
    }

    public static HelperType helperTypeFor(String string, String string2) {
        EClassifier eClassifier;
        if (string == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (string2 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        EPackage ePackage = null;
        ePackage = EPackage.Registry.INSTANCE.getEPackage(string2);
        if (ePackage != null && (eClassifier = ePackage.getEClassifier(string)) instanceof EClass) {
            return ItemUtil.helperTypeFor((EClass)eClassifier);
        }
        return null;
    }

    public static HelperType helperTypeFor(EClass eClass) {
        if (eClass == null || !RepositoryPackage.eINSTANCE.getHelper().isSuperTypeOf(eClass)) {
            throw (Throwable)new IllegalArgumentException();
        }
        ItemUtil$TypeAdapter itemUtil$TypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return (HelperType)itemUtil$TypeAdapter.getType();
    }

    public static VirtualType virtualTypeFor(Virtual virtual) {
        EClass eClass = ((EObject)virtual).eClass();
        return ItemUtil.virtualTypeFor(eClass);
    }

    public static VirtualType virtualTypeFor(String string, String string2) {
        EClassifier eClassifier;
        if (string == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (string2 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        EPackage ePackage = null;
        ePackage = EPackage.Registry.INSTANCE.getEPackage(string2);
        if (ePackage != null && (eClassifier = ePackage.getEClassifier(string)) instanceof EClass) {
            return ItemUtil.virtualTypeFor((EClass)eClassifier);
        }
        return null;
    }

    public static List virtualTypeFor(String string) {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("name must not be null");
        }
        ArrayList<IVirtualType> arrayList = new ArrayList<IVirtualType>();
        IVirtualType[] iVirtualTypeArray = IVirtualType$IRegistry.INSTANCE.getAllVirtualTypes();
        int n = 0;
        while (n < iVirtualTypeArray.length) {
            if (string.equals(iVirtualTypeArray[n].getName())) {
                arrayList.add(iVirtualTypeArray[n]);
            }
            ++n;
        }
        return arrayList;
    }

    public static VirtualType virtualTypeFor(EClass eClass) {
        if (eClass == null || !RepositoryPackage.eINSTANCE.getVirtual().isSuperTypeOf(eClass)) {
            throw (Throwable)new IllegalArgumentException();
        }
        ItemUtil$TypeAdapter itemUtil$TypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return (VirtualType)itemUtil$TypeAdapter.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ItemUtil$TypeAdapter getTypeAdapter(EClass eClass) {
        Object object;
        String string;
        ItemUtil$TypeAdapter itemUtil$TypeAdapter = null;
        EClass eClass2 = eClass;
        synchronized (eClass2) {
            itemUtil$TypeAdapter = ItemUtil.internalGetTypeAdapter(eClass);
            if (itemUtil$TypeAdapter != null) {
                return itemUtil$TypeAdapter;
            }
        }
        eClass2 = null;
        if (RepositoryPackage.eINSTANCE.getItemHandle().isSuperTypeOf(eClass)) {
            string = eClass.getName();
            if (string.endsWith("Handle")) {
                object = string.substring(0, string.length() - 6);
                eClass2 = eClass;
                eClass = (EClass)eClass.getEPackage().getEClassifier((String)object);
                string = eClass.getName();
            } else {
                eClass2 = (EClass)eClass.getEPackage().getEClassifier(String.valueOf(string) + "Handle");
            }
        }
        string = eClass;
        synchronized (string) {
            itemUtil$TypeAdapter = ItemUtil.internalGetTypeAdapter(eClass);
            if (itemUtil$TypeAdapter != null) {
                return itemUtil$TypeAdapter;
            }
            object = null;
            object = RepositoryPackage.eINSTANCE.getHelper().isSuperTypeOf(eClass) ? RepositoryFactory.eINSTANCE.createHelperType() : (RepositoryPackage.eINSTANCE.getVirtual().isSuperTypeOf(eClass) ? RepositoryFactory.eINSTANCE.createVirtualType() : (eClass2 != null || RepositoryPackage.eINSTANCE.getItem().isSuperTypeOf(eClass) ? RepositoryFactory.eINSTANCE.createItemType() : RepositoryFactory.eINSTANCE.createVirtualType()));
            object.setName(eClass.getName());
            object.setNamespaceURI(eClass.getEPackage().getNsURI());
            object.setAbstract(eClass.isAbstract());
            object.setAssociatedEClass(eClass);
            itemUtil$TypeAdapter = new ItemUtil$TypeAdapter((Type)object, eClass, eClass2);
            eClass.eAdapters().add((Object)itemUtil$TypeAdapter);
        }
        if (eClass2 != null) {
            string = eClass2;
            synchronized (string) {
                eClass2.eAdapters().add((Object)itemUtil$TypeAdapter);
            }
        }
        return itemUtil$TypeAdapter;
    }

    private static ItemUtil$TypeAdapter internalGetTypeAdapter(EClass eClass) {
        for (Adapter adapter : eClass.eAdapters()) {
            if (!(adapter instanceof ItemUtil$TypeAdapter)) continue;
            return (ItemUtil$TypeAdapter)adapter;
        }
        return null;
    }

    public static String itemType2String(EClass eClass) {
        return String.valueOf(eClass.getEPackage().getNsURI()) + '#' + eClass.getName();
    }

    public static String itemType2String(IType iType) {
        return String.valueOf(iType.getNamespaceURI()) + '#' + iType.getName();
    }

    public static String typeToName(IType iType) {
        if (iType == null) {
            throw (Throwable)new IllegalArgumentException("type must not be null");
        }
        return String.valueOf(iType.getNamespaceURI()) + '.' + iType.getName();
    }

    public static IItemType nameToItemType(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0 && string.endsWith(".")) {
            throw (Throwable)new IllegalArgumentException("Illegal syntax for qualified typename - ends with '.'");
        }
        if (n == -1) {
            List list = ItemUtil.itemTypeFor(string);
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() > 1) {
                throw (Throwable)new IllegalArgumentException("There are more than one registered names for '" + string + '\'');
            }
            return (IItemType)list.get(0);
        }
        String string2 = string.substring(n + 1);
        String string3 = string.substring(0, n);
        return ItemUtil.itemTypeFor(string2, string3);
    }

    public static IVirtualType nameToVirtualType(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0 && string.endsWith(".")) {
            throw (Throwable)new IllegalArgumentException("Illegal syntax for qualified typename - ends with '.'");
        }
        if (n == -1) {
            List list = ItemUtil.virtualTypeFor(string);
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() > 1) {
                throw (Throwable)new IllegalArgumentException("There are more than one registered names for '" + string + '\'');
            }
            return (IVirtualType)list.get(0);
        }
        String string2 = string.substring(n + 1);
        String string3 = string.substring(0, n);
        return ItemUtil.virtualTypeFor(string2, string3);
    }

    public static ItemType string2ItemType(String string) {
        int n = string.lastIndexOf(35);
        if (n < 0 || n != string.indexOf(35)) {
            throw (Throwable)new IllegalArgumentException("Malformed ITEM_TYPE: " + string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(string2);
        if (ePackage == null) {
            throw (Throwable)new IllegalArgumentException("Unknown namespace in: " + string);
        }
        EClassifier eClassifier = ePackage.getEClassifier(string3);
        if (eClassifier instanceof EClass) {
            return ItemUtil.itemTypeFor((EClass)eClassifier);
        }
        throw (Throwable)new IllegalArgumentException("Unknown class in: " + string);
    }

    public static ItemType string2ItemType(String string, Map map) {
        Object v = map.get(string);
        if (v != null) {
            ItemType itemType = (ItemType)v;
            return itemType;
        }
        ItemType itemType = ItemUtil.string2ItemType(string);
        map.put(string, itemType);
        return itemType;
    }

    public static List getPersistentStructuralFeatures(ItemType itemType) {
        if (itemType == null) {
            return null;
        }
        EClass eClass = ItemUtil.getTypeEClass(itemType);
        return ItemUtil.getPersistentStructuralFeatures(eClass);
    }

    public static List getPersistentStructuralFeatures(EClass eClass) {
        if (eClass == null) {
            return null;
        }
        ItemUtil$TypeAdapter itemUtil$TypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemUtil$TypeAdapter.getPersistentStructuralFeatures();
    }

    public static boolean isPersistent(EClass eClass, EStructuralFeature eStructuralFeature) {
        if (eClass == null) {
            return false;
        }
        ItemUtil$TypeAdapter itemUtil$TypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemUtil$TypeAdapter.isPersistent(eClass, eStructuralFeature);
    }

    public static boolean isSubclass(EClass eClass, EClass eClass2) {
        return eClass != eClass2 && eClass.isSuperTypeOf(eClass2) && ItemUtil.isSameKind(eClass, eClass2);
    }

    public static boolean isSameKind(EClass eClass, EClass eClass2) {
        if (ItemUtil.isHandle(eClass)) {
            return ItemUtil.isHandle(eClass2);
        }
        if (ItemUtil.isHandle(eClass2)) {
            return ItemUtil.isHandle(eClass);
        }
        return true;
    }

    public static boolean isSameItemType(IItemType iItemType, IItemType iItemType2) {
        return iItemType.getNamespaceURI().equals(iItemType2.getNamespaceURI()) && iItemType.getName().equals(iItemType2.getName());
    }

    public static boolean isHandle(EClass eClass) {
        return RepositoryPackage.eINSTANCE.getItemHandle().isSuperTypeOf(eClass) && !RepositoryPackage.eINSTANCE.getItem().isSuperTypeOf(eClass);
    }

    public static boolean isHandle(EReference eReference) {
        EClass eClass = ItemUtil.getTargetClassIfFacade(eReference.getEReferenceType());
        return ItemUtil.isHandle(eClass);
    }

    public static boolean isImmutableFeature(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature.equals(RepositoryPackage.eINSTANCE.getItemHandle_Immutable());
    }

    public static EClass getTargetClassIfFacade(EClass eClass) {
        String string = ItemUtil.getValue((EModelElement)eClass, TEAM_CLASS_ANNOTATION, FACADE_FOR_CLASS_DETAIL);
        if (string == null || string.length() == 0) {
            return eClass;
        }
        return (EClass)eClass.getEPackage().getEClassifier(string);
    }

    public static EClass getTargetClassIfFacade(EReference eReference) {
        return ItemUtil.getTargetClassIfFacade(eReference.getEReferenceType());
    }

    private static String getValue(EModelElement eModelElement, String string, String string2) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(string);
        if (eAnnotation == null) {
            return null;
        }
        return (String)eAnnotation.getDetails().get((Object)string2);
    }

    public static boolean isInstanceOf(IItemType iItemType, IItem iItem) {
        EClass eClass = (EClass)iItemType.getAdapter(EClass.class);
        boolean bl = eClass.isInstance((Object)iItem);
        return bl;
    }

    public static boolean isInstanceOf(IItemType iItemType, IItemHandle iItemHandle) {
        EClass eClass = ItemUtil.getHandleEClass((ItemType)iItemType);
        boolean bl = eClass.isInstance((Object)iItemHandle);
        return bl;
    }

    public static boolean equivItemRef(IItemHandle iItemHandle, IItemHandle iItemHandle2) {
        if (iItemHandle == null) {
            return iItemHandle2 == null;
        }
        return iItemHandle.sameItemId(iItemHandle2);
    }

    public static boolean itemInCollection(IItemHandle iItemHandle, Collection collection) {
        return ItemUtil.itemInCollection(itemIdComparator, iItemHandle, collection);
    }

    public static boolean itemInCollection(Comparator comparator, IItemHandle iItemHandle, Collection collection) {
        for (IItemHandle iItemHandle2 : collection) {
            if (comparator.compare(iItemHandle, iItemHandle2) != 0) continue;
            return true;
        }
        return false;
    }

    public static IItemHandle findItem(IItemHandle iItemHandle, Collection collection) {
        for (IItemHandle iItemHandle2 : collection) {
            if (!iItemHandle.sameItemId(iItemHandle2)) continue;
            return iItemHandle2;
        }
        return null;
    }

    public static Collection retainAll(Collection collection, Collection collection2) {
        return ItemUtil.select(collection, collection2, true);
    }

    public static Collection removeAll(Collection collection, Collection collection2) {
        return ItemUtil.select(collection, collection2, false);
    }

    private static Collection select(Collection collection, Collection collection2, boolean bl) {
        ArrayList<IItemHandle> arrayList = new ArrayList<IItemHandle>();
        for (IItemHandle iItemHandle : collection) {
            if (ItemUtil.itemInCollection(iItemHandle, collection2)) {
                if (!bl) continue;
                arrayList.add(iItemHandle);
                continue;
            }
            if (bl) continue;
            arrayList.add(iItemHandle);
        }
        return arrayList;
    }

    public static boolean isSame(Collection collection, Collection collection2) {
        return ItemUtil.isSame(itemIdComparator, collection, collection2);
    }

    public static boolean isSame(Comparator comparator, Collection collection, Collection collection2) {
        if (collection == null || collection2 == null) {
            return false;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        for (IItemHandle iItemHandle : collection) {
            if (ItemUtil.itemInCollection(comparator, iItemHandle, collection2)) continue;
            return false;
        }
        for (IItemHandle iItemHandle : collection2) {
            if (ItemUtil.itemInCollection(comparator, iItemHandle, collection)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameList(List list, List list2) {
        if (list == null || list2 == null) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            IItemHandle iItemHandle;
            if (!iterator2.hasNext()) {
                return false;
            }
            IItemHandle iItemHandle2 = (IItemHandle)iterator.next();
            if (iItemHandle2.sameItemId(iItemHandle = (IItemHandle)iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static Collection itemsToHandles(Collection collection) {
        ArrayList<ItemHandle> arrayList = new ArrayList<ItemHandle>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(ItemUtil.newItemHandle((ItemHandle)iterator.next(), true));
        }
        return arrayList;
    }

    public static void clearHelperIds(EObject eObject) {
        TreeIterator treeIterator = eObject.eAllContents();
        EObject eObject2 = null;
        while (treeIterator.hasNext()) {
            eObject2 = (EObject)treeIterator.next();
            if (!(eObject2 instanceof Helper)) continue;
            ((Helper)eObject2).setInternalId(null);
        }
    }

    public static void protect(ItemHandle itemHandle) {
        ItemUtil$ProtectAdapter.INSTANCE.add(itemHandle);
    }

    public static void unprotect(ItemHandle itemHandle) {
        ItemUtil$ProtectAdapter.INSTANCE.remove(itemHandle);
    }

    private static long getUtf8ByteLength(String string) {
        int n = string.length();
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            l = (c & 0xFF80) == 0 ? ++l : ((c & 0xF800) == 0 ? (l += 2L) : (l += 3L));
            ++n2;
        }
        return l;
    }

    public static boolean isProtected(ItemHandle itemHandle) {
        boolean bl = ItemUtil$ProtectAdapter.INSTANCE.isAdapterOf(itemHandle);
        return bl;
    }

    public static Map createItemIdKeyMap() {
        return new TreeMap(itemIdComparator);
    }

    public static Map createStateIdKeyMap() {
        return new TreeMap(stateIdComparator);
    }

    public static boolean listsEqual(List list, List list2, Comparator comparator) {
        int n;
        if (list == list2) {
            return true;
        }
        if (list == null || list2 == null) {
            return false;
        }
        int n2 = list.size();
        if (n2 != (n = list2.size())) {
            return false;
        }
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Object e;
            Object e2 = iterator.next();
            if (comparator.compare(e2, e = iterator2.next()) == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean getBooleanProperty(EModelElement eModelElement, String string, String string2, boolean bl) {
        String string3 = ItemUtil.primGetProperty(eModelElement, string, string2);
        return string3 == null ? bl : string3.toLowerCase(Locale.ENGLISH).equals(Boolean.TRUE.toString());
    }

    public static boolean isQueryable(EStructuralFeature eStructuralFeature) {
        EAnnotation eAnnotation = eStructuralFeature.getEAnnotation(QUERYABLE_PROPERTY_STEREOTYPE);
        return eAnnotation != null;
    }

    public static boolean isUnique(EStructuralFeature eStructuralFeature) {
        return ItemUtil.isQueryable(eStructuralFeature) && ItemUtil.getBooleanProperty((EModelElement)eStructuralFeature, QUERYABLE_PROPERTY_STEREOTYPE, UNIQUE_PROPERTY, false);
    }

    public static boolean isStateExtensionsFeature(EStructuralFeature eStructuralFeature) {
        return EXTENSIONS_FEATURES.contains(eStructuralFeature);
    }

    public static String[] getStateExtensionsPropertyNamesAsImplemented() {
        return EXTENSIONS_FEATURE_NAMES;
    }

    public static String[] expandPropertiesForStateExtensions(IItemType iItemType, String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (!iItemType.allowsStateExtensions()) {
            return stringArray;
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(Arrays.asList(stringArray));
        boolean bl = false;
        boolean bl2 = bl = linkedHashSet.contains("com.ibm.team.repository.item.allStateExtensions") || ItemUtil.containsAny(linkedHashSet, EXTENSIONS_FEATURE_NAMES);
        if (bl) {
            linkedHashSet.remove("com.ibm.team.repository.item.allStateExtensions");
            linkedHashSet.addAll(Arrays.asList(EXTENSIONS_FEATURE_NAMES));
            return linkedHashSet.toArray(new String[linkedHashSet.size()]);
        }
        return stringArray;
    }

    private static boolean containsAny(Set set, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (set.contains(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static String primGetProperty(EModelElement eModelElement, String string, String string2) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(string);
        return eAnnotation == null ? null : (String)eAnnotation.getDetails().get((Object)string2);
    }

    static /* synthetic */ EDataType access$0() {
        return ESTRING;
    }
}

