/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.IHelperType;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.IVirtualType;
import com.ibm.team.repository.common.internal.util.ComponentElementDescriptor;
import com.ibm.team.repository.common.internal.util.ComponentRegistry$$Cold;
import com.ibm.team.repository.common.internal.util.IComponentElementDescriptor;
import com.ibm.team.repository.common.internal.util.IComponentRegistry;
import com.ibm.team.repository.common.internal.util.IModelElementDescriptor;
import com.ibm.team.repository.common.internal.util.IServiceElementDescriptor;
import com.ibm.team.repository.common.internal.util.InternalTeamPlatform;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.HelperType;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.model.VirtualType;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public class ComponentRegistry
extends ExtensionRegistryReader
implements IComponentRegistry {
    private static final String ATTRIBUTE_IS_NOT_UNIQUE_ERROR = "The %s bundle's plugin.xml file contains a <%s> element with the %s attribute value %s that is not unique.";
    private static final String NO_VERSION = new String();
    public static final String REPOSITORY_COMPONENT_ID = "com.ibm.team.repository";
    public static final IComponentRegistry INSTANCE = new ComponentRegistry();
    private Map idToComponentElementDescriptorMap;
    private Map idToLogMap;
    private Set localModelUriSet;
    private Set remoteModelUriSet;
    private Map modelUriToComponentElementDescriptorMap;
    private Map serviceUriToComponentElementDescriptorMap;
    private IItemType[] allItemTypesCache;
    private IVirtualType[] allVirtualTypesCache;
    private Object lock;

    private ComponentRegistry() {
        super("com.ibm.team.repository.common", "components");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAllMaps() {
        Object object;
        Object object2 = object = this.getLock();
        synchronized (object2) {
            this.clearIdToComponentElementDescriptorMap();
            this.clearNamespaceUriToComponentElementDescriptorMap();
            this.clearServiceUriToComponentElementDescriptorMap();
        }
    }

    private void clearIdToComponentElementDescriptorMap() {
        Map map = this.getIdToComponentElementDescriptorMap();
        map.clear();
    }

    private void clearNamespaceUriToComponentElementDescriptorMap() {
        Map map = this.getModelUriToComponentElementDescriptorMap();
        map.clear();
    }

    private void clearServiceUriToComponentElementDescriptorMap() {
        Map map = this.getServiceUriToComponentElementDescriptorMap();
        map.clear();
    }

    public IHelperType[] getAllHelperTypes() {
        IHelperType[] iHelperTypeArray = this.getAllHelperTypes(false);
        return iHelperTypeArray;
    }

    public IItemType[] getAllItemTypes(boolean bl) {
        return this.getItemTypes(bl, this.getAllModelURIs());
    }

    public IVirtualType[] getAllVirtualTypes(boolean bl) {
        return this.getVirtualTypes(bl);
    }

    public String getComponentId(IType iType) {
        IComponentElementDescriptor iComponentElementDescriptor = this.getComponentDescriptor(iType);
        String string = this.getId(iComponentElementDescriptor);
        return string;
    }

    public String getComponentId(String string) {
        IComponentElementDescriptor iComponentElementDescriptor = this.getComponentDescriptorForModelUri(string);
        String string2 = this.getId(iComponentElementDescriptor);
        return string2;
    }

    private Map getIdToComponentElementDescriptorMap() {
        return this.idToComponentElementDescriptorMap;
    }

    private Map getIdToLogMap() {
        return this.idToLogMap;
    }

    protected void checkStarted() {
        super.checkStarted();
        if (!InternalTeamPlatform.getDefault().isStarted()) {
            throw (Throwable)new IllegalStateException("TeamPlatform must be started.");
        }
    }

    public IItemType[] getLocalItemTypes() {
        Set set = this.getLocalModelUriSet();
        IItemType[] iItemTypeArray = this.getItemTypes(false, set);
        return iItemTypeArray;
    }

    private Set getLocalModelUriSet() {
        return this.localModelUriSet;
    }

    private Object getLock() {
        return this.lock;
    }

    private Map getModelUriToComponentElementDescriptorMap() {
        return this.modelUriToComponentElementDescriptorMap;
    }

    private Set getRemoteModelUriSet() {
        return this.remoteModelUriSet;
    }

    private RepositoryPackage getRepositoryPackage() {
        return RepositoryPackage.eINSTANCE;
    }

    private Map getServiceUriToComponentElementDescriptorMap() {
        return this.serviceUriToComponentElementDescriptorMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IComponentElementDescriptor handleExtensionAdded(IConfigurationElement iConfigurationElement) {
        ComponentElementDescriptor componentElementDescriptor = null;
        try {
            Object object;
            componentElementDescriptor = new ComponentElementDescriptor(iConfigurationElement);
            Map map = this.getIdToComponentElementDescriptorMap();
            Map map2 = this.getModelUriToComponentElementDescriptorMap();
            Map map3 = this.getServiceUriToComponentElementDescriptorMap();
            String string = componentElementDescriptor.getIdAttribute();
            IModelElementDescriptor iModelElementDescriptor = componentElementDescriptor.getModelElementDescriptor();
            List list = componentElementDescriptor.getServiceElementDescriptors();
            Object object2 = object = this.getLock();
            synchronized (object2) {
                boolean bl = map.containsKey(string);
                if (bl) {
                    String string2 = componentElementDescriptor.getBundleSymbolicName();
                    String string3 = String.format(ATTRIBUTE_IS_NOT_UNIQUE_ERROR, string2, "component", "id", string);
                    throw (Throwable)new IllegalArgumentException(string3);
                }
                this.flushCachedTypes();
                map.put(string, componentElementDescriptor);
                if (iModelElementDescriptor != null) {
                    Object object3 = iModelElementDescriptor.getUriAttribute();
                    bl = map2.containsKey(object3);
                    if (bl) {
                        String string4 = componentElementDescriptor.getBundleSymbolicName();
                        String string5 = String.format(ATTRIBUTE_IS_NOT_UNIQUE_ERROR, string4, "model", "uri", object3);
                        throw (Throwable)new IllegalArgumentException(string5);
                    }
                    map2.put(object3, componentElementDescriptor);
                    Set set = this.getLocalModelUriSet();
                    bl = set.contains(object3);
                    if (bl) {
                        String string6 = componentElementDescriptor.getBundleSymbolicName();
                        String string7 = String.format(ATTRIBUTE_IS_NOT_UNIQUE_ERROR, string6, "model", "uri", object3);
                        throw (Throwable)new IllegalArgumentException(string7);
                    }
                    set.add(object3);
                }
                for (Object object3 : list) {
                    String string8 = object3.getUriAttribute();
                    bl = map3.containsKey(string8);
                    if (bl) {
                        String string9 = componentElementDescriptor.getBundleSymbolicName();
                        String string10 = String.format(ATTRIBUTE_IS_NOT_UNIQUE_ERROR, string9, "service", "uri", string8);
                        throw (Throwable)new IllegalArgumentException(string10);
                    }
                    map3.put(string8, componentElementDescriptor);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = illegalArgumentException.getMessage();
            this.logError(string);
        }
        return componentElementDescriptor;
    }

    private void flushCachedTypes() {
        this.allItemTypesCache = null;
        this.allVirtualTypesCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleExtensionRemoved(IConfigurationElement iConfigurationElement, IComponentElementDescriptor iComponentElementDescriptor) {
        Object object;
        Map map = this.getIdToComponentElementDescriptorMap();
        Map map2 = this.getModelUriToComponentElementDescriptorMap();
        Map map3 = this.getServiceUriToComponentElementDescriptorMap();
        Object object2 = object = this.getLock();
        synchronized (object2) {
            Object object3;
            Object object4;
            String string = iComponentElementDescriptor.getIdAttribute();
            map.remove(string);
            IModelElementDescriptor iModelElementDescriptor = iComponentElementDescriptor.getModelElementDescriptor();
            if (iModelElementDescriptor != null) {
                object4 = iModelElementDescriptor.getUriAttribute();
                object3 = this.getLocalModelUriSet();
                object3.remove(object4);
                map2.remove(object4);
            }
            object4 = iComponentElementDescriptor.getServiceElementDescriptors();
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                object3 = (IServiceElementDescriptor)iterator.next();
                String string2 = object3.getUriAttribute();
                map3.remove(string2);
            }
            this.flushCachedTypes();
        }
    }

    protected void handleStopped() {
        this.clearAllMaps();
    }

    protected void initialize() {
        this.setLock(new Object());
        this.setIdToComponentElementDescriptorMap(new HashMap(this.estimateHashedCollectionSize(75)));
        this.setIdToLogMap(new HashMap(this.estimateHashedCollectionSize(75)));
        this.setLocalModelUriSet(new HashSet(this.estimateHashedCollectionSize(75)));
        this.setRemoteModelUriSet(new HashSet(this.estimateHashedCollectionSize(75)));
        this.setModelUriToComponentElementDescriptorMap(new HashMap(this.estimateHashedCollectionSize(75)));
        this.setServiceUriToComponentElementDescriptorMap(new HashMap(this.estimateHashedCollectionSize(275)));
    }

    private void setIdToComponentElementDescriptorMap(Map map) {
        this.idToComponentElementDescriptorMap = map;
    }

    private void setIdToLogMap(Map map) {
        this.idToLogMap = map;
    }

    private void setLocalModelUriSet(Set set) {
        this.localModelUriSet = set;
    }

    private void setLock(Object object) {
        this.lock = object;
    }

    private void setModelUriToComponentElementDescriptorMap(Map map) {
        this.modelUriToComponentElementDescriptorMap = map;
    }

    private void setRemoteModelUriSet(Set set) {
        this.remoteModelUriSet = set;
    }

    private void setServiceUriToComponentElementDescriptorMap(Map map) {
        this.serviceUriToComponentElementDescriptorMap = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHelperType[] getAllHelperTypes(boolean bl) {
        Object object;
        this.checkStarted();
        Object object2 = object = this.getLock();
        synchronized (object2) {
            RepositoryPackage repositoryPackage = this.getRepositoryPackage();
            EClass eClass = repositoryPackage.getHelper();
            Set set = this.getAllModelURIs();
            int n = set.size();
            ArrayList<HelperType> arrayList = new ArrayList<HelperType>(n);
            for (String string : set) {
                EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(string);
                if (ePackage == null) continue;
                TreeIterator treeIterator = ePackage.eAllContents();
                while (treeIterator.hasNext()) {
                    EObject eObject = (EObject)treeIterator.next();
                    if (eObject instanceof EClass) {
                        EClass eClass2 = (EClass)eObject;
                        if ((bl || !eClass2.isAbstract()) && eClass.isSuperTypeOf(eClass2)) {
                            HelperType helperType = ItemUtil.helperTypeFor(eClass2);
                            arrayList.add(helperType);
                        }
                    }
                    if (eObject instanceof EPackage) continue;
                    treeIterator.prune();
                }
            }
            int n2 = arrayList.size();
            IHelperType[] iHelperTypeArray = new IHelperType[n2];
            arrayList.toArray(iHelperTypeArray);
            return iHelperTypeArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IItemType[] getAllItemTypes() {
        Object object;
        Object object2 = object = this.getLock();
        synchronized (object2) {
            if (this.allItemTypesCache == null) {
                this.allItemTypesCache = this.getAllItemTypes(false);
            }
            return this.allItemTypesCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVirtualType[] getAllVirtualTypes() {
        Object object;
        Object object2 = object = this.getLock();
        synchronized (object2) {
            if (this.allVirtualTypesCache == null) {
                this.allVirtualTypesCache = this.getAllVirtualTypes(false);
            }
            return this.allVirtualTypesCache;
        }
    }

    public IVirtualType getVirtualType(String string, String string2) {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("name must not be null");
        }
        if (string2 == null) {
            throw (Throwable)new IllegalArgumentException("namespace must not be null");
        }
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(string2);
        if (ePackage == null) {
            return null;
        }
        EClassifier eClassifier = ePackage.getEClassifier(string);
        if (!(eClassifier instanceof EClass)) {
            return null;
        }
        EClass eClass = (EClass)eClassifier;
        RepositoryPackage repositoryPackage = this.getRepositoryPackage();
        if (eClass == repositoryPackage.getVirtual() || !repositoryPackage.getVirtual().isSuperTypeOf(eClass)) {
            return null;
        }
        VirtualType virtualType = ItemUtil.virtualTypeFor(string, string2);
        return virtualType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAllModelURIs() {
        HashSet hashSet;
        Object object;
        this.checkStarted();
        Set set = this.getLocalModelUriSet();
        Set set2 = this.getRemoteModelUriSet();
        Object object2 = object = this.getLock();
        synchronized (object2) {
            int n = set.size() + set2.size();
            hashSet = new HashSet(n);
            hashSet.addAll(set);
            hashSet.addAll(set2);
        }
        return hashSet;
    }

    public IComponentElementDescriptor getComponentDescriptor(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement == null) {
            throw (Throwable)new IllegalArgumentException("element must not be null");
        }
        this.checkStarted();
        IComponentElementDescriptor iComponentElementDescriptor = (IComponentElementDescriptor)this.getDescriptor(iConfigurationElement);
        return iComponentElementDescriptor;
    }

    public IComponentElementDescriptor getComponentDescriptor(IType iType) throws  {
        return ComponentRegistry$$Cold.getComponentDescriptor(this, iType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComponentElementDescriptor getComponentDescriptorForId(String string) {
        IComponentElementDescriptor iComponentElementDescriptor;
        Object object;
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("id must not be null");
        }
        this.checkStarted();
        Map map = this.getIdToComponentElementDescriptorMap();
        Object object2 = object = this.getLock();
        synchronized (object2) {
            iComponentElementDescriptor = (IComponentElementDescriptor)map.get(string);
            if (iComponentElementDescriptor == null) {
                String string2 = String.format("Failed to find IComponentElementDescriptor for id %s", string);
                throw (Throwable)new IllegalArgumentException(string2);
            }
        }
        return iComponentElementDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComponentElementDescriptor getComponentDescriptorForModelUri(String string) {
        IComponentElementDescriptor iComponentElementDescriptor;
        Object object;
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("uri must not be null");
        }
        this.checkStarted();
        Map map = this.getModelUriToComponentElementDescriptorMap();
        Object object2 = object = this.getLock();
        synchronized (object2) {
            iComponentElementDescriptor = (IComponentElementDescriptor)map.get(string);
            if (iComponentElementDescriptor == null) {
                String string2 = String.format("Failed to find IComponentElementDescriptor for URI %s", string);
                throw (Throwable)new IllegalArgumentException(string2);
            }
        }
        return iComponentElementDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComponentElementDescriptor getComponentDescriptorForServiceUri(String string) {
        IComponentElementDescriptor iComponentElementDescriptor;
        Object object;
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("serviceUri must not be null");
        }
        this.checkStarted();
        Map map = this.getServiceUriToComponentElementDescriptorMap();
        Object object2 = object = this.getLock();
        synchronized (object2) {
            iComponentElementDescriptor = (IComponentElementDescriptor)map.get(string);
        }
        return iComponentElementDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getComponentDescriptors() {
        ArrayList arrayList;
        Object object;
        this.checkStarted();
        Map map = this.getIdToComponentElementDescriptorMap();
        Object object2 = object = this.getLock();
        synchronized (object2) {
            Collection collection = map.values();
            int n = collection.size();
            arrayList = new ArrayList(n);
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    public IHelperType getHelperType(String string, String string2) {
        EClass eClass;
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("name must not be null");
        }
        if (string2 == null) {
            throw (Throwable)new IllegalArgumentException("modelUri must not be null");
        }
        Set set = this.getAllModelURIs();
        boolean bl = set.contains(string2);
        if (!bl) {
            return null;
        }
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(string2);
        if (ePackage == null) {
            return null;
        }
        EClassifier eClassifier = ePackage.getEClassifier(string);
        if (!(eClassifier instanceof EClass)) {
            return null;
        }
        RepositoryPackage repositoryPackage = this.getRepositoryPackage();
        EClass eClass2 = repositoryPackage.getHelper();
        if (!eClass2.isSuperTypeOf(eClass = (EClass)eClassifier)) {
            return null;
        }
        HelperType helperType = ItemUtil.helperTypeFor(string, string2);
        return helperType;
    }

    private String getId(IComponentElementDescriptor iComponentElementDescriptor) throws  {
        return ComponentRegistry$$Cold.getId(this, iComponentElementDescriptor);
    }

    public IItemType getItemType(String string, String string2) {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("name must not be null");
        }
        if (string2 == null) {
            throw (Throwable)new IllegalArgumentException("modelUri must not be null");
        }
        Set set = this.getAllModelURIs();
        boolean bl = set.contains(string2);
        if (!bl) {
            return null;
        }
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(string2);
        if (ePackage == null) {
            return null;
        }
        EClassifier eClassifier = ePackage.getEClassifier(string);
        if (!(eClassifier instanceof EClass)) {
            return null;
        }
        EClass eClass = (EClass)eClassifier;
        RepositoryPackage repositoryPackage = this.getRepositoryPackage();
        if (eClass == repositoryPackage.getAuditable() || eClass == repositoryPackage.getUnmanagedItem() || eClass == repositoryPackage.getSimpleItem() || !repositoryPackage.getItem().isSuperTypeOf(eClass)) {
            return null;
        }
        ItemType itemType = ItemUtil.itemTypeFor(string, string2);
        return itemType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IItemType[] getItemTypes(boolean bl, Set set) {
        Object object;
        this.checkStarted();
        Object object2 = object = this.getLock();
        synchronized (object2) {
            RepositoryPackage repositoryPackage = this.getRepositoryPackage();
            EClass eClass = repositoryPackage.getAuditable();
            EClass eClass2 = repositoryPackage.getUnmanagedItem();
            EClass eClass3 = repositoryPackage.getSimpleItem();
            EClass eClass4 = repositoryPackage.getItem();
            int n = set.size();
            ArrayList<ItemType> arrayList = new ArrayList<ItemType>(n);
            for (String string : set) {
                EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(string);
                if (ePackage == null) continue;
                TreeIterator treeIterator = ePackage.eAllContents();
                while (treeIterator.hasNext()) {
                    EObject eObject = (EObject)treeIterator.next();
                    if (eObject instanceof EClass) {
                        EClass eClass5 = (EClass)eObject;
                        if ((bl || !eClass5.isAbstract()) && eClass5 != eClass && eClass5 != eClass2 && eClass5 != eClass3 && eClass4.isSuperTypeOf(eClass5)) {
                            ItemType itemType = ItemUtil.itemTypeFor(eClass5);
                            arrayList.add(itemType);
                        }
                    }
                    if (eObject instanceof EPackage) continue;
                    treeIterator.prune();
                }
            }
            int n2 = arrayList.size();
            IItemType[] iItemTypeArray = new IItemType[n2];
            arrayList.toArray(iItemTypeArray);
            return iItemTypeArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IVirtualType[] getVirtualTypes(boolean bl) {
        Object object;
        this.checkStarted();
        Object object2 = object = this.getLock();
        synchronized (object2) {
            RepositoryPackage repositoryPackage = this.getRepositoryPackage();
            EClass eClass = repositoryPackage.getVirtual();
            ArrayList<VirtualType> arrayList = new ArrayList<VirtualType>(59);
            EPackage.Registry.INSTANCE.values();
            for (Object e : EPackage.Registry.INSTANCE.values()) {
                if (!(e instanceof EPackage)) continue;
                EPackage ePackage = (EPackage)e;
                TreeIterator treeIterator = ePackage.eAllContents();
                while (treeIterator.hasNext()) {
                    EObject eObject = (EObject)treeIterator.next();
                    if (eObject instanceof EClass) {
                        EClass eClass2 = (EClass)eObject;
                        if ((bl || !eClass2.isAbstract()) && eClass2 != eClass && eClass.isSuperTypeOf(eClass2)) {
                            VirtualType virtualType = ItemUtil.virtualTypeFor(eClass2);
                            arrayList.add(virtualType);
                        }
                    }
                    if (eObject instanceof EPackage) continue;
                    treeIterator.prune();
                }
            }
            int n = arrayList.size();
            IVirtualType[] iVirtualTypeArray = new IVirtualType[n];
            arrayList.toArray(iVirtualTypeArray);
            return iVirtualTypeArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log getLog(String string) {
        Object object;
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("id must not be null");
        }
        this.checkStarted();
        Map map = this.getIdToLogMap();
        Object object2 = object = this.getLock();
        synchronized (object2) {
            Log log = (Log)map.get(string);
            if (log == null) {
                log = LogFactory.getLog((String)string);
                map.put(string, log);
            }
            return log;
        }
    }

    public String getModelVersion(String string) throws  {
        return ComponentRegistry$$Cold.getModelVersion(this, string);
    }

    public String getServiceVersion(String string) {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("serviceUri must not be null");
        }
        IComponentElementDescriptor iComponentElementDescriptor = this.getComponentDescriptorForServiceUri(string);
        if (iComponentElementDescriptor == null) {
            return NO_VERSION;
        }
        IServiceElementDescriptor iServiceElementDescriptor = iComponentElementDescriptor.getServiceElementDescriptor(string);
        if (iServiceElementDescriptor == null) {
            return NO_VERSION;
        }
        String string2 = iServiceElementDescriptor.getVersionAttribute();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComponent(String string) {
        boolean bl;
        Object object;
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("id must not be null");
        }
        this.checkStarted();
        Map map = this.getIdToComponentElementDescriptorMap();
        Object object2 = object = this.getLock();
        synchronized (object2) {
            bl = map.containsKey(string);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRemoteModel(String string, String string2, String string3, String string4) {
        Object object;
        if (string4 == null) {
            throw (Throwable)new IllegalArgumentException("uri must not be null");
        }
        this.checkStarted();
        Set set = this.getRemoteModelUriSet();
        Object object2 = object = this.getLock();
        synchronized (object2) {
            set.add(string4);
        }
    }
}

