/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.querypath;

import com.ibm.team.repository.common.internal.queryast.ComparisonOp;
import com.ibm.team.repository.common.internal.queryast.ElementType;
import com.ibm.team.repository.common.internal.queryast.FeaturePath;
import com.ibm.team.repository.common.internal.queryast.FilterElement;
import com.ibm.team.repository.common.internal.queryast.InList;
import com.ibm.team.repository.common.internal.queryast.Literal;
import com.ibm.team.repository.common.internal.queryast.QueryastFactory;
import com.ibm.team.repository.common.internal.querypath.AbstractQueryModelField;
import com.ibm.team.repository.common.internal.querypath.IQueryPath;
import com.ibm.team.repository.common.internal.util.SafeSimpleDataFormat;
import com.ibm.team.repository.common.query.ast.IDateTime;
import com.ibm.team.repository.common.query.ast.IDateTimeField;
import com.ibm.team.repository.common.query.ast.IPredicate;
import java.util.Date;

public class DateTimeField
extends AbstractQueryModelField
implements IDateTimeField {
    public DateTimeField(IQueryPath iQueryPath, String string) {
        this.name(string);
        this.parent(iQueryPath);
    }

    public ElementType getFieldType() {
        return ElementType.DATE_TIME_LITERAL;
    }

    public IPredicate _in(IDateTime[] iDateTimeArray) {
        this.checkInPredicateValueArray(iDateTimeArray);
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this);
        InList inList = QueryastFactory.eINSTANCE.createInList();
        inList.setField(featurePath);
        IDateTime[] iDateTimeArray2 = iDateTimeArray;
        int n = iDateTimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDateTime iDateTime = iDateTimeArray2[n2];
            this.checkInPredicateNullValue(iDateTime);
            FilterElement filterElement = QueryastFactory.eINSTANCE.createFilterElement(iDateTime);
            inList.getValues().add((Object)filterElement);
            ++n2;
        }
        return inList;
    }

    public IPredicate _in(Date[] dateArray) {
        this.checkInPredicateValueArray(dateArray);
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this);
        InList inList = QueryastFactory.eINSTANCE.createInList();
        inList.setField(featurePath);
        Date[] dateArray2 = dateArray;
        int n = dateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Date date = dateArray2[n2];
            Literal literal = QueryastFactory.eINSTANCE.createLiteral();
            literal.setKind(ElementType.DATE_TIME_LITERAL);
            literal.setStringValue(SafeSimpleDataFormat.DATE_FORMATS[0].format(date));
            inList.getValues().add((Object)literal);
            ++n2;
        }
        return inList;
    }

    public IPredicate _eq(Date date) {
        return this.createBasicComparison(ComparisonOp.EQUALS_LITERAL, date);
    }

    public IPredicate _eq(IDateTime iDateTime) {
        return this.createBasicComparison(ComparisonOp.EQUALS_LITERAL, iDateTime);
    }

    public IPredicate _gt(Date date) {
        return this.createBasicComparison(ComparisonOp.GREATER_THAN_LITERAL, date);
    }

    public IPredicate _gt(IDateTime iDateTime) {
        return this.createBasicComparison(ComparisonOp.GREATER_THAN_LITERAL, iDateTime);
    }

    public IPredicate _gtOrEq(Date date) {
        return this.createBasicComparison(ComparisonOp.GT_OR_EQ_LITERAL, date);
    }

    public IPredicate _gtOrEq(IDateTime iDateTime) {
        return this.createBasicComparison(ComparisonOp.GT_OR_EQ_LITERAL, iDateTime);
    }

    public IPredicate _lt(Date date) {
        return this.createBasicComparison(ComparisonOp.LESS_THAN_LITERAL, date);
    }

    public IPredicate _lt(IDateTime iDateTime) {
        return this.createBasicComparison(ComparisonOp.LESS_THAN_LITERAL, iDateTime);
    }

    public IPredicate _ltOrEq(Date date) {
        return this.createBasicComparison(ComparisonOp.LT_OR_EQ_LITERAL, date);
    }

    public IPredicate _ltOrEq(IDateTime iDateTime) {
        return this.createBasicComparison(ComparisonOp.LT_OR_EQ_LITERAL, iDateTime);
    }

    public IPredicate _notEq(Date date) {
        return this.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, date);
    }

    public IPredicate _notEq(IDateTime iDateTime) {
        return this.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, iDateTime);
    }

    private IPredicate createBasicComparison(ComparisonOp comparisonOp, Date date) {
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this);
        return QueryastFactory.eINSTANCE.createBasicComparison(comparisonOp, (FilterElement)featurePath, date);
    }

    private IPredicate createBasicComparison(ComparisonOp comparisonOp, IDateTime iDateTime) {
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this);
        return QueryastFactory.eINSTANCE.createBasicComparison(comparisonOp, (FilterElement)featurePath, iDateTime);
    }
}

