/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.querypath;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IItemType$IRegistry;
import com.ibm.team.repository.common.internal.querypath.AbstractQueryPathModel;
import com.ibm.team.repository.common.internal.querypath.IInternalQueryModel;
import com.ibm.team.repository.common.internal.querypath.IQueryPath;
import com.ibm.team.repository.common.internal.querypath.PathIterator;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.query.QueryException;
import com.ibm.team.repository.common.query.ast.IDynamicItemQueryModel;
import com.ibm.team.repository.common.query.ast.IDynamicQueryModel;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IItemQueryModel;
import com.ibm.team.repository.common.query.ast.IItemTypeInputArg;
import com.ibm.team.repository.common.query.ast.IManyItemQueryModel;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IPseudoVariable;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISingleItemQueryModel;
import com.ibm.team.repository.common.query.ast.ISingleQueryModel;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AbstractQueryPathModel$Implementation
implements IQueryPath,
ISingleItemQueryModel,
IManyItemQueryModel,
IDynamicQueryModel,
IDynamicItemQueryModel,
IInternalQueryModel {
    private final IQueryPath parent;
    private final String parentField;
    private boolean isSingle = true;
    private String typeName;
    private String nsURI;
    private final List allFieldNames = new ArrayList(10);
    private final List allReferenceNames = new ArrayList(10);
    private final Map allFields = new HashMap(10);
    final /* synthetic */ AbstractQueryPathModel this$0;

    private AbstractQueryPathModel$Implementation(AbstractQueryPathModel abstractQueryPathModel, IQueryPath iQueryPath, String string) {
        this.this$0 = abstractQueryPathModel;
        this.parent = iQueryPath;
        this.parentField = string;
    }

    public List getAllFields() {
        return Collections.unmodifiableList(this.allFieldNames);
    }

    public List getAllReferences() {
        return Collections.unmodifiableList(this.allReferenceNames);
    }

    public IField getField(String string) {
        IField iField = (IField)this.allFields.get(string);
        if (iField == null) {
            String string2 = NLS.bind("Unknown queryable field: {0}", string);
            throw (Throwable)new QueryException(string2);
        }
        return iField;
    }

    public IDynamicQueryModel getReference(String string) {
        AbstractQueryPathModel abstractQueryPathModel = this.this$0.getReference(string);
        if (abstractQueryPathModel == null) {
            String string2 = NLS.bind("Unknown queryable reference: {0}", string);
            throw (Throwable)new QueryException(string2);
        }
        return abstractQueryPathModel._implementation;
    }

    public IPredicate _contains(ISingleQueryModel iSingleQueryModel) {
        return this.this$0._contains(iSingleQueryModel);
    }

    public IPredicate _contains(IItemHandle iItemHandle) {
        return this.this$0._contains(iItemHandle);
    }

    public IPredicate _contains(IItemHandleInputArg iItemHandleInputArg) {
        return this.this$0._contains(iItemHandleInputArg);
    }

    public IPredicate _eq(IItemHandle iItemHandle) {
        return this.this$0._eq(iItemHandle);
    }

    public IPredicate _eq(IItemHandleInputArg iItemHandleInputArg) {
        return this.this$0._eq(iItemHandleInputArg);
    }

    public IPredicate _isNull() {
        return this.this$0._isNull();
    }

    public IPredicate _in(IItemHandleInputArg[] iItemHandleInputArgArray) {
        return this.this$0._in(iItemHandleInputArgArray);
    }

    public IPredicate _isTypeOf(IItemType iItemType) {
        return this.this$0._isTypeOf(iItemType);
    }

    public IPseudoVariable _itemType() {
        return this.this$0._itemType();
    }

    public IPredicate _isTypeOf(IItemTypeInputArg iItemTypeInputArg) {
        return this.this$0._isTypeOf(iItemTypeInputArg);
    }

    public IItemQueryModel _target(IItemQueryModel iItemQueryModel) {
        return this.this$0._target(iItemQueryModel);
    }

    public IPredicate _isEmpty() {
        return this.this$0._isEmpty();
    }

    public IPredicate _isMissing() {
        return this.this$0._isMissing();
    }

    public void setItemType(String string, String string2) {
        this.typeName = string;
        this.nsURI = string2;
    }

    public IItemType getItemType() {
        String string = "The type name {0} and the namespace URI {1} do not resolve to an IItemType.";
        if (this.typeName == null || this.nsURI == null) {
            String string2 = NLS.bind(string, this.typeName, this.nsURI);
            throw (Throwable)new IllegalArgumentException(string2);
        }
        IItemType iItemType = IItemType$IRegistry.INSTANCE.getItemType(this.typeName, this.nsURI);
        if (iItemType == null) {
            String string3 = NLS.bind(string, this.typeName, this.nsURI);
            throw (Throwable)new IllegalArgumentException(string3);
        }
        return iItemType;
    }

    public String pathStep() {
        return this.parentField();
    }

    public String parentField() {
        return this.parentField;
    }

    public IQueryPath parent() {
        return this.parent;
    }

    public boolean isSingleValueRef() {
        return this.isSingle;
    }

    public boolean isManyValuedRef() {
        return !this.isSingle;
    }

    public void setSingleValueRef(boolean bl) {
        this.isSingle = bl;
    }

    private boolean isRoot() {
        return this.parent == null;
    }

    public IQueryModel getRoot() {
        if (this.isRoot()) {
            return this;
        }
        IQueryPath iQueryPath = this;
        PathIterator pathIterator = this.iterator();
        while (pathIterator.hasNext()) {
            iQueryPath = pathIterator.next();
        }
        return iQueryPath;
    }

    private List getPath() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isRoot()) {
            return arrayList;
        }
        PathIterator pathIterator = this.iterator();
        while (pathIterator.hasNext()) {
            IQueryPath iQueryPath = pathIterator.next();
            if (iQueryPath.pathStep() == null) continue;
            arrayList.add(iQueryPath.pathStep());
        }
        Collections.reverse((List)arrayList);
        return arrayList;
    }

    public String toPathString() {
        if (this.isRoot()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getPath().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    public boolean isSingle() {
        if (this.isManyValuedRef()) {
            return false;
        }
        PathIterator pathIterator = this.iterator();
        while (pathIterator.hasNext()) {
            IQueryPath iQueryPath = pathIterator.next();
            if (!(iQueryPath instanceof IField) && !iQueryPath.isManyValuedRef()) continue;
            return false;
        }
        return true;
    }

    private boolean isSameAs(IQueryPath iQueryPath) {
        IQueryModel iQueryModel = this.getRoot();
        IQueryModel iQueryModel2 = iQueryPath.getRoot();
        if (!iQueryModel.getClass().equals(iQueryModel2.getClass())) {
            return false;
        }
        String string = this.toPathString();
        String string2 = iQueryPath.toPathString();
        return string.equals(string2);
    }

    public PathIterator iterator() {
        return new PathIterator(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof IQueryPath)) {
            return false;
        }
        return this.isSameAs((IQueryPath)object);
    }

    public String toString() {
        return "AbstractQueryPathModel.Implementation(" + this.this$0.getClass().getSimpleName() + ')';
    }

    public AbstractQueryPathModel$Implementation _getImplementation() {
        return this;
    }

    public IField getIdField() {
        if (this.this$0.isItem()) {
            return this.getField(RepositoryPackage.eINSTANCE.getItemHandle_ItemId().getName());
        }
        return this.getField(RepositoryPackage.eINSTANCE.getHelper_InternalId().getName());
    }

    public boolean isRetargeted() {
        return this.parentField.charAt(0) == '(';
    }

    /* synthetic */ AbstractQueryPathModel$Implementation(AbstractQueryPathModel abstractQueryPathModel, IQueryPath iQueryPath, String string, AbstractQueryPathModel$Implementation abstractQueryPathModel$Implementation) {
        this(abstractQueryPathModel, iQueryPath, string);
    }

    static /* synthetic */ List access$1(AbstractQueryPathModel$Implementation abstractQueryPathModel$Implementation) {
        return abstractQueryPathModel$Implementation.allFieldNames;
    }

    static /* synthetic */ List access$2(AbstractQueryPathModel$Implementation abstractQueryPathModel$Implementation) {
        return abstractQueryPathModel$Implementation.allReferenceNames;
    }

    static /* synthetic */ Map access$3(AbstractQueryPathModel$Implementation abstractQueryPathModel$Implementation) {
        return abstractQueryPathModel$Implementation.allFields;
    }

    static /* synthetic */ String access$4(AbstractQueryPathModel$Implementation abstractQueryPathModel$Implementation) {
        return abstractQueryPathModel$Implementation.typeName;
    }

    static /* synthetic */ String access$5(AbstractQueryPathModel$Implementation abstractQueryPathModel$Implementation) {
        return abstractQueryPathModel$Implementation.parentField;
    }

    static /* synthetic */ IQueryPath access$6(AbstractQueryPathModel$Implementation abstractQueryPathModel$Implementation) {
        return abstractQueryPathModel$Implementation.parent;
    }
}

