/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.repository.common.util.NLS;

public final class ItemNotFoundException
extends TeamRepositoryException {
    private static final long serialVersionUID = 1L;
    private static final String REPOSITORY_ITEM_NOT_FOUND = Messages.getServerString("ItemNotFoundException.ERROR_REFERENCED_ITEM_NOT_FOUND");

    @Deprecated
    public ItemNotFoundException() {
        this(Messages.getServerString("ItemNotFoundException.ERROR_ITEM_NOT_FOUND"));
    }

    public ItemNotFoundException(String message) {
        super(message);
    }

    public ItemNotFoundException(String message, Throwable t) {
        super(message, t);
    }

    public ItemNotFoundException(IItemHandle handle, Throwable cause) {
        super(NLS.bind(REPOSITORY_ITEM_NOT_FOUND, ItemNotFoundException.toHandle(handle)), cause);
        this.setData(handle);
    }

    public ItemNotFoundException(IItemHandle handle) {
        super(NLS.bind(REPOSITORY_ITEM_NOT_FOUND, ItemNotFoundException.toHandle(handle)));
        this.setData(handle);
    }

    public ItemNotFoundException(String message, IItemHandle handle) {
        super(message);
        this.setData(handle);
    }

    private static IItemHandle toHandle(IItemHandle handle) {
        if (!handle.hasFullState()) {
            return handle;
        }
        handle = ItemUtil.newItemHandle((ItemHandle)handle, false);
        return handle;
    }
}

