/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common;

import com.ibm.team.repository.common.model.SimpleItem;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.util.List;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.sdo.EChangeSummary;
import org.eclipse.emf.ecore.sdo.EChangeSummarySetting;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ItemChangeUtil {
    public static ItemChangeUtil INSTANCE = new ItemChangeUtil();

    private ItemChangeUtil() {
    }

    public SimpleItem prepareSimpleItemForSave(SimpleItem simpleItem) {
        if (simpleItem.isInitialState()) {
            return simpleItem;
        }
        EChangeSummary changeSummary = this.extractChangeSummary(simpleItem);
        if (changeSummary == null || changeSummary.getChangedDataObjects().isEmpty()) {
            return simpleItem;
        }
        EObject simpleItemCopy = EcoreUtil.copy((EObject)((EObject)simpleItem));
        EFactory simpleItemFactory = simpleItemCopy.eClass().getEPackage().getEFactoryInstance();
        SimpleItem newSimpleItem = (SimpleItem)simpleItemFactory.create(simpleItemCopy.eClass());
        newSimpleItem.setItemId(simpleItem.getItemId());
        newSimpleItem.setWorkingCopy(true);
        newSimpleItem.setOrigin(simpleItem.getOrigin());
        newSimpleItem.setStateId(simpleItem.getStateId());
        for (List featureChanges : changeSummary.getObjectChanges().values()) {
            int i = 0;
            while (i < featureChanges.size()) {
                EChangeSummarySetting changeSummarySetting = (EChangeSummarySetting)featureChanges.get(i);
                EStructuralFeature structuralFeature = changeSummarySetting.getFeature();
                this.applyChangesToSimpleItem(newSimpleItem, structuralFeature, simpleItemCopy.eGet(structuralFeature));
                ++i;
            }
        }
        return newSimpleItem;
    }

    private void applyChangesToSimpleItem(SimpleItem simpleItem, EStructuralFeature structuralFeature, Object value) {
        ((EObject)simpleItem).eSet(structuralFeature, value);
    }

    private EChangeSummary extractChangeSummary(SimpleItem simpleItem) {
        DataGraph graph = ((DataObject)simpleItem).getDataGraph();
        if (graph == null) {
            return null;
        }
        return (EChangeSummary)graph.getChangeSummary();
    }
}

