/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.links.internal.links.impl;

import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.internal.ReferenceUtils;
import com.ibm.team.links.internal.factory.ReferenceFactory;
import com.ibm.team.links.internal.links.LinksPackage;
import com.ibm.team.links.internal.links.Reference;
import com.ibm.team.links.internal.links.ReferenceSide;
import com.ibm.team.links.internal.links.ReferenceType;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.model.impl.HelperImpl;
import com.ibm.team.repository.common.util.NLS;
import commonj.sdo.DataObject;
import java.net.URI;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class ReferenceImpl
extends HelperImpl
implements Reference {
    private static final String UNSUPPORTED_REFERENCE_TYPE = "Unsupported reference type: \"{0}\"";
    protected int ALL_FLAGS = 0;
    protected static final String URI_EDEFAULT = "";
    protected String uri = "";
    protected static final int URI_ESETFLAG = 2;
    protected static final ReferenceType REFERENCE_TYPE_EDEFAULT = ReferenceType.ITEM_REFERENCE_LITERAL;
    protected ReferenceType referenceType = REFERENCE_TYPE_EDEFAULT;
    protected static final int REFERENCE_TYPE_ESETFLAG = 4;
    protected IItemHandle referencedItem;
    protected static final int REFERENCED_ITEM_ESETFLAG = 8;
    protected static final String COMMENT_EDEFAULT = "";
    protected String comment = "";
    protected static final int COMMENT_ESETFLAG = 16;
    protected static final ReferenceSide REFERENCE_SIDE_EDEFAULT = ReferenceSide.SRC_LITERAL;
    protected ReferenceSide referenceSide = REFERENCE_SIDE_EDEFAULT;
    protected static final int REFERENCE_SIDE_ESETFLAG = 32;
    protected static final String EXTRA_INFO_EDEFAULT = null;
    protected String extraInfo = EXTRA_INFO_EDEFAULT;
    protected static final int EXTRA_INFO_ESETFLAG = 64;
    private static final int EOFFSET_CORRECTION = LinksPackage.Literals.REFERENCE.getFeatureID((EStructuralFeature)LinksPackage.Literals.REFERENCE__URI) - 1;

    protected ReferenceImpl() {
    }

    protected EClass eStaticClass() {
        return LinksPackage.Literals.REFERENCE;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String newUri) {
        String oldUri = this.uri;
        this.uri = newUri;
        boolean oldUriESet = (this.ALL_FLAGS & 2) != 0;
        this.ALL_FLAGS |= 2;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1 + EOFFSET_CORRECTION, (Object)oldUri, (Object)this.uri, !oldUriESet));
        }
    }

    public void unsetUri() {
        String oldUri = this.uri;
        boolean oldUriESet = (this.ALL_FLAGS & 2) != 0;
        this.uri = "";
        this.ALL_FLAGS &= 0xFFFFFFFD;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 1 + EOFFSET_CORRECTION, (Object)oldUri, (Object)"", oldUriESet));
        }
    }

    public boolean isSetUri() {
        return (this.ALL_FLAGS & 2) != 0;
    }

    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(ReferenceType newReferenceType) {
        ReferenceType oldReferenceType = this.referenceType;
        this.referenceType = newReferenceType == null ? REFERENCE_TYPE_EDEFAULT : newReferenceType;
        boolean oldReferenceTypeESet = (this.ALL_FLAGS & 4) != 0;
        this.ALL_FLAGS |= 4;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2 + EOFFSET_CORRECTION, (Object)oldReferenceType, (Object)this.referenceType, !oldReferenceTypeESet));
        }
    }

    public void unsetReferenceType() {
        ReferenceType oldReferenceType = this.referenceType;
        boolean oldReferenceTypeESet = (this.ALL_FLAGS & 4) != 0;
        this.referenceType = REFERENCE_TYPE_EDEFAULT;
        this.ALL_FLAGS &= 0xFFFFFFFB;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 2 + EOFFSET_CORRECTION, (Object)oldReferenceType, (Object)REFERENCE_TYPE_EDEFAULT, oldReferenceTypeESet));
        }
    }

    public boolean isSetReferenceType() {
        return (this.ALL_FLAGS & 4) != 0;
    }

    public IItemHandle getReferencedItem() {
        if (this.referencedItem != null && ((EObject)this.referencedItem).eIsProxy()) {
            InternalEObject oldReferencedItem = (InternalEObject)this.referencedItem;
            this.referencedItem = (IItemHandle)this.eResolveProxy(oldReferencedItem);
            if (this.referencedItem != oldReferencedItem && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3 + EOFFSET_CORRECTION, (Object)oldReferencedItem, (Object)this.referencedItem));
            }
        }
        return this.referencedItem;
    }

    public IItemHandle basicGetReferencedItem() {
        return this.referencedItem;
    }

    public void setReferencedItem(IItemHandle newReferencedItem) {
        IItemHandle oldReferencedItem = this.referencedItem;
        this.referencedItem = newReferencedItem;
        boolean oldReferencedItemESet = (this.ALL_FLAGS & 8) != 0;
        this.ALL_FLAGS |= 8;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3 + EOFFSET_CORRECTION, (Object)oldReferencedItem, (Object)this.referencedItem, !oldReferencedItemESet));
        }
    }

    public void unsetReferencedItem() {
        IItemHandle oldReferencedItem = this.referencedItem;
        boolean oldReferencedItemESet = (this.ALL_FLAGS & 8) != 0;
        this.referencedItem = null;
        this.ALL_FLAGS &= 0xFFFFFFF7;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 3 + EOFFSET_CORRECTION, (Object)oldReferencedItem, null, oldReferencedItemESet));
        }
    }

    public boolean isSetReferencedItem() {
        return (this.ALL_FLAGS & 8) != 0;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String newComment) {
        String oldComment = this.comment;
        this.comment = newComment;
        boolean oldCommentESet = (this.ALL_FLAGS & 0x10) != 0;
        this.ALL_FLAGS |= 0x10;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4 + EOFFSET_CORRECTION, (Object)oldComment, (Object)this.comment, !oldCommentESet));
        }
    }

    public void unsetComment() {
        String oldComment = this.comment;
        boolean oldCommentESet = (this.ALL_FLAGS & 0x10) != 0;
        this.comment = "";
        this.ALL_FLAGS &= 0xFFFFFFEF;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 4 + EOFFSET_CORRECTION, (Object)oldComment, (Object)"", oldCommentESet));
        }
    }

    public boolean isSetComment() {
        return (this.ALL_FLAGS & 0x10) != 0;
    }

    public ReferenceSide getReferenceSide() {
        return this.referenceSide;
    }

    public void setReferenceSide(ReferenceSide newReferenceSide) {
        ReferenceSide oldReferenceSide = this.referenceSide;
        this.referenceSide = newReferenceSide == null ? REFERENCE_SIDE_EDEFAULT : newReferenceSide;
        boolean oldReferenceSideESet = (this.ALL_FLAGS & 0x20) != 0;
        this.ALL_FLAGS |= 0x20;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5 + EOFFSET_CORRECTION, (Object)oldReferenceSide, (Object)this.referenceSide, !oldReferenceSideESet));
        }
    }

    public void unsetReferenceSide() {
        ReferenceSide oldReferenceSide = this.referenceSide;
        boolean oldReferenceSideESet = (this.ALL_FLAGS & 0x20) != 0;
        this.referenceSide = REFERENCE_SIDE_EDEFAULT;
        this.ALL_FLAGS &= 0xFFFFFFDF;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 5 + EOFFSET_CORRECTION, (Object)oldReferenceSide, (Object)REFERENCE_SIDE_EDEFAULT, oldReferenceSideESet));
        }
    }

    public boolean isSetReferenceSide() {
        return (this.ALL_FLAGS & 0x20) != 0;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(String newExtraInfo) {
        String oldExtraInfo = this.extraInfo;
        this.extraInfo = newExtraInfo;
        boolean oldExtraInfoESet = (this.ALL_FLAGS & 0x40) != 0;
        this.ALL_FLAGS |= 0x40;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6 + EOFFSET_CORRECTION, (Object)oldExtraInfo, (Object)this.extraInfo, !oldExtraInfoESet));
        }
    }

    public void unsetExtraInfo() {
        String oldExtraInfo = this.extraInfo;
        boolean oldExtraInfoESet = (this.ALL_FLAGS & 0x40) != 0;
        this.extraInfo = EXTRA_INFO_EDEFAULT;
        this.ALL_FLAGS &= 0xFFFFFFBF;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 6 + EOFFSET_CORRECTION, (Object)oldExtraInfo, (Object)EXTRA_INFO_EDEFAULT, oldExtraInfoESet));
        }
    }

    public boolean isSetExtraInfo() {
        return (this.ALL_FLAGS & 0x40) != 0;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 1: {
                return this.getUri();
            }
            case 2: {
                return this.getReferenceType();
            }
            case 3: {
                if (resolve) {
                    return this.getReferencedItem();
                }
                return this.basicGetReferencedItem();
            }
            case 4: {
                return this.getComment();
            }
            case 5: {
                return this.getReferenceSide();
            }
            case 6: {
                return this.getExtraInfo();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 1: {
                this.setUri((String)newValue);
                return;
            }
            case 2: {
                this.setReferenceType((ReferenceType)((Object)newValue));
                return;
            }
            case 3: {
                this.setReferencedItem((IItemHandle)newValue);
                return;
            }
            case 4: {
                this.setComment((String)newValue);
                return;
            }
            case 5: {
                this.setReferenceSide((ReferenceSide)((Object)newValue));
                return;
            }
            case 6: {
                this.setExtraInfo((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 1: {
                this.unsetUri();
                return;
            }
            case 2: {
                this.unsetReferenceType();
                return;
            }
            case 3: {
                this.unsetReferencedItem();
                return;
            }
            case 4: {
                this.unsetComment();
                return;
            }
            case 5: {
                this.unsetReferenceSide();
                return;
            }
            case 6: {
                this.unsetExtraInfo();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 1: {
                return this.isSetUri();
            }
            case 2: {
                return this.isSetReferenceType();
            }
            case 3: {
                return this.isSetReferencedItem();
            }
            case 4: {
                return this.isSetComment();
            }
            case 5: {
                return this.isSetReferenceSide();
            }
            case 6: {
                return this.isSetExtraInfo();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class baseClass) {
        if (baseClass == IReference.class) {
            return -1;
        }
        if (baseClass == Reference.class) {
            switch (baseFeatureID - EOFFSET_CORRECTION) {
                case 1: {
                    return 1 + EOFFSET_CORRECTION;
                }
                case 2: {
                    return 2 + EOFFSET_CORRECTION;
                }
                case 3: {
                    return 3 + EOFFSET_CORRECTION;
                }
                case 4: {
                    return 4 + EOFFSET_CORRECTION;
                }
                case 5: {
                    return 5 + EOFFSET_CORRECTION;
                }
                case 6: {
                    return 6 + EOFFSET_CORRECTION;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (uri: ");
        if ((this.ALL_FLAGS & 2) != 0) {
            result.append(this.uri);
        } else {
            result.append("<unset>");
        }
        result.append(", referenceType: ");
        if ((this.ALL_FLAGS & 4) != 0) {
            result.append((Object)this.referenceType);
        } else {
            result.append("<unset>");
        }
        result.append(", comment: ");
        if ((this.ALL_FLAGS & 0x10) != 0) {
            result.append(this.comment);
        } else {
            result.append("<unset>");
        }
        result.append(", referenceSide: ");
        if ((this.ALL_FLAGS & 0x20) != 0) {
            result.append((Object)this.referenceSide);
        } else {
            result.append("<unset>");
        }
        result.append(", extraInfo: ");
        if ((this.ALL_FLAGS & 0x40) != 0) {
            result.append(this.extraInfo);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public IReference makeClone() {
        switch (this.getReferenceType().getValue()) {
            case 0: {
                return this.cloneItemReference();
            }
            case 2: {
                return this.cloneURIeference();
            }
        }
        throw new RuntimeException(NLS.bind(UNSUPPORTED_REFERENCE_TYPE, this.getReferenceType().getName()));
    }

    private IReference cloneItemReference() {
        return ReferenceFactory.INSTANCE.createReferenceToItem(this.resolveItemReference(), this.getComment(), this.getExtraInfo());
    }

    private IReference cloneURIeference() {
        return ReferenceFactory.INSTANCE.createReferenceFromURI(URI.create(this.getUri()), this.getComment(), this.getExtraInfo());
    }

    public Object resolve() {
        switch (this.getReferenceType().getValue()) {
            case 0: {
                return this.resolveItemReference();
            }
            case 2: {
                return this.resolveURIeference();
            }
        }
        throw new RuntimeException(NLS.bind(UNSUPPORTED_REFERENCE_TYPE, this.getReferenceType().getName()));
    }

    private IItemHandle resolveItemReference() {
        IItemHandle referencedObject = this.getReferencedItem();
        if (referencedObject != null) {
            return referencedObject;
        }
        throw new RuntimeException("Item reference has no item field set");
    }

    private Object resolveURIeference() {
        return ReferenceUtils.INSTANCE.resolveURI(this.getUri());
    }

    public boolean sameDetailsAs(IReference other) {
        Reference r2 = (Reference)other;
        if (!this.equals(this.getComment(), r2.getComment())) {
            return false;
        }
        if (!this.equals(this.getExtraInfo(), r2.getExtraInfo())) {
            return false;
        }
        return this.sameDetailsExcludingCommentAs(other);
    }

    public boolean sameDetailsExcludingCommentAs(IReference other) {
        Reference r2 = (Reference)other;
        if (this.getReferenceType() != r2.getReferenceType()) {
            return false;
        }
        switch (this.getReferenceType().getValue()) {
            case 0: {
                return this.sameItemReferenceDetails(r2);
            }
            case 2: {
                return this.getUri().equals(r2.getUri());
            }
        }
        throw new RuntimeException(NLS.bind(UNSUPPORTED_REFERENCE_TYPE, this.getReferenceType().getName()));
    }

    private boolean sameItemReferenceDetails(Reference r2) {
        return this.getReferencedItem() != null && r2.getReferencedItem() != null && this.getReferencedItem().getItemId().equals(r2.getReferencedItem().getItemId());
    }

    private boolean equals(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null && right == null) {
            return true;
        }
        return left != null && right != null && left.equals(right);
    }

    public URI createURI() {
        switch (this.getReferenceType().getValue()) {
            case 0: {
                return this.createItemURI();
            }
            case 2: {
                return URI.create(this.getUri());
            }
        }
        throw new RuntimeException(NLS.bind(UNSUPPORTED_REFERENCE_TYPE, this.getReferenceType().getName()));
    }

    private URI createItemURI() {
        return Location.itemLocation(this.referencedItem, null).toRelativeUri();
    }

    public URI getURI() {
        return URI.create(this.getUri());
    }

    public ILink getLink() {
        DataObject container = this.getContainer();
        if (container != null && container instanceof ILink) {
            return (ILink)container;
        }
        return null;
    }

    public boolean isItemReference() {
        return this.referenceType == ReferenceType.ITEM_REFERENCE_LITERAL;
    }

    public boolean isURIReference() {
        return this.referenceType == ReferenceType.URI_REFERENCE_LITERAL;
    }
}

