/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.util;

import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.internal.ClientConfiguration;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$SelectorException;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$SelectorException$Type;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil$RepoView;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public abstract class SubcommandUtil {
    private static String ELLIPSIS = Messages.SubcommandUtil_25;

    public static File canonicalize(File file) throws FileSystemClientException {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw (Throwable)StatusHelper.failure(NLS.bind((String)Messages.SubcommandUtil_0, (Object)file), iOException);
        }
    }

    public static void addRepoLocationToOptions(Options options) throws ConflictingOptionException {
        options.addOption(CommonOptions.OPT_URI, CommonOptions.OPT_URI_HELP).addOption(CommonOptions.OPT_USERNAME, CommonOptions.OPT_USERNAME_HELP).addOption(CommonOptions.OPT_PASSWORD, CommonOptions.OPT_PASSWORD_HELP);
    }

    public static IPath getCurrentDir(String string) throws FileSystemClientException {
        File file;
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        if (!(file = new File(string)).exists()) {
            throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.SubcommandUtil_1, (Object)string));
        }
        return (IPath)new Path(file.getAbsolutePath());
    }

    public static File findAncestorCFARoot(String string) throws FileSystemClientException {
        return SubcommandUtil.findAncestorCFARoot(new File(string));
    }

    public static File findAncestorCFARoot(File file) throws FileSystemClientException {
        String string = ".jazz3";
        while (file != null) {
            File file2 = new File(file, string);
            if (file2.exists() && file2.isDirectory() && file2.canRead() && file2.canWrite()) break;
            file = file.getParentFile();
        }
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw (Throwable)StatusHelper.failure(NLS.bind((String)Messages.SubcommandUtil_2, (Object)file), iOException);
        }
    }

    public static File findNamedAncestorCFARoot(String string) throws FileSystemClientException {
        File file;
        try {
            file = new File(string).getCanonicalFile();
        }
        catch (IOException iOException) {
            throw (Throwable)StatusHelper.failure(NLS.bind((String)Messages.SubcommandUtil_3, (Object)string), iOException);
        }
        if (!file.exists()) {
            throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.SubcommandUtil_4, (Object)string));
        }
        File file2 = SubcommandUtil.findAncestorCFARoot(file.getAbsolutePath());
        if (file2 == null) {
            throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.SubcommandUtil_5, (Object)file.getAbsolutePath()));
        }
        if (!file.equals(file2)) {
            throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.SubcommandUtil_6, (Object)file.getAbsolutePath(), (Object)file2.getAbsolutePath()));
        }
        return file;
    }

    public static void initializeEclipseWorkspaceRoot(File file) throws FileSystemClientException {
        URL uRL;
        Location location = Platform.getInstanceLocation();
        if (location.isSet()) {
            throw (Throwable)StatusHelper.internalError(Messages.SubcommandUtil_7);
        }
        try {
            uRL = new URL("file", null, file.getAbsolutePath());
        }
        catch (MalformedURLException malformedURLException) {
            throw (Throwable)StatusHelper.internalError(Messages.SubcommandUtil_8);
        }
        boolean bl = location.setURL(uRL, true);
        if (!bl) {
            throw (Throwable)StatusHelper.cfaInUse(uRL);
        }
    }

    public static boolean isEclipseWorkspaceRootSet() {
        Location location = Platform.getInstanceLocation();
        return location.isSet();
    }

    public static IPath getCFARoot(IPath iPath, IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        File file = SubcommandUtil.findAncestorCFARoot(iPath.toOSString());
        if (file == null) {
            throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.SubcommandUtil_9, (Object)iPath));
        }
        SubcommandUtil.initializeEclipseWorkspaceRoot(file);
        return (IPath)new Path(file.getAbsolutePath());
    }

    public static Map getAffectedShareRoots(IPath iPath, IPath iPath2) throws FileSystemClientException {
        HashMap<IShare, List<IShareable>> hashMap = new HashMap<IShare, List<IShareable>>();
        ISharingManager iSharingManager = FileSystemCore.getSharingManager();
        if (iPath.equals((Object)iPath2)) {
            IShare[] iShareArray = iSharingManager.allShares(iPath);
            int n = 0;
            while (n < iShareArray.length) {
                LinkedList<IShareable> linkedList = (LinkedList<IShareable>)hashMap.get(iShareArray[n]);
                if (linkedList == null) {
                    linkedList = new LinkedList<IShareable>();
                }
                linkedList.add(iShareArray[n].getShareable(iShareArray[n].getPath(), true));
                hashMap.put(iShareArray[n], linkedList);
                ++n;
            }
        } else {
            IPath iPath3 = SubcommandUtil.makeRelativeToCFARoot(iPath, iPath2);
            IShareable iShareable = iSharingManager.findShareable(iPath, iPath3, true);
            IShare iShare = iShareable.getShare();
            if (iShare == null) {
                throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.SubcommandUtil_10, (Object)iPath2));
            }
            hashMap.put(iShare, Collections.singletonList(iShareable));
        }
        return hashMap;
    }

    public static ICopyFileAreaView getAffectedComponentsAndShares(IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        Path path = new Path(iClientConfiguration.getEclipseWorkspaceRoot().getAbsolutePath());
        Path path2 = new Path(iClientConfiguration.getCurrentWorkingDirectory().getAbsolutePath());
        return SubcommandUtil.getAffectedComponentsAndShares(iClientConfiguration, (IPath)path, (IPath)path2);
    }

    public static ICopyFileAreaView getAffectedComponentsAndShares(IClientConfiguration iClientConfiguration, IPath iPath, IPath iPath2) throws FileSystemClientException {
        boolean bl;
        IPath iPath3;
        IShare iShare;
        IShare[] iShareArray;
        ResourcesPlugin.getWorkspace();
        ISharingManager iSharingManager = FileSystemCore.getSharingManager();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        UUID uUID = null;
        if (iPath.equals((Object)iPath2)) {
            iPath2 = new Path("/");
        } else {
            iShareArray = iSharingManager.findShareable(iPath, iPath2 = SubcommandUtil.makeRelativeToCFARoot(iPath, iPath2), true);
            iShare = iShareArray.getShare();
            if (iShare == null) {
                throw (Throwable)StatusHelper.misconfiguredLocalFS(Messages.SubcommandUtil_11);
            }
            ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
            uUID = iSharingDescriptor.getComponent().getItemId();
        }
        IShare[] iShareArray2 = iShareArray = iSharingManager.allShares(iPath);
        int n = iShareArray.length;
        int n2 = 0;
        while (n2 < n) {
            iShare = iShareArray2[n2];
            ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
            IComponentHandle iComponentHandle = iSharingDescriptor.getComponent();
            if (uUID == null || uUID.equals((Object)iComponentHandle.getItemId())) {
                ItemId itemId = new ItemId((IItemHandle)iComponentHandle);
                SubcommandUtil$RepoView subcommandUtil$RepoView = new SubcommandUtil$RepoView((IWorkspaceHandle)iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getRepositoryUri());
                SubcommandUtil.addToMapOfLists(hashMap, itemId, iShare);
                SubcommandUtil.addToMapOfSets(hashMap2, subcommandUtil$RepoView, itemId);
            }
            ++n2;
        }
        if (uUID != null) {
            iShareArray = null;
        }
        IPath iPath4 = iPath2;
        if (iShareArray == null) {
            iPath3 = iPath4;
            bl = true;
        } else {
            iPath3 = iPath4;
            bl = false;
        }
        return new CopyFileAreaView(iClientConfiguration, iPath, iPath3, bl, hashMap2, hashMap, iShareArray);
    }

    public static void addToMapOfLists(Map map, Object object, Object object2) {
        LinkedList<Object> linkedList = (LinkedList<Object>)map.get(object);
        if (linkedList == null) {
            linkedList = new LinkedList<Object>();
            map.put(object, linkedList);
        }
        linkedList.add(object2);
    }

    public static void addToMapOfSets(Map map, Object object, Object object2) {
        HashSet<Object> hashSet = (HashSet<Object>)map.get(object);
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            map.put(object, hashSet);
        }
        hashSet.add(object2);
    }

    public static IPath makeRelativeToCFARoot(IPath iPath, IPath iPath2) {
        if (!iPath.isPrefixOf(iPath2)) {
            throw (Throwable)new IllegalArgumentException(Messages.SubcommandUtil_12);
        }
        return iPath2.removeFirstSegments(iPath.segmentCount());
    }

    public static void displaySelectorException(RepoUtil$SelectorException repoUtil$SelectorException) {
        IndentingPrintStream indentingPrintStream = new IndentingPrintStream(System.err);
        if (repoUtil$SelectorException.isSelectorAmbiguous()) {
            if (!$assertionsDisabled && repoUtil$SelectorException.hasMultipleSelectors()) {
                throw (Throwable)((Object)new AssertionError());
            }
            indentingPrintStream.println(NLS.bind((String)Messages.SubcommandUtil_13, (Object)repoUtil$SelectorException.getSelector()));
        } else if (repoUtil$SelectorException.isSelectorUnmatched()) {
            if (repoUtil$SelectorException.hasMultipleSelectors()) {
                indentingPrintStream.println(NLS.bind((String)Messages.SubcommandUtil_14, (Object)SubcommandUtil.getPluralizedList(repoUtil$SelectorException.getSelectors()), (Object)SubcommandUtil.getPluralizedNameOfItemType(repoUtil$SelectorException.getType())));
            } else {
                indentingPrintStream.println(NLS.bind((String)Messages.SubcommandUtil_15, (Object)repoUtil$SelectorException.getSelector(), (Object)SubcommandUtil.getPluralizedNameOfItemType(repoUtil$SelectorException.getType())));
            }
        }
        if (repoUtil$SelectorException.getPossibilities() != null && repoUtil$SelectorException.getPossibilities().size() > 0) {
            indentingPrintStream.println(Messages.SubcommandUtil_16);
            IndentingPrintStream indentingPrintStream2 = indentingPrintStream.indent();
            for (IItem iItem : repoUtil$SelectorException.getPossibilities()) {
                indentingPrintStream2.println(AliasUtil.selector(SubcommandUtil.getNameOf(iItem), iItem.getItemId()));
            }
        }
    }

    private static StringBuffer getPluralizedList(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (String string : collection) {
            if (bl) {
                stringBuffer.append(Messages.SubcommandUtil_19);
            }
            bl = true;
            stringBuffer.append(string);
        }
        return stringBuffer;
    }

    private static String getNameOf(IItem iItem) {
        IItemType iItemType = iItem.getItemType();
        if (IComponent.ITEM_TYPE.equals(iItemType)) {
            return ((IComponent)iItem).getName();
        }
        if (IWorkspace.ITEM_TYPE.equals(iItemType)) {
            return ((IWorkspace)iItem).getName();
        }
        if (IChangeSet.ITEM_TYPE.equals(iItemType)) {
            return ((IChangeSet)iItem).getComment();
        }
        throw (Throwable)new RuntimeException(NLS.bind((String)Messages.SubcommandUtil_20, (Object)iItemType));
    }

    private static String getPluralizedNameOfItemType(RepoUtil$SelectorException$Type repoUtil$SelectorException$Type) {
        switch (repoUtil$SelectorException$Type) {
            case COMPONENT: {
                return Messages.SubcommandUtil_21;
            }
            case CHANGESET: {
                return Messages.SubcommandUtil_22;
            }
            case WORKSPACE: {
                return Messages.SubcommandUtil_23;
            }
        }
        throw (Throwable)new RuntimeException(NLS.bind((String)Messages.SubcommandUtil_24, (Object)((Object)repoUtil$SelectorException$Type)));
    }

    public static String sanitizeText(String string, int n, boolean bl) {
        String string2 = string.replaceAll("\r\n", ".");
        if ((string2 = string2.replace('\n', '.')).length() > n) {
            if (bl) {
                return string2.subSequence(0, n - ELLIPSIS.length()) + ELLIPSIS;
            }
            return string2.subSequence(0, n).toString();
        }
        return string2;
    }

    public static IShareable makeShareable(IShare iShare) {
        return FileSystemCore.getSharingManager().findShareable(iShare.getAnchor(), iShare.getPath(), true);
    }

    public static IPath makePath(IClientConfiguration iClientConfiguration, String string) throws FileSystemClientException {
        File file = iClientConfiguration.getCurrentWorkingDirectory();
        Path path = new Path(string);
        Path path2 = new Path(iClientConfiguration.getEclipseWorkspaceRoot().getAbsolutePath());
        if (path.isAbsolute()) {
            if (!path2.isPrefixOf((IPath)path)) {
                return null;
            }
        } else {
            path = new Path(String.valueOf(file.getAbsolutePath()) + '/' + string);
        }
        return path.removeFirstSegments(path2.segmentCount()).setDevice(null);
    }

    public static List makeAbsolutePaths(IPath iPath, List list) throws FileSystemClientException {
        ArrayList<IPath> arrayList = new ArrayList<IPath>(list.size());
        File file = iPath.toFile();
        for (String string : list) {
            arrayList.add(SubcommandUtil.makeAbsolutePath(file, string));
        }
        return arrayList;
    }

    public static IPath makeAbsolutePath(File file, String string) throws FileSystemClientException {
        File file2 = new File(string);
        File file3 = null;
        file3 = file2.isAbsolute() ? file2 : new File(file, string);
        try {
            return (IPath)new Path(file3.getCanonicalPath());
        }
        catch (IOException iOException) {
            throw (Throwable)StatusHelper.failure(NLS.bind((String)Messages.SubcommandUtil_26, (Object)file3), iOException);
        }
    }

    public static File getScratchCFA(IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        File file = SubcommandUtil.canonicalize(new File(ClientConfiguration.getDefaultConfigDirectory()));
        if (!file.exists()) {
            file.mkdirs();
            if (!file.exists()) {
                throw (Throwable)StatusHelper.failure(NLS.bind((String)Messages.SubcommandUtil_27, (Object)file.getAbsolutePath()), null);
            }
        }
        return file;
    }

    public static void printDebugTiming(String string) {
        String string2 = FrameworkProperties.getProperty((String)"eclipse.startTime");
        long l = string2 == null ? 0L : Long.parseLong(string2);
        System.out.println(String.valueOf(string) + ": " + (System.currentTimeMillis() - l));
    }

    public static CharSequence getExecutionString(ISubcommandDefinition iSubcommandDefinition) {
        List list = iSubcommandDefinition.getAncestors();
        StringBuffer stringBuffer = new StringBuffer();
        for (ISubcommandDefinition iSubcommandDefinition2 : list) {
            stringBuffer.append(iSubcommandDefinition2.getFullSubcommandName());
            stringBuffer.append(Messages.HelpCmd_20);
        }
        stringBuffer.append(iSubcommandDefinition.getFullSubcommandName());
        return stringBuffer;
    }
}

