/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.util;

import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition$LoadSubcommandException;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.ProducesOrphansInConfigurationException;
import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class StatusHelper {
    public static FileSystemClientException argSyntax(String string) {
        return StatusHelper.createException(string, 1, null);
    }

    public static FileSystemClientException login(ConnectionInfo connectionInfo, TeamRepositoryException teamRepositoryException) {
        String string = connectionInfo == null ? Messages.StatusHelper_0 : NLS.bind((String)Messages.StatusHelper_1, (Object[])new Object[]{connectionInfo.getURI(), connectionInfo.getUsername(), teamRepositoryException.getLocalizedMessage()});
        return StatusHelper.login(string, teamRepositoryException);
    }

    public static FileSystemClientException login(String string, TeamRepositoryException teamRepositoryException) {
        return StatusHelper.createException(string, 2, teamRepositoryException);
    }

    public static FileSystemClientException login() {
        return StatusHelper.login(null, null);
    }

    public static FileSystemClientException failure(String string, Throwable throwable) {
        return StatusHelper.createException(string, 3, throwable);
    }

    public static FileSystemClientException loadError(String string, ISubcommandDefinition$LoadSubcommandException iSubcommandDefinition$LoadSubcommandException) {
        return StatusHelper.createException(string, 4, iSubcommandDefinition$LoadSubcommandException);
    }

    public static FileSystemClientException misconfiguredLocalFS(String string) {
        return StatusHelper.createException(string, 5, null);
    }

    public static FileSystemClientException collision(String string) {
        return StatusHelper.createException(string, 6, null);
    }

    public static FileSystemClientException internalError(String string) {
        return StatusHelper.createException(string, 7, null);
    }

    public static FileSystemClientException internalError(String string, Exception exception) {
        return StatusHelper.createException(string, 7, exception);
    }

    public static FileSystemClientException outOfSync(String string) {
        return StatusHelper.createException(string, 8, null);
    }

    public static FileSystemClientException ambiguousSelector(String string) {
        return StatusHelper.createException(string, 9, null);
    }

    public static FileSystemClientException conflict(String string) {
        return StatusHelper.createException(string, 11, null);
    }

    public static FileSystemClientException configurationFailure(String string) {
        return StatusHelper.createException(string, 4, null);
    }

    public static FileSystemClientException moveFailure(String string) {
        return StatusHelper.createException(string, 14, null);
    }

    public static FileSystemClientException staleData(String string) {
        return StatusHelper.createException(string, 15, null);
    }

    public static FileSystemClientException gap(String string) {
        return StatusHelper.createException(string, 16, null);
    }

    public static FileSystemClientException nWayConflict(String string) {
        return StatusHelper.createException(string, 21, null);
    }

    public static FileSystemClientException orphan(String string, ProducesOrphansInConfigurationException producesOrphansInConfigurationException) {
        return StatusHelper.createException(string, 22, (Throwable)producesOrphansInConfigurationException);
    }

    public static FileSystemClientException processFailure(String string, TeamOperationCanceledException teamOperationCanceledException) {
        StatusHelper.handleProcessError(teamOperationCanceledException.getReport());
        return StatusHelper.createException(string, 17, null);
    }

    public static FileSystemClientException itemNotFound(String string) {
        return StatusHelper.createException(string, 25, null);
    }

    public static FileSystemClientException initialConnectionTimeout(long l) {
        return StatusHelper.createException(NLS.bind((String)Messages.StatusHelper_INITIAL_CONNECTION_TIMEOUT, (Object)l), 31, null);
    }

    private static void handleProcessError(IOperationReport iOperationReport) {
        StatusHelper.writeOperationReport(false, iOperationReport, new IndentingPrintStream(System.out));
    }

    private static void writeOperationReport(boolean bl, IOperationReport iOperationReport, IndentingPrintStream indentingPrintStream) {
        Object object;
        IReportInfo iReportInfo;
        int n;
        int n2;
        IReportInfo[] iReportInfoArray;
        IndentingPrintStream indentingPrintStream2;
        boolean bl2 = false;
        indentingPrintStream = indentingPrintStream.indent();
        if (bl) {
            indentingPrintStream.println(NLS.bind((String)Messages.StatusHelper_2, (Object)iOperationReport.getName(), (Object)iOperationReport.getOperationId()));
        } else {
            indentingPrintStream.println(NLS.bind((String)Messages.StatusHelper_3, (Object)iOperationReport.getName()));
        }
        if (iOperationReport.getInfos().length == 0) {
            if (bl) {
                indentingPrintStream.println(Messages.StatusHelper_4);
            }
        } else {
            indentingPrintStream2 = indentingPrintStream.indent();
            iReportInfoArray = iOperationReport.getInfos();
            n2 = iReportInfoArray.length;
            n = 0;
            while (n < n2) {
                iReportInfo = iReportInfoArray[n];
                object = new StringBuffer();
                if (bl) {
                    ((StringBuffer)object).append('[');
                    ((StringBuffer)object).append(iReportInfo.getIdentifier());
                    ((StringBuffer)object).append("] - ");
                }
                ((StringBuffer)object).append(iReportInfo.getDescription());
                if (iReportInfo.getDescription().contains(Messages.StatusHelper_5)) {
                    bl2 = true;
                }
                indentingPrintStream2.println((CharSequence)object);
                ++n;
            }
        }
        if (iOperationReport.getParticipantReports().length == 0) {
            if (bl) {
                indentingPrintStream.println(Messages.StatusHelper_6);
            }
        } else {
            indentingPrintStream2 = indentingPrintStream.indent();
            iReportInfoArray = iOperationReport.getParticipantReports();
            n2 = iReportInfoArray.length;
            n = 0;
            while (n < n2) {
                iReportInfo = iReportInfoArray[n];
                if (bl) {
                    indentingPrintStream.println(NLS.bind((String)Messages.StatusHelper_7, (Object)iReportInfo.getParticipantIdentifier(), (Object)iReportInfo.getDescription()));
                    object = indentingPrintStream2.indent();
                    IReportInfo[] iReportInfoArray2 = iReportInfo.getInfos();
                    int n3 = iReportInfoArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IReportInfo iReportInfo2 = iReportInfoArray2[n4];
                        StringBuffer stringBuffer = new StringBuffer();
                        if (bl) {
                            stringBuffer.append('[');
                            stringBuffer.append(iReportInfo2.getIdentifier());
                            stringBuffer.append("] - ");
                        }
                        stringBuffer.append(iReportInfo2.getDescription());
                        ((IndentingPrintStream)object).println(stringBuffer);
                        ++n4;
                    }
                }
                ++n;
            }
        }
        if (iOperationReport.getOperationReports().length == 0) {
            if (bl) {
                indentingPrintStream.println(Messages.StatusHelper_8);
            }
        } else {
            indentingPrintStream.println(Messages.StatusHelper_9);
            IOperationReport[] iOperationReportArray = iOperationReport.getOperationReports();
            n = iOperationReportArray.length;
            int n5 = 0;
            while (n5 < n) {
                indentingPrintStream2 = iOperationReportArray[n5];
                StatusHelper.writeOperationReport(bl, (IOperationReport)indentingPrintStream2, indentingPrintStream);
                ++n5;
            }
        }
        if (bl2) {
            indentingPrintStream.println(Messages.StatusHelper_10);
        }
    }

    public static FileSystemClientException createException(String string, int n, Throwable throwable) {
        return new CLIFileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.cli.core", n, string, throwable));
    }

    public static FileSystemClientException internalError(String string, Collection collection) {
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.cli.core", 7, string, null);
        for (FileSystemClientException fileSystemClientException : collection) {
            multiStatus.add((IStatus)new Status(4, "com.ibm.team.filesystem.cli.core", 7, fileSystemClientException.getMessage(), (Throwable)fileSystemClientException));
        }
        return new CLIFileSystemClientException((IStatus)multiStatus);
    }

    public static FileSystemClientException permissionFailure(PermissionDeniedException permissionDeniedException) {
        return StatusHelper.createException(permissionDeniedException.getLocalizedMessage(), 18, null);
    }

    public static FileSystemClientException malformedInput(String string) {
        return StatusHelper.createException(string, 20, null);
    }

    public static FileSystemClientException disallowed(String string) {
        return StatusHelper.createException(string, 19, null);
    }

    public static FileSystemClientException cfaInUse(URL uRL) {
        return StatusHelper.createException(NLS.bind((String)Messages.StatusHelper_11, (Object)uRL.toExternalForm()), 27, null);
    }

    public static FileSystemClientException cfaInUse(String string) {
        return StatusHelper.createException(string, 27, null);
    }

    public static FileSystemClientException misconfiguredRemoteFS(String string) {
        return StatusHelper.createException(string, 28, null);
    }

    public static FileSystemClientException licenseDisallowed(LicenseNotGrantedException licenseNotGrantedException) {
        return StatusHelper.createException(NLS.bind((String)Messages.StatusHelper_12, (Object)licenseNotGrantedException.getMessage()), 29, (Throwable)licenseNotGrantedException);
    }

    public static FileSystemClientException inappropriateArgument(String string) {
        return StatusHelper.createException(string, 30, null);
    }

    public static FileSystemClientException wrap(TeamRepositoryException teamRepositoryException, String string) {
        if (teamRepositoryException instanceof PermissionDeniedException) {
            return StatusHelper.permissionFailure((PermissionDeniedException)teamRepositoryException);
        }
        if (teamRepositoryException instanceof LicenseNotGrantedException) {
            return StatusHelper.licenseDisallowed((LicenseNotGrantedException)teamRepositoryException);
        }
        return StatusHelper.failure(string, teamRepositoryException);
    }

    public static boolean isLoginError(FileSystemClientException fileSystemClientException) {
        return "com.ibm.team.filesystem.cli.core".equals(fileSystemClientException.getStatus().getPlugin()) && fileSystemClientException.getStatus().getCode() == 2;
    }
}

