/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.internal.aliases;

import com.ibm.team.filesystem.cli.core.CommandLineCore;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.aliases.AliasComparator;
import com.ibm.team.filesystem.cli.core.internal.aliases.AliasLoader;
import com.ibm.team.filesystem.cli.core.internal.aliases.UuidAlias;
import com.ibm.team.filesystem.cli.core.internal.aliases.UuidAliasRegistry$1;
import com.ibm.team.filesystem.cli.core.internal.aliases.UuidAliasRegistry$2;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry$IUuidAlias;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry$NoSuchAliasException;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.repository.common.UUID;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.osgi.util.NLS;

public class UuidAliasRegistry
implements IUuidAliasRegistry {
    public static char[] ALPHABET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static int WIDTH = 4;
    public static char UNUSABLE_CHAR = (char)45;
    private boolean reportedRollover = false;
    private int cacheSize = 3000;
    private final File file;
    private long lastAllocated = (long)Math.pow(ALPHABET.length, WIDTH - 1);
    private long lastRun;
    private long lowestLastRun = Long.MAX_VALUE;
    private boolean loaded = false;
    private boolean dirty = false;
    private HashMap uuidMap = new HashMap();
    private HashMap nameMap = new HashMap();
    private final SortedSet sorted = new TreeSet(new AliasComparator());

    static {
        if (!$assertionsDisabled && new String(ALPHABET).contains(new String(new char[]{UNUSABLE_CHAR}))) {
            throw (Throwable)((Object)new AssertionError());
        }
    }

    public UuidAliasRegistry(File file, int n) {
        this.file = file;
        this.cacheSize = n;
    }

    public void shutdown() {
        try {
            this.doShutdown();
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShutdown() throws IOException {
        Object object = this.sorted;
        synchronized (object) {
            if (!this.dirty) {
                return;
            }
        }
        object = this.sorted.iterator();
        int n = this.getCacheSize();
        UuidAliasRegistry$1 uuidAliasRegistry$1 = new UuidAliasRegistry$1(this, n, (Iterator)object);
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            AliasLoader.save(uuidAliasRegistry$1, this.lastAllocated, this.lastRun < 0L ? Long.MAX_VALUE - this.lowestLastRun : this.lastRun, this.file);
        }
    }

    public IUuidAliasRegistry$IUuidAlias findAliasByUuid(String string) throws IUuidAliasRegistry$NoSuchAliasException {
        return this.findAliasByUuid(UUID.valueOf((String)string));
    }

    SortedSet getSorted() {
        this.load();
        return this.sorted;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int n) {
        this.cacheSize = n;
    }

    public long getLastAllocated() {
        return this.lastAllocated;
    }

    public void setLastAllocated(long l) {
        this.lastAllocated = l;
    }

    public void setLastRun(long l) {
        this.lastRun = l + 1L;
    }

    static /* synthetic */ long access$0(UuidAliasRegistry uuidAliasRegistry) {
        return uuidAliasRegistry.lastRun;
    }

    static /* synthetic */ long access$1(UuidAliasRegistry uuidAliasRegistry) {
        return uuidAliasRegistry.lowestLastRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard(IUuidAliasRegistry$IUuidAlias iUuidAliasRegistry$IUuidAlias) {
        this.load();
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            IUuidAliasRegistry$IUuidAlias iUuidAliasRegistry$IUuidAlias2 = (IUuidAliasRegistry$IUuidAlias)this.uuidMap.remove(iUuidAliasRegistry$IUuidAlias.getUuid());
            IUuidAliasRegistry$IUuidAlias iUuidAliasRegistry$IUuidAlias3 = (IUuidAliasRegistry$IUuidAlias)this.nameMap.remove(iUuidAliasRegistry$IUuidAlias.getMonicker());
            boolean bl = this.sorted.remove(iUuidAliasRegistry$IUuidAlias);
            if (iUuidAliasRegistry$IUuidAlias2 != null || iUuidAliasRegistry$IUuidAlias3 != null || bl) {
                this.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            try {
                AliasLoader.load(this, this.file);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUuidAliasRegistry$IUuidAlias createAliasFor(UUID uUID, String string, long l) {
        if (this.lastRun < 0L) {
            if (l < 0L) {
                l = Long.MAX_VALUE;
            } else {
                this.lowestLastRun = Math.min(this.lowestLastRun, l);
            }
        }
        UuidAlias uuidAlias = new UuidAlias(string, uUID, l);
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            if (!$assertionsDisabled && this.uuidMap.containsKey(uUID)) {
                throw (Throwable)((Object)new AssertionError());
            }
            if (!$assertionsDisabled && this.nameMap.containsKey(string)) {
                throw (Throwable)((Object)new AssertionError());
            }
            this.uuidMap.put(uUID, uuidAlias);
            this.nameMap.put(string, uuidAlias);
            this.sorted.add(uuidAlias);
            if (!$assertionsDisabled && this.uuidMap.size() != this.sorted.size()) {
                throw (Throwable)((Object)new AssertionError());
            }
            if (!$assertionsDisabled && this.nameMap.size() != this.sorted.size()) {
                throw (Throwable)((Object)new AssertionError());
            }
            this.dirty = true;
        }
        return uuidAlias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUuidAliasRegistry$IUuidAlias createAliasFor(UUID uUID) {
        this.load();
        if (this.uuidMap.containsKey(uUID)) {
            throw (Throwable)new IllegalArgumentException("Monicker for " + uUID.getUuidValue() + " already exists: " + ((UuidAlias)this.uuidMap.get(uUID)).getMonicker());
        }
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            String string;
            block6: {
                this.dirty = true;
                long l = this.lastAllocated++ % (long)Math.pow(ALPHABET.length, WIDTH);
                int n = WIDTH - 1;
                char[] cArray = new char[WIDTH];
                int n2 = n;
                while (n2 >= 0) {
                    long l2 = (long)Math.pow(ALPHABET.length, n2);
                    cArray[n - n2] = ALPHABET[(int)(l / l2)];
                    l %= l2;
                    --n2;
                }
                string = new String(cArray);
                if (!this.nameMap.containsKey(string)) break block6;
                this.reportRollover();
                UuidAlias uuidAlias = (UuidAlias)this.createAliasFor(uUID, StringUtil.pad(new StringBuffer(), WIDTH, UNUSABLE_CHAR).toString(), this.lastRun);
                uuidAlias.persist = false;
                return uuidAlias;
            }
            return this.createAliasFor(uUID, string, this.lastRun);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportRollover() {
        Object object = this.sorted;
        synchronized (object) {
            if (this.reportedRollover) {
                return;
            }
            this.reportedRollover = true;
        }
        object = Messages.UuidAliasRegistry_0;
        try {
            object = this.file.getCanonicalPath();
        }
        catch (IOException iOException) {}
        String string = NLS.bind((String)Messages.UuidAliasRegistry_1, (Object)object);
        IClientConfiguration iClientConfiguration = CommandLineCore.getConfig();
        if (iClientConfiguration == null) {
            System.err.println(string);
        } else {
            iClientConfiguration.addApplicationEndListener(new UuidAliasRegistry$2(this, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUuidAliasRegistry$IUuidAlias findAliasByName(String string) throws IUuidAliasRegistry$NoSuchAliasException {
        this.load();
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            UuidAlias uuidAlias = (UuidAlias)this.nameMap.get(string);
            if (uuidAlias == null) {
                throw (Throwable)new IUuidAliasRegistry$NoSuchAliasException();
            }
            this.increment(uuidAlias);
            return uuidAlias;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increment(UuidAlias uuidAlias) {
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            this.sorted.remove(uuidAlias);
            uuidAlias.lastRun = this.lastRun < 0L ? 0L : this.lastRun;
            this.sorted.add(uuidAlias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUuidAliasRegistry$IUuidAlias findAliasByUuid(UUID uUID) throws IUuidAliasRegistry$NoSuchAliasException {
        this.load();
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            UuidAlias uuidAlias = (UuidAlias)this.uuidMap.get(uUID);
            if (uuidAlias == null) {
                throw (Throwable)new IUuidAliasRegistry$NoSuchAliasException();
            }
            this.increment(uuidAlias);
            return uuidAlias;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAliasCount() {
        this.load();
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            return this.sorted.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAlias(String string) {
        this.load();
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            return this.nameMap.containsKey(string);
        }
    }
}

