/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.internal;

import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.RepositoryRegistry$$Cold;
import com.ibm.team.filesystem.cli.core.internal.RepositoryRegistry$RepositoryRecord;
import com.ibm.team.filesystem.cli.core.subcommands.IRepositoryRecord;
import com.ibm.team.filesystem.cli.core.subcommands.IRepositoryRegistry;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemClientException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class RepositoryRegistry
implements IRepositoryRegistry {
    private static final String FILE_FORMAT_MAGIC = "###";
    private static final String FILE_FORMAT_TYPE = "reporeg";
    private static final int FILE_FORMAT_VERSION = 0;
    private static final String FILE_PREAMBLE = "### reporeg 0";
    private List records = null;
    private final File recordFile;

    public RepositoryRegistry(File file) {
        this.recordFile = file;
    }

    private String getVersionString() {
        return FILE_PREAMBLE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void load() throws FileSystemClientException {
        if (this.recordFile == null) {
            this.records = Collections.emptyList();
            return;
        }
        if (this.records == null) {
            FileInputStream fileInputStream;
            BufferedReader bufferedReader = null;
            try {
                fileInputStream = new FileInputStream(this.recordFile);
                bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.records = new LinkedList();
                return;
            }
            this.records = new LinkedList();
            boolean bl = false;
            try {
                try {
                    String string = bufferedReader.readLine();
                    if (string != null) {
                        try {
                            this.consumePreamble(string);
                        }
                        catch (FileSystemClientException fileSystemClientException) {
                            bl = true;
                            throw (Throwable)fileSystemClientException;
                        }
                    }
                    while ((string = bufferedReader.readLine()) != null) {
                        if ((string = string.trim()).startsWith("#")) continue;
                        RepositoryRegistry$RepositoryRecord repositoryRegistry$RepositoryRecord = RepositoryRegistry$RepositoryRecord.read(string);
                        this.records.add(repositoryRegistry$RepositoryRecord);
                    }
                }
                catch (IOException iOException) {
                    bl = true;
                    throw (Throwable)new FileSystemClientException((IStatus)new Status(2, "com.ibm.team.filesystem.cli.core", NLS.bind((String)Messages.RepositoryRegistry_3, (Object)"repositories")));
                }
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
                if (bl) {
                    this.recordFile.delete();
                    this.records = new LinkedList();
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
            if (bl) {
                this.recordFile.delete();
                this.records = new LinkedList();
            }
        }
    }

    private void consumePreamble(String string) throws FileSystemClientException {
        if (!string.startsWith(FILE_FORMAT_MAGIC)) {
            throw (Throwable)new FileSystemClientException((IStatus)new Status(2, "com.ibm.team.filesystem.cli.core", NLS.bind((String)Messages.RepositoryRegistry_4, (Object)FILE_FORMAT_MAGIC, (Object)FILE_FORMAT_TYPE)));
        }
        if (!string.startsWith(this.getVersionString())) {
            throw (Throwable)new FileSystemClientException((IStatus)new Status(2, "com.ibm.team.filesystem.cli.core", NLS.bind((String)Messages.RepositoryRegistry_5, (Object)0)));
        }
    }

    protected void save() throws FileSystemClientException {
        if (this.records == null && this.recordFile != null) {
            throw (Throwable)new IllegalStateException();
        }
        if (this.recordFile == null) {
            return;
        }
        Object object = this.recordFile.getParentFile();
        if (!((File)object).exists() && !((File)object).mkdirs()) {
            throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.RepositoryRegistry_6, (Object)this.recordFile.getAbsolutePath()));
        }
        if (this.recordFile.exists() && this.recordFile.isDirectory()) {
            this.recordFile.delete();
        }
        object = null;
        BufferedWriter bufferedWriter = null;
        try {
            try {
                object = new FileOutputStream(this.recordFile);
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object));
                bufferedWriter.write(this.getVersionString());
                bufferedWriter.newLine();
                for (IRepositoryRecord iRepositoryRecord : this.records) {
                    ((RepositoryRegistry$RepositoryRecord)iRepositoryRecord).write(bufferedWriter);
                    bufferedWriter.newLine();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.RepositoryRegistry_7, (Object)this.recordFile.getAbsolutePath()));
            }
            catch (IOException iOException) {
                throw (Throwable)StatusHelper.failure(NLS.bind((String)Messages.RepositoryRegistry_8, (Object)this.recordFile.getAbsolutePath()), iOException);
            }
        }
        catch (Throwable throwable) {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
            if (object != null) {
                try {
                    ((OutputStream)object).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (bufferedWriter != null) {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
        }
        if (object != null) {
            try {
                ((OutputStream)object).close();
            }
            catch (IOException iOException) {}
        }
    }

    public IRepositoryRecord getRecordByURL(String string) throws FileSystemClientException {
        this.load();
        if (string == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (!string.endsWith("/")) {
            string = String.valueOf(string) + "/";
        }
        for (IRepositoryRecord iRepositoryRecord : this.records) {
            String string2 = iRepositoryRecord.getUrl();
            if (!string2.endsWith("/")) {
                string2 = String.valueOf(string2) + "/";
            }
            if (!string.equals(string2)) continue;
            return iRepositoryRecord;
        }
        return null;
    }

    public IRepositoryRecord getRecordByNickname(String string) throws FileSystemClientException {
        this.load();
        if (string == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        for (IRepositoryRecord iRepositoryRecord : this.records) {
            if (!string.equals(iRepositoryRecord.getNickname())) continue;
            return iRepositoryRecord;
        }
        return null;
    }

    public IRepositoryRecord getRecord(String string) throws FileSystemClientException {
        return RepositoryRegistry$$Cold.getRecord(this, string);
    }

    public IRepositoryRecord addRecord(String string, String string2, String string3, String string4) throws FileSystemClientException {
        this.load();
        RepositoryRegistry$RepositoryRecord repositoryRegistry$RepositoryRecord = null;
        if (string2 != null && (repositoryRegistry$RepositoryRecord = (RepositoryRegistry$RepositoryRecord)this.getRecordByNickname(string2)) != null) {
            this.records.remove(repositoryRegistry$RepositoryRecord);
        }
        if ((repositoryRegistry$RepositoryRecord = (RepositoryRegistry$RepositoryRecord)this.getRecordByURL(string)) != null) {
            this.records.remove(repositoryRegistry$RepositoryRecord);
        }
        repositoryRegistry$RepositoryRecord = new RepositoryRegistry$RepositoryRecord(string, string2, string3, string4);
        this.records.add(repositoryRegistry$RepositoryRecord);
        try {
            this.save();
        }
        catch (FileSystemClientException fileSystemClientException) {
            this.records = null;
            throw (Throwable)fileSystemClientException;
        }
        return repositoryRegistry$RepositoryRecord;
    }

    public void removeRecord(IRepositoryRecord iRepositoryRecord) throws FileSystemClientException {
        this.records.remove(iRepositoryRecord);
        try {
            this.save();
        }
        catch (FileSystemClientException fileSystemClientException) {
            this.records = null;
            throw (Throwable)fileSystemClientException;
        }
    }

    public Iterator iterator() {
        try {
            this.load();
        }
        catch (FileSystemClientException fileSystemClientException) {
            return new LinkedList().iterator();
        }
        return this.records.iterator();
    }
}

