/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.dashboard;

import com.ibm.team.feed.core.ClientFeedUtils;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.ColorDefinitions;
import com.ibm.team.feed.ui.internal.FeedUIPlugin;
import com.ibm.team.feed.ui.internal.ImagePool;
import com.ibm.team.feed.ui.internal.dashboard.Messages;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.HistoryBin;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.itemview.MarkupUtil;
import java.util.Date;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class NewsLabelProvider
extends LabelProvider
implements ITableFontProvider,
ITableColorProvider {
    private ResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());
    private Image fDefaultNewsIcon = JazzResources.getImageWithDefault((ResourceManager)this.fResources, (ImageDescriptor)ImagePool.NEWS);

    public void dispose() {
        this.fResources.dispose();
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Font getFont(Object element, int columnIndex) {
        NewsItem item;
        boolean unread;
        if (element == null) {
            return null;
        }
        GenericAggregationBin bin = null;
        if (element instanceof GenericAggregationBin) {
            bin = (GenericAggregationBin)element;
            element = ((GenericAggregationBin)element).getMostRecent();
        }
        boolean bl = unread = !(item = (NewsItem)element).isIsRead() || bin != null && bin.containsUnread();
        if (unread) {
            return (Font)this.fResources.get((DeviceResourceDescriptor)JFaceResources.getFontDescriptor((String)"").withStyle(1));
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        NewsItem item;
        Color label;
        if (element instanceof GenericAggregationBin) {
            element = ((GenericAggregationBin)element).getMostRecent();
        }
        if (element instanceof NewsItem && (label = this.getLabel(item = (NewsItem)element)) != null) {
            return label;
        }
        return null;
    }

    private Color getLabel(NewsItem item) {
        String str;
        String[] parts;
        Object object = item.getCustomFields().get("com.ibm.team.feed.core.LabelNewsNotifier");
        if (object != null && (parts = (str = (String)object).split(",")).length == 3) {
            return JazzResources.getColor((ResourceManager)this.fResources, (RGB)new RGB(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2])));
        }
        if (ClientFeedUtils.getInstance().isOwner(item)) {
            return JazzResources.getColor((ResourceManager)this.fResources, (RGB)ColorDefinitions.fgMyColor);
        }
        Channel channel = item.getChannel();
        if (channel != null) {
            return this.fResources.createColor(ColorDefinitions.convertToRGB(channel.getColor()));
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof GenericAggregationBin) {
            element = ((GenericAggregationBin)element).getMostRecent();
        }
        if (element instanceof NewsItem) {
            NewsItem item = (NewsItem)element;
            return JazzResources.getImage((ResourceManager)this.fResources, (ImageDescriptor)FeedUIPlugin.getCategoryImageDescriptor(item.getCategory()), (Image)this.fDefaultNewsIcon);
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof GenericAggregationBin) {
            Object mostRecentElement = ((GenericAggregationBin)element).getMostRecent();
            int aggCount = ((GenericAggregationBin)element).getSize();
            if (aggCount > 1) {
                return "<light>[" + aggCount + "]</light> " + this.getText(mostRecentElement);
            }
            return this.getText(mostRecentElement);
        }
        if (element instanceof NewsItem) {
            NewsItem item = (NewsItem)element;
            Date itemDate = item.getPublishDate();
            StringBuffer itemText = new StringBuffer();
            String title = ((NewsItem)element).getTitle();
            title = title == null ? Messages.getString("NewsLabelProvider.NO_TITLE") : MarkupUtil.normalizeString((String)title);
            itemText.append(title);
            if (itemDate != null) {
                itemText.append("  <light>").append(HistoryBin.formatDif((Date)itemDate, (boolean)false, (boolean)true)).append("</light>");
            }
            return itemText.toString();
        }
        return super.getText(element);
    }
}

