/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal;

import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.Messages;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.DomainAdapter;
import com.ibm.team.jface.preview.IDomainAdapter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;

public class SubscriptionsDomainAdapter
extends DomainAdapter {
    private static final String GENERAL_CSS = "GENERAL_SUBSCRIPTION_CSS";

    protected Object convertToDomainObject(Object object) {
        if (object instanceof Channel) {
            return object;
        }
        return null;
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        if (!(input instanceof Channel)) {
            super.generateContentAsHTML(head, body, input, info);
            return;
        }
        Channel channel = (Channel)input;
        if (channel.getLastError() != null) {
            body.append(channel.getLastError());
        } else {
            String description = channel.getDescription();
            body.append("<b>");
            body.append(channel.getTitle());
            body.append("</b> <p>");
            if (description != null && description.length() > 0) {
                body.append(description);
            }
            NewsItem[] items = channel.getItems();
            Arrays.sort(items, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    Date d1 = ((NewsItem)arg0).getPublishDate();
                    Date d2 = ((NewsItem)arg1).getPublishDate();
                    if (d2 != null) {
                        return d2.compareTo(d1);
                    }
                    return -1;
                }
            });
            if (items.length > 0) {
                StringBuilder str = new StringBuilder();
                str.append("<ul>");
                int i = 0;
                while (i < items.length) {
                    NewsItem item = items[i];
                    str.append("<li>");
                    if (!item.isIsRead()) {
                        str.append("<b>");
                    }
                    if (item.getLink() != null) {
                        str.append("<a href=\"" + item.getLink() + "\">").append(item.getTitle()).append("</a></li>");
                    } else {
                        str.append(item.getTitle()).append("</li>");
                    }
                    if (!item.isIsRead()) {
                        str.append("</b>");
                    }
                    ++i;
                }
                str.append("<ul>");
                body.append((CharSequence)str);
            } else {
                String noNewsItemsReceived = Messages.SubscriptionsDomainAdapter_NO_ITEMS_RECEIVED;
                body.append("<div style='color:gray; '><i>" + noNewsItemsReceived + "</i></div>");
            }
        }
        if (head.containsKey(GENERAL_CSS)) {
            return;
        }
        StringBuffer css = new StringBuffer();
        css.append("<style type=\"text/css\">");
        css.append("body { overflow: auto; margin: 0; }\n");
        css.append(".{ ").append(MarkupUtil.getGlobalFont()).append(" }");
        css.append("li { margin-bottom: 5px; }");
        css.append("a:link { text-decoration: none; }");
        css.append("a:visited { color:#0000FF; text-decoration: none; }");
        css.append("a:hover { text-decoration: underline; }");
        css.append("</style>");
        head.put(GENERAL_CSS, css.toString());
    }

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        return Messages.SubscriptionsDomainAdapter_CREATING_CONTENT;
    }

    public String generateTitle(Object input) {
        if (input instanceof Channel) {
            return ((Channel)input).getTitle();
        }
        return super.generateTitle(input);
    }

    public void markAsRead(Object input, int afterMilis) {
    }
}

