/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal;

import com.ibm.icu.text.Collator;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.ui.internal.EditFeedAction;
import com.ibm.team.feed.ui.internal.ImagePool;
import com.ibm.team.feed.ui.internal.Messages;
import com.ibm.team.feed.ui.internal.OpenFeedsAggregatedAction;
import com.ibm.team.jface.viewerutilities.SelectionProvider;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.internal.ObjectActionContributorManager;

public class ShowFeedsDropDownAction
implements IWorkbenchWindowPulldownDelegate {
    private LocalResourceManager fResources;
    private IWorkbenchWindow fWindow;
    private final Collator fCollator = Collator.getInstance();

    public Menu getMenu(Control parent) {
        MenuManager manager = new MenuManager();
        Channel[] feeds = FeedManager.getDefault().getChannels();
        final ArrayList<Channel> eventFeeds = new ArrayList<Channel>(feeds != null ? feeds.length / 2 : 0);
        ArrayList<Channel> newsFeeds = new ArrayList<Channel>(feeds != null ? feeds.length / 2 : 0);
        Channel[] channelArray = feeds;
        int n = feeds.length;
        int n2 = 0;
        while (n2 < n) {
            Channel feed = channelArray[n2];
            if ("com.ibm.team.feed.core.SystemFeed".equals(feed.getCategory())) {
                eventFeeds.add(feed);
            } else {
                newsFeeds.add(feed);
            }
            ++n2;
        }
        Comparator<Channel> c = new Comparator<Channel>(){

            @Override
            public int compare(Channel o1, Channel o2) {
                return ShowFeedsDropDownAction.this.fCollator.compare(o1.getTitle().toLowerCase(), o2.getTitle().toLowerCase());
            }
        };
        Collections.sort(eventFeeds, c);
        Collections.sort(newsFeeds, c);
        if (!eventFeeds.isEmpty()) {
            Action action = new Action(""){

                public void run() {
                    ShowFeedsDropDownAction.this.onOpen(eventFeeds.toArray(new Channel[eventFeeds.size()]));
                }
            };
            action.setImageDescriptor(ImagePool.EVENTS);
            action.setText(Messages.ShowFeedsDropDownAction_SHOW_ALL_EVENTS);
            manager.add((IAction)action);
            manager.add((IContributionItem)new Separator());
        }
        List[] channels = new List[]{eventFeeds, newsFeeds};
        ImageDescriptor[] icons = new ImageDescriptor[]{ImagePool.EVENTS, ImagePool.NEWS};
        int i = 0;
        while (i < channels.length) {
            List list = channels[i];
            for (final Channel channel : list) {
                Action action = new Action(""){

                    public void runWithEvent(Event event) {
                        if ((event.stateMask & 0x40000) != 0) {
                            ShowFeedsDropDownAction.this.onEdit(channel);
                        } else {
                            ShowFeedsDropDownAction.this.onOpen(channel);
                        }
                    }
                };
                action.setImageDescriptor(icons[i]);
                int unreadCount = channel.getUnreadCount();
                if (unreadCount > 0) {
                    action.setText(NLS.bind((String)Messages.ShowFeedsDropDownAction_INDICATE_UNREADCOUNT_FOR_FEED, (Object[])new Object[]{channel.getTitle(), unreadCount}));
                } else {
                    action.setText(channel.getTitle());
                }
                manager.add((IAction)action);
            }
            if (!eventFeeds.isEmpty() && !newsFeeds.isEmpty()) {
                manager.add((IContributionItem)new Separator());
            }
            ++i;
        }
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                return new StructuredSelection((Object)FeedManager.getDefault());
            }
        };
        manager.add((IContributionItem)new Separator("jazz.new"));
        manager.add((IContributionItem)new GroupMarker("jazz.new.group"));
        IWorkbenchPage activePage = this.fWindow.getActivePage();
        if (activePage != null) {
            ObjectActionContributorManager.getManager().contributeObjectActions(activePage.getActivePart(), (IMenuManager)manager, (ISelectionProvider)selectionProvider);
        }
        return manager.createContextMenu(parent);
    }

    private void onEdit(Channel channel) {
        new EditFeedAction((IStructuredSelection)new StructuredSelection((Object)channel), this.fWindow.getShell()).run(null);
    }

    private void onOpen(Channel feed) {
        this.onOpen(new Channel[]{feed});
    }

    private void onOpen(Channel[] feeds) {
        String name = "";
        int i = 0;
        while (i < feeds.length) {
            name = i == 0 ? feeds[i].getTitle() : NLS.bind((String)Messages.ShowFeedsDropDownAction_FEED_ENUMERATION, (Object[])new Object[]{name, feeds[i].getTitle()});
            ++i;
        }
        IWorkbenchPage activePage = this.fWindow.getActivePage();
        if (activePage != null) {
            OpenFeedsAggregatedAction action = new OpenFeedsAggregatedAction(null, feeds, activePage, name, true);
            action.run(null);
        }
    }

    public void dispose() {
        this.fResources.dispose();
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
    }

    public void run(IAction action) {
        Channel[] channels;
        ArrayList<Channel> eventFeeds = new ArrayList<Channel>();
        Channel[] channelArray = channels = FeedManager.getDefault().getChannels();
        int n = channels.length;
        int n2 = 0;
        while (n2 < n) {
            Channel feed = channelArray[n2];
            if ("com.ibm.team.feed.core.SystemFeed".equals(feed.getCategory())) {
                eventFeeds.add(feed);
            }
            ++n2;
        }
        if (!eventFeeds.isEmpty()) {
            this.onOpen(eventFeeds.toArray(new Channel[eventFeeds.size()]));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

