/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal;

import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.ui.internal.EditFeedComposite;
import com.ibm.team.feed.ui.internal.Messages;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class EditFeedDialog
extends StatusDialog {
    private EditFeedComposite fEditFeedComposite;
    private EditFeedComposite.IValidationListener fValidationListener = new EditFeedComposite.IValidationListener(){

        public void validationChanged(boolean isValid, String message) {
            if (isValid) {
                EditFeedDialog.this.updateStatus(Status.OK_STATUS);
            } else {
                EditFeedDialog.this.updateStatus((IStatus)new Status(4, "com.ibm.team.feed.ui", 0, message, null));
            }
        }
    };
    private boolean fIsNewSubscription;

    public EditFeedDialog(Shell parentShell) {
        super(parentShell);
        this.fEditFeedComposite = new EditFeedComposite(this.fValidationListener);
    }

    public void init(Channel channel) {
        this.fIsNewSubscription = channel == null;
        this.fEditFeedComposite.init(channel);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && !this.fEditFeedComposite.save()) {
            return;
        }
        super.buttonPressed(buttonId);
    }

    public Channel getChannel() {
        return this.fEditFeedComposite.getChannel();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.fIsNewSubscription) {
            newShell.setText(Messages.EditFeedDialog_ADD_FEED_SUBSCRIPTION);
        } else {
            String title = this.fEditFeedComposite.getTitle();
            if (title != null) {
                if (title.length() == 0) {
                    title = Messages.EditFeedDialog_NO_TITLE;
                }
                newShell.setText(NLS.bind((String)Messages.EditFeedDialog_EDIT_FEED, (Object[])new Object[]{title}));
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.fEditFeedComposite.createContents(area);
        return area;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }
}

