/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.links;

import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.internal.links.LinksPackage;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IHelperType;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.Messages;
import com.ibm.team.scm.common.internal.util.ValidationUtils;
import com.ibm.team.scm.common.providers.ItemProvider;
import java.net.URI;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChangeSetLocationFactory {
    private static final DateFormat format = DateFormat.getDateTimeInstance(2, 3);

    public static IReference createChangeSetURI(ItemProvider provider, IChangeSetHandle changeSetHandle, IWorkspaceHandle optionalWorkspace, IProgressMonitor monitor) throws TeamRepositoryException {
        return ChangeSetLocationFactory.createChangeSetURI(provider, changeSetHandle, optionalWorkspace, false, false, monitor);
    }

    public static IReference createChangeSetURI(ItemProvider provider, IChangeSetHandle changeSetHandle, IWorkspaceHandle optionalWorkspace, boolean absolute, boolean deliverSet, IProgressMonitor monitor) throws TeamRepositoryException {
        IChangeSet changeSet = (IChangeSet)provider.fetchItem((IManagedItemHandle)changeSetHandle, monitor);
        String query = "";
        if (optionalWorkspace != null) {
            query = ChangeSetLocationFactory.getChangeSetURIContext(optionalWorkspace);
        }
        if (deliverSet) {
            query = String.valueOf(query) + "&com.ibm.team.scm.eventCategory.delivery=true";
        }
        Location location = Location.itemLocation((IItemHandle)changeSetHandle, (String)provider.getRepositoryURI(), (String)query, null);
        String comment = ChangeSetLocationFactory.getInterimComment(provider, changeSet, monitor);
        URI uri = location.toRelativeUri();
        if (absolute) {
            uri = location.toAbsoluteUri();
        }
        return IReferenceFactory.INSTANCE.createReferenceFromURI(uri, comment);
    }

    public static IReference createChangeSetItemReference(ItemProvider provider, IChangeSetHandle changeSetHandle, IWorkspaceHandle optionalWorkspace, IProgressMonitor monitor) throws TeamRepositoryException {
        IChangeSet changeSet = (IChangeSet)provider.fetchItem((IManagedItemHandle)changeSetHandle, monitor);
        String extraInfo = null;
        if (optionalWorkspace != null) {
            extraInfo = ChangeSetLocationFactory.getChangeSetURIContext(optionalWorkspace);
        }
        String comment = ChangeSetLocationFactory.getInterimComment(provider, changeSet, monitor);
        IHelperType ITEM_TYPE = IHelperType.IRegistry.INSTANCE.getHelperType(LinksPackage.eINSTANCE.getReference().getName(), "com.ibm.team.links");
        String COMMENT_PROPERTY = LinksPackage.eINSTANCE.getReference_Comment().getName();
        comment = ValidationUtils.truncate((IType)ITEM_TYPE, COMMENT_PROPERTY, comment);
        return IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)changeSet, comment, extraInfo);
    }

    public static String getChangeSetURIContext(IWorkspaceHandle optionalWorkspace) {
        return String.valueOf(IWorkspace.ITEM_TYPE.getName()) + "=" + optionalWorkspace.getItemId().getUuidValue();
    }

    public static IReference createAnonymousChangeSetURI(String repoURL, IChangeSetHandle changeSetHandle) {
        Location location = Location.itemLocation((IItemHandle)changeSetHandle, (String)repoURL, null, null);
        return IReferenceFactory.INSTANCE.createReferenceFromURI(location.toRelativeUri(), "");
    }

    private static String getInterimComment(ItemProvider provider, IChangeSet cs, IProgressMonitor monitor) throws TeamRepositoryException {
        IContributor contributor = (IContributor)provider.fetchItem((IManagedItemHandle)cs.getModifiedBy(), monitor);
        IComponent component = (IComponent)provider.fetchItem((IManagedItemHandle)cs.getComponent(), monitor);
        return ChangeSetLocationFactory.getDescription(cs, component, contributor);
    }

    public static String getDescription(IChangeSet cs, IComponent component, IContributor contributor) {
        String componentName = Messages.getString("ChangeSetLocationFactory.UNKNOWN_COMPONENT_LABEL");
        String whoName = Messages.getString("ChangeSetLocationFactory.UNKNOWN_COMPONENT_LABEL");
        if (contributor != null) {
            whoName = contributor.getName();
        }
        if (component != null) {
            componentName = component.getName();
        }
        Date when = cs.modified();
        StringBuilder builder = new StringBuilder();
        String comment = ChangeSetLocationFactory.getFullContextLabel(cs, " ");
        builder.append(NLS.bind((String)Messages.getString("ChangeSetLocationFactory.DEFAULT_CHANGESET_LABEL"), (Object[])new Object[]{componentName, comment, whoName, format.format(when)}));
        return builder.toString();
    }

    public static String getFullContextLabel(IChangeSet changeSet) {
        if (changeSet == null || changeSet.getComment().length() == 0) {
            return Messages.getString("ChangeSetLocationFactory.NO_COMMENT_LABEL");
        }
        return changeSet.getComment().trim();
    }

    public static String getFullContextLabel(IChangeSet changeSet, String lineEnding) {
        String comment = ChangeSetLocationFactory.getFullContextLabel(changeSet);
        if (lineEnding != null) {
            return ChangeSetLocationFactory.replaceLineEnding(comment, lineEnding);
        }
        return comment;
    }

    public static String replaceLineEnding(String original, String lineEnding) {
        return original.replace("\r\n", lineEnding).replace("\r", lineEnding).replace("\n", lineEnding);
    }
}

