/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal.util;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.internal.ModelPlugin;
import com.ibm.team.workitem.client.internal.util.AuditableBatchResolver;
import com.ibm.team.workitem.client.internal.util.Messages;
import com.ibm.team.workitem.common.internal.model.SetAttributeType;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.internal.workflow.WorkflowManager;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.ListChangeDetails;
import com.ibm.team.workitem.common.model.ReferencesChangeDetails;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemEventResolver
implements IWorkItemListener {
    public static final String BUILT_IN_ATTRIBUTES_PROPERTY = String.valueOf(WorkItemEventResolver.class.getName()) + "builtInAttributes";
    public static final String WORKFLOW_INFO_PROPERTY = String.valueOf(WorkItemEventResolver.class.getName()) + "workflowInfo";
    private Object fLock = new Object();
    private List<InternalEvent> fQueue = new ArrayList<InternalEvent>();
    private Job fJob;
    private IWorkItemListener fListener;
    private IWorkItemHandle fWorkItemHandle;

    public WorkItemEventResolver(IWorkItemListener listener) {
        this.fListener = listener;
    }

    public WorkItemEventResolver(IWorkItemListener listener, IWorkItemHandle workitem) {
        this.fListener = listener;
        this.fWorkItemHandle = workitem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void workItemAttributeChanged(WorkItemChangeEvent event) {
        if (this.fWorkItemHandle != null && !event.affects(this.fWorkItemHandle)) {
            return;
        }
        Object object = this.fLock;
        synchronized (object) {
            this.fQueue.add(new InternalEvent(event, false));
            this.ensureBackgroundJobRuns();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        if (this.fWorkItemHandle != null && !event.affects(this.fWorkItemHandle)) {
            return;
        }
        Object object = this.fLock;
        synchronized (object) {
            this.fQueue.add(new InternalEvent(event, true));
            this.ensureBackgroundJobRuns();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureBackgroundJobRuns() {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fJob == null) {
                this.fJob = new InternalBackgroundJob();
                this.fJob.setSystem(true);
                this.fJob.schedule();
            }
        }
    }

    public static ItemProfile<?> getRequiredProfile(IItemType itemType) {
        if (itemType == IWorkItem.ITEM_TYPE) {
            return IWorkItem.SMALL_PROFILE.createExtension(new String[]{IWorkItem.STATE_PROPERTY, IWorkItem.WORKFLOW_SURROGATE_PROPERTY});
        }
        if (itemType == IAttachment.ITEM_TYPE) {
            return IAttachment.DEFAULT_PROFILE;
        }
        if (itemType.getName().equals("BuildResult")) {
            return ItemProfile.createProfile((IItemType)itemType, WorkItemEventResolver.filterUnknown(itemType, new String[]{"label", "buildDefinitionId", "buildStatus"}));
        }
        return ItemProfile.createFullProfile((IItemType)itemType);
    }

    private static Collection<String> filterUnknown(IItemType itemType, String[] properties) {
        Collection allProperties = AuditablesHelper.allProperties((IItemType)itemType);
        ArrayList<String> filtered = new ArrayList<String>();
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            if (allProperties.contains(property)) {
                filtered.add(property);
            }
            ++n2;
        }
        return filtered;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalBackgroundJob
    extends FoundationJob {
        public InternalBackgroundJob() {
            super(Messages.WorkItemEventResolver_NAME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus runProtected(IProgressMonitor monitor) {
            block18: {
                try {
                    try {
                        while (!this.backgroundJobDone()) {
                            List<InternalEvent> events = this.dequeueEvents();
                            while (!events.isEmpty()) {
                                for (InternalEvent event : events) {
                                    WorkItemChangeEvent resolved = this.resolve(event.getEvent(), monitor);
                                    if (event.isDependencyChange()) {
                                        WorkItemEventResolver.this.fListener.workItemAttributeDependencyChanged(resolved);
                                        continue;
                                    }
                                    WorkItemEventResolver.this.fListener.workItemAttributeChanged(resolved);
                                }
                                events = this.dequeueEvents();
                            }
                        }
                    }
                    catch (TeamRepositoryException x) {
                        ModelPlugin.log("Exception resolving event handles", (Exception)((Object)x));
                        Object object = WorkItemEventResolver.this.fLock;
                        synchronized (object) {
                            WorkItemEventResolver.this.fJob = null;
                            break block18;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object object = WorkItemEventResolver.this.fLock;
                    synchronized (object) {
                        WorkItemEventResolver.this.fJob = null;
                    }
                    throw throwable;
                }
                Object object = WorkItemEventResolver.this.fLock;
                synchronized (object) {
                    WorkItemEventResolver.this.fJob = null;
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<InternalEvent> dequeueEvents() {
            Object object = WorkItemEventResolver.this.fLock;
            synchronized (object) {
                if (WorkItemEventResolver.this.fQueue.isEmpty()) {
                    return Collections.emptyList();
                }
                List queue = WorkItemEventResolver.this.fQueue;
                WorkItemEventResolver.this.fQueue = new ArrayList();
                return queue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean backgroundJobDone() {
            Object object = WorkItemEventResolver.this.fLock;
            synchronized (object) {
                boolean done = WorkItemEventResolver.this.fQueue.isEmpty();
                if (done) {
                    WorkItemEventResolver.this.fJob = null;
                }
                return done;
            }
        }

        private WorkItemChangeEvent resolve(WorkItemChangeEvent event, IProgressMonitor monitor) throws TeamRepositoryException {
            IWorkItem workItem = event.getWorkItem();
            ITeamRepository teamRepository = (ITeamRepository)workItem.getOrigin();
            IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            IProjectAreaHandle projectArea = !workItem.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY) ? ((IWorkItem)auditableClient.resolveAuditable((IAuditableHandle)workItem, IWorkItem.SMALL_PROFILE, monitor)).getProjectArea() : workItem.getProjectArea();
            WorkItemChangeEvent resolved = new WorkItemChangeEvent(workItem);
            String[] stringArray = event.getChangedAttributes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                ListChangeDetails listDetails;
                AuditableBatchResolver resolver;
                ItemHandleAwareHashSet set;
                String identifier = stringArray[n2];
                Object details = event.getAttributeChangeDetails(identifier);
                ChangeDetails changeDetails = event.getAttributeChangeDetails(identifier, ChangeDetails.class);
                if (changeDetails != null) {
                    ChangeDetails attributeDetails;
                    Object oldValue = changeDetails.getOldValue();
                    Object newValue = changeDetails.getNewValue();
                    IAttribute attribute = workItemClient.findAttribute(projectArea, identifier, monitor);
                    if (attribute != null && AttributeTypes.isEnumerationAttributeType((String)attribute.getAttributeType())) {
                        ILiteral newLiteral;
                        IEnumeration enumeration = workItemClient.resolveEnumeration((IAttributeHandle)attribute, monitor);
                        ILiteral oldLiteral = oldValue != null ? enumeration.findEnumerationLiteral((Identifier)oldValue) : null;
                        ILiteral iLiteral = newLiteral = newValue != null ? enumeration.findEnumerationLiteral((Identifier)newValue) : null;
                        if (oldLiteral != null || newLiteral != null) {
                            details = new ChangeDetails(oldLiteral != null ? oldLiteral : oldValue, newLiteral != null ? newLiteral : newValue);
                        }
                    } else {
                        set = new ItemHandleAwareHashSet();
                        if (oldValue instanceof IAuditableHandle) {
                            set.add((IAuditableHandle)oldValue);
                        }
                        if (newValue instanceof IAuditableHandle) {
                            set.add((IAuditableHandle)newValue);
                        }
                        if (!set.isEmpty()) {
                            resolver = this.resolve(projectArea, identifier, (Set<IAuditableHandle>)set, monitor);
                            details = new ChangeDetails(this.get(resolver, oldValue), this.get(resolver, newValue));
                        }
                    }
                    if (IWorkItem.PROJECT_AREA_PROPERTY.equals(identifier)) {
                        List oldHandles = workItemClient.findBuiltInAttributes((IProjectAreaHandle)oldValue, monitor);
                        List oldAttributes = auditableClient.resolveAuditables(oldHandles, IAttribute.FULL_PROFILE, monitor);
                        List newHandles = workItemClient.findBuiltInAttributes((IProjectAreaHandle)newValue, monitor);
                        List newAttributes = auditableClient.resolveAuditables(newHandles, IAttribute.FULL_PROFILE, monitor);
                        attributeDetails = new ListChangeDetails(newAttributes, oldAttributes);
                        resolved.addAttributeDetails(BUILT_IN_ATTRIBUTES_PROPERTY, new String[0], (IAdaptable)attributeDetails, event.getAttributeChangeKind(identifier));
                    } else if (IWorkItem.TYPE_PROPERTY.equals(identifier)) {
                        IWorkItemType newType;
                        IWorkItemType oldType = oldValue != null ? workItemClient.findWorkItemType(projectArea, (String)oldValue, monitor) : null;
                        IWorkItemType iWorkItemType = newType = newValue != null ? workItemClient.findWorkItemType(projectArea, (String)newValue, monitor) : null;
                        if (oldType == null || newType == null || !oldType.getCategory().equals(newType.getCategory())) {
                            IWorkflowInfo newWorkflowInfo = workItemClient.findWorkflowInfo(workItem, monitor);
                            IWorkflowInfo oldWorkflowInfo = null;
                            if (oldType != null) {
                                WorkflowManager workflowManager = (WorkflowManager)workItemClient.getWorkflowManager();
                                String workflowId = workflowManager.getWorkflowIdForCategory(projectArea, oldType.getCategory(), false, monitor);
                                oldWorkflowInfo = workflowManager.getWorkflowInfo(projectArea, workflowId, true, monitor);
                            }
                            attributeDetails = new ChangeDetails(oldWorkflowInfo, (Object)newWorkflowInfo);
                            resolved.addAttributeDetails(WORKFLOW_INFO_PROPERTY, new String[0], (IAdaptable)attributeDetails, event.getAttributeChangeKind(identifier));
                        }
                    }
                }
                if ((listDetails = event.getAttributeChangeDetails(identifier, ListChangeDetails.class)) == null) {
                    listDetails = (ListChangeDetails)event.getAttributeChangeDetails(identifier, ReferencesChangeDetails.class);
                }
                if (listDetails != null) {
                    List added = listDetails.getAdded();
                    List removed = listDetails.getRemoved();
                    set = new ItemHandleAwareHashSet();
                    for (Object object : added) {
                        if (object instanceof IAuditableHandle) {
                            set.add((IAuditableHandle)object);
                            continue;
                        }
                        if (!(object instanceof IItemReference) || !(((IItemReference)object).getReferencedItem() instanceof IAuditableHandle)) continue;
                        set.add((IAuditableHandle)((IItemReference)object).getReferencedItem());
                    }
                    for (Object object : removed) {
                        if (!(object instanceof IAuditableHandle)) continue;
                        set.add((IAuditableHandle)object);
                    }
                    if (!set.isEmpty()) {
                        resolver = this.resolve(projectArea, identifier, (Set<IAuditableHandle>)set, monitor);
                        details = listDetails instanceof ReferencesChangeDetails ? new ReferencesChangeDetails(this.get(resolver, added), this.get(resolver, removed)) : new ListChangeDetails(this.get(resolver, added), this.get(resolver, removed));
                    }
                }
                resolved.addAttributeDetails(identifier, event.getDependentAttributes(identifier), (IAdaptable)details, event.getAttributeChangeKind(identifier));
                ++n2;
            }
            return resolved;
        }

        private AuditableBatchResolver resolve(IProjectAreaHandle projectArea, String identifier, Set<IAuditableHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
            AttributeType type;
            ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            ItemProfile profile = null;
            IAttribute attribute = workItemClient.findAttribute(projectArea, identifier, monitor);
            if (attribute != null && (type = AttributeTypes.getAttributeType((String)attribute.getAttributeType())) instanceof SetAttributeType) {
                profile = ((SetAttributeType)type).getDefaultProfile();
            }
            AuditableBatchResolver resolver = new AuditableBatchResolver(workItemClient);
            for (IAuditableHandle handle : handles) {
                if (profile != null && profile.getItemType().equals(handle.getItemType())) {
                    resolver.add(profile, handle);
                    continue;
                }
                resolver.add(WorkItemEventResolver.getRequiredProfile(handle.getItemType()), handle);
            }
            resolver.resolve(monitor);
            return resolver;
        }

        private List<Object> get(AuditableBatchResolver resolver, List<?> list) {
            ArrayList<Object> resolved = new ArrayList<Object>();
            for (Object object : list) {
                resolved.add(this.get(resolver, object));
            }
            return resolved;
        }

        private Object get(AuditableBatchResolver resolver, Object value) {
            return value instanceof IAuditableHandle ? resolver.get((IAuditableHandle)value) : value;
        }
    }

    private static class InternalEvent {
        private WorkItemChangeEvent fEvent;
        private boolean fDependencyChange;

        public InternalEvent(WorkItemChangeEvent event, boolean dependencyChange) {
            this.fEvent = event;
            this.fDependencyChange = dependencyChange;
        }

        public WorkItemChangeEvent getEvent() {
            return this.fEvent;
        }

        public boolean isDependencyChange() {
            return this.fDependencyChange;
        }
    }
}

