/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.TextLinkDetector;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.internal.Messages;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.linkdetection.AttachmentLinkDetector;
import com.ibm.team.workitem.common.internal.linkdetection.WorkItemTextLinkDetector;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientLinkDetectorHelper
implements WorkItemTextLinkDetector.ILinkDetectorHelper {
    private static ClientLinkDetectorHelper fgInstance;
    private static final HashMap<ITeamRepository, List<String>> fgRepositoryToTypes;
    private static final HashMap<ITeamRepository, Set<String>> fgRepositoryToAttachments;
    private static final HashMap<ITeamRepository, Set<String>> fgRepositoryToComments;
    private static TypeUpdater fgTypeUpdater;
    private ITeamRepository fTeamRepository;
    private FallBackConnectionStateManager fgFallBackConnectionStateManager = new FallBackConnectionStateManager();
    private IConnectionStateManager fgConnectionStateManager;

    static {
        fgRepositoryToTypes = new HashMap();
        fgRepositoryToAttachments = new HashMap();
        fgRepositoryToComments = new HashMap();
        fgTypeUpdater = new TypeUpdater(Messages.ClientLinkDetectorHelper_UPDATE_WORK_ITEM_TYPES);
    }

    public static ClientLinkDetectorHelper getInstance() {
        if (fgInstance == null) {
            fgInstance = new ClientLinkDetectorHelper();
        }
        return fgInstance;
    }

    private ClientLinkDetectorHelper() {
    }

    public IProjectAreaHandle findLinkProjectArea(Matcher matcher, TextLinkDetector linkDetector) {
        String name = matcher.group(6);
        IProjectAreaHandle result = null;
        if (name != null) {
            for (IProjectAreaHandle projectArea : this.getProjectAreas()) {
                if (!name.equalsIgnoreCase(this.getProjectAreaName(projectArea)) || !projectArea.getOrigin().equals(this.getTeamRepository(linkDetector))) continue;
                return projectArea;
            }
        }
        return result;
    }

    public Collection<String> getAllTypeNames() {
        return ClientLinkDetectorHelper.getTypeNames();
    }

    public Collection<String> getAttachmentNames() {
        return ClientLinkDetectorHelper.getAllAttachmentNames();
    }

    public Collection<String> getComments() {
        return ClientLinkDetectorHelper.getAllComments();
    }

    public IAuditableCommon getAuditableCommon(IProjectAreaHandle projectArea) {
        for (IAuditableCommon au : this.getAuditableCommons()) {
            if (!au.getRepositoryURI().equals(((ITeamRepository)projectArea.getOrigin()).getRepositoryURI())) continue;
            return au;
        }
        return null;
    }

    public List<IAuditableCommon> getAuditableCommons() {
        ArrayList<IAuditableCommon> commons = new ArrayList<IAuditableCommon>();
        ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = iTeamRepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repo = iTeamRepositoryArray[n2];
            commons.add((IAuditableClient)repo.getClientLibrary(IAuditableClient.class));
            ++n2;
        }
        return commons;
    }

    public String getProjectAreaName(IProjectAreaHandle projectArea) {
        return fgInstance.getManager().getProjectAreaName(projectArea);
    }

    public List<IProjectAreaHandle> getProjectAreas() {
        return new ArrayList<IProjectAreaHandle>(fgInstance.getManager().getConnectedProjectAreas(null));
    }

    private ITeamRepository getTeamRepository(TextLinkDetector linkDetector) {
        if (this.fTeamRepository == null && linkDetector.getBaseURI() != null) {
            this.fTeamRepository = URIService.findTeamRepository(linkDetector.getBaseURI());
        }
        return this.fTeamRepository;
    }

    private static Collection<String> getTypeNames() {
        HashSet<String> allTypes = new HashSet<String>();
        for (List<String> types : fgRepositoryToTypes.values()) {
            allTypes.addAll(types);
        }
        return allTypes;
    }

    private static Set<String> getAllAttachmentNames() {
        HashSet<String> allAttachments = new HashSet<String>();
        for (Set<String> attachments : fgRepositoryToAttachments.values()) {
            allAttachments.addAll(attachments);
        }
        return allAttachments;
    }

    private static Set<String> getAllComments() {
        HashSet<String> allComments = new HashSet<String>();
        for (Set<String> comments : fgRepositoryToComments.values()) {
            allComments.addAll(comments);
        }
        return allComments;
    }

    public void cleanUp(TextLinkDetector linkDetector) {
        ClientLinkDetectorHelper.fgTypeUpdater.removeDetector(linkDetector);
    }

    public void initialize(TextLinkDetector linkDetector) {
        ClientLinkDetectorHelper.fgTypeUpdater.addDetector(linkDetector);
    }

    public void setConnectionStateManager(IConnectionStateManager manager) {
        this.fgConnectionStateManager = manager;
        ClientLinkDetectorHelper.fgTypeUpdater.initializeAllRepositories();
    }

    private IConnectionStateManager getManager() {
        if (this.fgConnectionStateManager == null) {
            return this.fgFallBackConnectionStateManager;
        }
        return this.fgConnectionStateManager;
    }

    public void connectionEventOccurred(ITeamRepository repository) {
        ClientLinkDetectorHelper.fgTypeUpdater.updateListener(repository);
        ClientLinkDetectorHelper.fgTypeUpdater.updateTypes(repository);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FallBackConnectionStateManager
    implements IConnectionStateManager {
        private static HashMap<ITeamRepository, List<? extends IProjectAreaHandle>> fgProjectAreas = new HashMap();
        private static HashMap<UUID, String> fgProjectAreaNames = new HashMap();
        private static Object fgPALock = new Object();
        private static RepositoryListener fgRepoListener = new RepositoryListener();

        static {
            TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)fgRepoListener);
        }

        private FallBackConnectionStateManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<? extends IProjectAreaHandle> getConnectedProjectAreas(ITeamRepository repository) {
            List<Object> result;
            if (repository == null) {
                ArrayList pas = new ArrayList();
                Object object = fgPALock;
                synchronized (object) {
                    for (List<? extends IProjectAreaHandle> value : fgProjectAreas.values()) {
                        pas.addAll(value);
                    }
                }
                result = pas;
            } else {
                Object object = fgPALock;
                synchronized (object) {
                    List<? extends IProjectAreaHandle> pas = fgProjectAreas.get(repository);
                    result = pas == null ? Collections.emptyList() : pas;
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<? extends IProjectAreaHandle> getConnectedProjectAreas(ITeamRepository repository, IProgressMonitor monitor) {
            List<? extends IProjectAreaHandle> result;
            if (repository == null) {
                ArrayList<? extends IProjectAreaHandle> pas = new ArrayList<IProjectAreaHandle>();
                Object object = fgPALock;
                synchronized (object) {
                    for (List<? extends IProjectAreaHandle> value : fgProjectAreas.values()) {
                        pas.addAll(value);
                    }
                }
                result = pas;
            } else {
                List<? extends IProjectAreaHandle> pas;
                try {
                    pas = FallBackConnectionStateManager.getProjectAreas(repository, monitor);
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    pas = this.getConnectedProjectAreas(repository);
                }
                Object object = fgPALock;
                synchronized (object) {
                    fgProjectAreas.put(repository, pas);
                }
                result = pas;
            }
            return result;
        }

        private static void initialize() {
            FoundationJob job = new FoundationJob(Messages.ClientLinkDetectorHelper_RETRIEVE_PROJECT_AREAS){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    HashMap<ITeamRepository, List> newValues = new HashMap<ITeamRepository, List>();
                    ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
                    int n = iTeamRepositoryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITeamRepository repo = iTeamRepositoryArray[n2];
                        try {
                            newValues.put(repo, FallBackConnectionStateManager.getProjectAreas(repo, monitor));
                        }
                        catch (TeamRepositoryException teamRepositoryException) {}
                        ++n2;
                    }
                    Object object = fgPALock;
                    synchronized (object) {
                        fgProjectAreas = newValues;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }

        private static List<? extends IProjectAreaHandle> getProjectAreas(ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
            IWorkItemClient workItemClient = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
            String nameProperty = ProcessCommon.getPropertyName(IProjectArea.class, (String)"name");
            ItemProfile profile = ItemProfile.createProfile((IItemType)IProjectArea.ITEM_TYPE, (String[])new String[]{nameProperty});
            List allAreas = workItemClient.getAuditableCommon().findAuditables(profile, monitor);
            for (IProjectArea pa : allAreas) {
                fgProjectAreaNames.put(pa.getItemId(), pa.getName());
            }
            return allAreas;
        }

        @Override
        public String getProjectAreaName(IProjectAreaHandle handle) {
            String name = fgProjectAreaNames.get(handle.getItemId());
            if (name == null) {
                return "";
            }
            return name;
        }

        private static class RepositoryListener
        implements ITeamRepositoryService.IRepositoryServiceListener {
            private RepositoryListener() {
            }

            public void addedRepository(ITeamRepository repository) {
                FallBackConnectionStateManager.initialize();
                if (ClientLinkDetectorHelper.getInstance().getManager() instanceof FallBackConnectionStateManager) {
                    ClientLinkDetectorHelper.getInstance().connectionEventOccurred(repository);
                }
            }

            public void removedRepository(ITeamRepository repository) {
                FallBackConnectionStateManager.initialize();
                if (ClientLinkDetectorHelper.getInstance().getManager() instanceof FallBackConnectionStateManager) {
                    ClientLinkDetectorHelper.getInstance().connectionEventOccurred(repository);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IConnectionStateManager {
        public List<? extends IProjectAreaHandle> getConnectedProjectAreas(ITeamRepository var1);

        public List<? extends IProjectAreaHandle> getConnectedProjectAreas(ITeamRepository var1, IProgressMonitor var2);

        public String getProjectAreaName(IProjectAreaHandle var1);
    }

    private static class ProjectAreaListener
    implements ISharedItemChangeListener {
        private ProjectAreaListener() {
        }

        public void itemsChanged(List events) {
            HashSet<ITeamRepository> affectedRepositories = new HashSet<ITeamRepository>();
            for (ISharedItemChangeEvent shEvent : events) {
                if (!(shEvent.getSharedItem() instanceof IProjectArea)) continue;
                affectedRepositories.add((ITeamRepository)((IProjectArea)shEvent.getSharedItem()).getOrigin());
            }
            for (ITeamRepository repo : affectedRepositories) {
                fgTypeUpdater.updateTypes(repo);
            }
        }
    }

    private static class TypeUpdater
    extends FoundationJob {
        private final List<ITeamRepository> fRepositoriesToProcess = new ArrayList<ITeamRepository>();
        private final List<TextLinkDetector> fDetectors = new ArrayList<TextLinkDetector>();
        private final ProjectAreaListener fProjectListener = new ProjectAreaListener();

        private TypeUpdater(String name) {
            super(name);
            this.setSystem(true);
            ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            int n = iTeamRepositoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository repo = iTeamRepositoryArray[n2];
                repo.itemManager().addItemChangeListener(IProjectArea.ITEM_TYPE, (ISharedItemChangeListener)this.fProjectListener);
                ++n2;
            }
            this.initializeAllRepositories();
        }

        private void updateListener(ITeamRepository repository) {
            if (!fgRepositoryToTypes.containsKey(repository)) {
                repository.itemManager().addItemChangeListener(IProjectArea.ITEM_TYPE, (ISharedItemChangeListener)this.fProjectListener);
            }
        }

        private void addDetector(TextLinkDetector detector) {
            this.fDetectors.add(detector);
        }

        private void removeDetector(TextLinkDetector detector) {
            this.fDetectors.remove(detector);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateTypes(ITeamRepository teamRepository) {
            List<ITeamRepository> list = this.fRepositoriesToProcess;
            synchronized (list) {
                this.fRepositoriesToProcess.add(teamRepository);
            }
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ITeamRepository getRepository() {
            ITeamRepository repository = null;
            List<ITeamRepository> list = this.fRepositoriesToProcess;
            synchronized (list) {
                if (this.fRepositoriesToProcess.size() > 0) {
                    repository = this.fRepositoriesToProcess.get(0);
                    this.fRepositoriesToProcess.remove(0);
                }
            }
            return repository;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeAllRepositories() {
            fgRepositoryToTypes.clear();
            List<ITeamRepository> list = this.fRepositoriesToProcess;
            synchronized (list) {
                this.fRepositoriesToProcess.clear();
                this.fRepositoriesToProcess.addAll((Collection<ITeamRepository>)Arrays.asList(TeamPlatform.getTeamRepositoryService().getTeamRepositories()));
            }
            this.schedule();
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            ITeamRepository repository = this.getRepository();
            while (repository != null) {
                fgRepositoryToTypes.remove(repository);
                fgRepositoryToAttachments.remove(repository);
                fgRepositoryToComments.remove(repository);
                if (repository.loggedIn()) {
                    try {
                        ArrayList<String> typeNames = new ArrayList<String>();
                        HashSet<String> attachments = new HashSet<String>();
                        HashSet<String> comments = new HashSet<String>();
                        IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
                        for (IProjectAreaHandle iProjectAreaHandle : fgInstance.getManager().getConnectedProjectAreas(repository, monitor)) {
                            List workItemTypes = workItemClient.findWorkItemTypes(iProjectAreaHandle, monitor);
                            for (IWorkItemType workItemType : workItemTypes) {
                                typeNames.add(workItemType.getDisplayName().toLowerCase());
                                List aliases = workItemType.getAliases();
                                for (String alias : aliases) {
                                    typeNames.add(alias.toLowerCase());
                                }
                            }
                            LocalizationContext projectAreaContext = LocalizationContext.createProjectAreaContext((IAuditableCommon)workItemClient.getAuditableCommon(), (IProjectAreaHandle)iProjectAreaHandle, (IProgressMonitor)monitor);
                            String attachment = com.ibm.team.workitem.common.internal.linkdetection.Messages.getString((LocalizationContext)projectAreaContext, (String)"AttachmentLinkDetector.ATTACHMENT");
                            attachments.add(attachment.toLowerCase());
                            String comment = com.ibm.team.workitem.common.internal.linkdetection.Messages.getString((LocalizationContext)projectAreaContext, (String)"WorkItemTextLinkDetector.COMMENT");
                            comments.add(comment.toLowerCase());
                        }
                        fgRepositoryToTypes.put(repository, typeNames);
                        fgRepositoryToAttachments.put(repository, attachments);
                        fgRepositoryToComments.put(repository, comments);
                    }
                    catch (TeamRepositoryException e) {
                        WorkItemCommonPlugin.log((String)("Could not add Work Item types for Projects on Repository " + repository.getName()), (Exception)((Object)e));
                    }
                } else {
                    repository.itemManager().removeItemChangeListener(IProjectArea.ITEM_TYPE, (ISharedItemChangeListener)this.fProjectListener);
                }
                repository = this.getRepository();
            }
            WorkItemTextLinkDetector.invalidatePattern();
            AttachmentLinkDetector.invalidatePattern();
            for (TextLinkDetector detector : this.fDetectors) {
                detector.linkDetectorChanged();
            }
            return Status.OK_STATUS;
        }
    }
}

