/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.util;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.service.IExternalUserRegistryService;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.util.DefaultLoginHandler;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.WorkItemProcessUtils;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaConfiguration;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaImporter;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaLogStatusMonitor;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.importer.ITestBugRetrievalStrategy;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.AttachmentData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryCreationUtil {
    private static final UUID ADMIN_UUID = UUID.valueOf((String)"_KGRY4CFWEdq-WY5y7lROQw");
    private static final UUID GUEST_UUID = UUID.valueOf((String)"_OIi3MCDNEdu1A6FdF3RHyQ");

    public IProjectArea setUp(List<URL> bugs, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = TeamPlatform.getTeamRepositoryService().getTeamRepository("local://host/jazz");
        teamRepository.setName("Local Repository");
        TeamPlatform.getTeamRepositoryService().addTeamRepository(teamRepository);
        teamRepository.registerLoginHandler((ITeamRepository.ILoginHandler)new DefaultLoginHandler());
        teamRepository.login(monitor);
        IProjectArea projectArea = this.setupProcess(teamRepository, monitor);
        ITeamAreaHandle teamArea = this.findTeamArea(teamRepository, projectArea, "default", monitor);
        this.importBugs(teamArea, bugs, monitor);
        this.setupProcessAreas(teamRepository, monitor);
        this.setupContributors(teamRepository, monitor);
        teamRepository.registerLoginHandler(null);
        return projectArea;
    }

    private void setupContributors(ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        IExternalUserRegistryService externalUserRegistryService = ((TeamRepository)teamRepository).getExternalUserRegistryService();
        List contributors = teamRepository.contributorManager().fetchAllContributors(monitor);
        for (IContributor contributor : contributors) {
            if (this.isAdmin((IContributorHandle)contributor) || this.isGuest((IContributorHandle)contributor)) continue;
            externalUserRegistryService.addToGroup(contributor.getUserId(), "JazzUsers");
        }
        this.createContributor(teamRepository, "Tracy Nopermission", "tracy_nopermission@example.team.ibm.com", null, monitor);
        this.createContributor(teamRepository, "Tracy Reader", "tracy_reader@example.team.ibm.com", "JazzGuests", monitor);
        this.createContributor(teamRepository, "Tracy Writer", "tracy_writer@example.team.ibm.com", "JazzUsers", monitor);
        this.createContributor(teamRepository, "Tracy Admin", "tracy_admin@example.team.ibm.com", "JazzAdmins", monitor);
        this.fillTeams(teamRepository, monitor);
    }

    private void fillTeams(ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        List teamAreas = auditableClient.findAuditables(ItemProfile.createFullProfile((IItemType)ITeamArea.ITEM_TYPE), monitor);
        for (ITeamArea teamArea : teamAreas) {
            if (teamArea.getMembers().length != 0) continue;
            teamArea = (ITeamArea)teamArea.getWorkingCopy();
            teamArea.addMember(this.createContributor(teamRepository, "Tracy " + teamArea.getName() + " 1", "tracy_" + teamArea.getName().toLowerCase() + "_1@example.team.ibm.com", "JazzUsers", monitor));
            teamArea.addMember(this.createContributor(teamRepository, "Tracy " + teamArea.getName() + " 2", "tracy_" + teamArea.getName().toLowerCase() + "_2@example.team.ibm.com", "JazzUsers", monitor));
            auditableClient.saveProcessItem((IProcessItem)teamArea, monitor);
        }
    }

    private IContributorHandle createContributor(ITeamRepository teamRepository, String name, String email, String role, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            return teamRepository.contributorManager().fetchContributorByUserId(name, monitor);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            IContributor contributor = (IContributor)IContributor.ITEM_TYPE.createItem((Object)teamRepository);
            contributor.setName(name);
            contributor.setUserId(name);
            contributor.setEmailAddress(email);
            contributor = teamRepository.contributorManager().saveContributor(contributor, monitor);
            IExternalUserRegistryService externalUserRegistryService = ((TeamRepository)teamRepository).getExternalUserRegistryService();
            externalUserRegistryService.addExternalUser(name, "password", name, email, new String[0]);
            if (role != null) {
                externalUserRegistryService.addToGroup(contributor.getUserId(), role);
            }
            return (IContributorHandle)contributor.getItemHandle();
        }
    }

    private IProjectArea setupProcess(ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        WorkItemProcessUtils.deploySampleProcessDefinition((IAuditableCommon)auditableClient, (IProgressMonitor)monitor);
        WorkItemProcessUtils.setupProcessAreas((IAuditableCommon)auditableClient, (String)"com.ibm.team.workitem.process.sample", (String)"Test Project 1", (String)"Test Project 1", (String)"default", (IProgressMonitor)monitor);
        IProjectArea projectArea = this.setupProcessAreas(teamRepository, monitor);
        WorkItemProcessUtils.setupProcessAreas((IAuditableCommon)auditableClient, (String)"com.ibm.team.workitem.process.sample", (String)"Test Project 2", (String)"Test Project 2", (String)"default", (IProgressMonitor)monitor);
        return projectArea;
    }

    private IProjectArea setupProcessAreas(ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        return WorkItemProcessUtils.setupProcessAreas((IAuditableCommon)auditableClient, (String)"com.ibm.team.workitem.process.sample", (String)"Eclipse Project", (String)"Eclipse Project", (String)"default", (IProgressMonitor)monitor);
    }

    public void importBugs(ITeamAreaHandle teamAreaHandle, List<URL> bugs, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = (ITeamRepository)teamAreaHandle.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
        try {
            ITeamArea teamArea = (ITeamArea)auditableClient.resolveAuditable((IAuditableHandle)teamAreaHandle, ItemProfile.createFullProfile((IItemType)teamAreaHandle.getItemType()), monitor);
            BugzillaConfiguration bugzillaConfiguration = new BugzillaConfiguration(teamArea.getProjectArea());
            bugzillaConfiguration.setAssignRandomDuration(true);
            IIteration projectePhase = this.getCurrentProjectPhase(teamArea, monitor);
            bugzillaConfiguration.setProjectArea(teamArea.getProjectArea());
            bugzillaConfiguration.setDevelopmentLine(auditableClient.getDevelopmentLine((ITeamAreaHandle)teamArea, monitor));
            bugzillaConfiguration.setProjectPhase(projectePhase);
            BugzillaImporter fImporter = new BugzillaImporter(bugzillaConfiguration);
            IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
            int i = 0;
            while (i < bugs.size()) {
                String testData = BugzillaFileRetrieval.readTestData(bugs.get(i));
                IWorkItem item = new BugzillaFileRetrieval(testData, fImporter).getImportedWorkItem();
                if (monitor != null) {
                    monitor.subTask("Number of imported Bugs: " + String.valueOf(i + 1) + " of " + bugs.size());
                }
                if (item.isWorkingCopy()) {
                    workItemClient.saveWorkItem(item, null, null);
                }
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
        }
        catch (IOException x) {
            throw new TeamRepositoryException("Exception while reading data", (Throwable)x);
        }
        FeedManager.getDefault().loadNews();
    }

    private IIteration getCurrentProjectPhase(ITeamArea teamArea, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = (ITeamRepository)teamArea.getOrigin();
        IProcessItemService processService = (IProcessItemService)repository.getClientLibrary(IProcessItemService.class);
        IDevelopmentLine developmentLine = processService.getDevelopmentLine(teamArea, monitor);
        return RepositoryCreationUtil.getCurrentProjectPhase(developmentLine, monitor);
    }

    public static IIteration getCurrentProjectPhase(IDevelopmentLine developmentLine, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = (ITeamRepository)developmentLine.getOrigin();
        IProcessItemService processService = (IProcessItemService)repository.getClientLibrary(IProcessItemService.class);
        IIteration[] currentIterations = processService.getCurrentIterations((IDevelopmentLineHandle)developmentLine, monitor);
        if (currentIterations.length == 0) {
            return null;
        }
        return currentIterations[0];
    }

    public ITeamAreaHandle findTeamArea(ITeamRepository teamRepository, IProjectArea projectArea, String developmentLineId, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        List teamAreas = projectArea.getTeamAreas();
        for (ITeamAreaHandle teamArea : teamAreas) {
            IDevelopmentLine developmentLine = auditableClient.getDevelopmentLine(teamArea, monitor);
            if (developmentLine == null || !developmentLine.getId().equals(developmentLineId)) continue;
            return teamArea;
        }
        return null;
    }

    private boolean isGuest(IContributorHandle contributor) {
        return GUEST_UUID.equals((Object)contributor.getItemId());
    }

    private boolean isAdmin(IContributorHandle contributor) {
        return ADMIN_UUID.equals((Object)contributor.getItemId());
    }

    private static class BugzillaFileRetrieval
    implements ITestBugRetrievalStrategy {
        String fXml = null;
        AttachmentData[] fAttachments = null;
        IWorkItem fItem = null;
        private BugzillaImporter fImporter;

        public BugzillaFileRetrieval(String xml, AttachmentData[] attachments, BugzillaImporter importer) {
            this.fXml = xml;
            this.fAttachments = attachments;
            this.fImporter = importer;
        }

        public BugzillaFileRetrieval(String xml, BugzillaImporter importer) {
            this(xml, null, importer);
        }

        public String getXML(Integer id) throws BugzillaException {
            return this.fXml;
        }

        public AttachmentData[] getAttachments(Integer id, List attachmentinfo) throws BugzillaException {
            return this.fAttachments;
        }

        public int getNumberOfBugs() {
            return 1;
        }

        public Iterator getIterator() {
            ArrayList<Integer> nullList = new ArrayList<Integer>(1);
            nullList.add(new Integer(0));
            return nullList.iterator();
        }

        public IWorkItem getImportedWorkItem() {
            if (this.fItem == null) {
                BugzillaLogStatusMonitor statusMonitor = new BugzillaLogStatusMonitor();
                this.fImporter.doImport(this, statusMonitor, (IProgressMonitor)new NullProgressMonitor());
                Assert.isTrue((boolean)statusMonitor.getStatus().isOK());
            }
            return this.fItem;
        }

        public void handOverImportedWorkItem(IWorkItem item) {
            this.fItem = item;
        }

        public static String readTestData(URL url) throws IOException {
            return BugzillaFileRetrieval.readStream(url.openStream());
        }

        private static String readStream(InputStream in) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                int c;
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
            }
            finally {
                in.close();
            }
            return out.toString();
        }
    }
}

