/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.queries;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.internal.expression.QueryAttributeMigrationHelper;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.core.CoreFactory;
import com.ibm.team.workitem.rcp.core.QueryViews;
import com.ibm.team.workitem.rcp.core.internal.WorkItemRCPCorePlugin;
import com.ibm.team.workitem.rcp.core.internal.queries.Messages;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryView;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryViewColumn;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueriesManager {
    public static final UUID DEFAULT_VIEW_ID = UUID.valueOf((String)"_4EWGYGcjEdq9dPcKjjePWA");
    private WorkItemRCPCorePlugin fClientModelPlugin;
    private HashMap<String, Map<UUID, QueryView>> fViewsByRepository;

    public QueriesManager(WorkItemRCPCorePlugin clientModelPlugin) {
        this.fClientModelPlugin = clientModelPlugin;
        this.fViewsByRepository = new HashMap();
        try {
            QueryViews views = this.fClientModelPlugin.getModelRoot().getQueryViews();
            for (com.ibm.team.workitem.rcp.core.QueryView v : views.getInternalContents()) {
                ITeamRepository repository = this.findMatchingRepository(v.getRepository());
                if (repository == null) continue;
                List emfColumns = v.getColumns();
                QueryViewColumn[] columns = new QueryViewColumn[emfColumns.size()];
                Iterator ci = emfColumns.iterator();
                int i = 0;
                while (ci.hasNext()) {
                    com.ibm.team.workitem.rcp.core.QueryViewColumn emfColumn = (com.ibm.team.workitem.rcp.core.QueryViewColumn)ci.next();
                    String attributeIdentifier = QueryAttributeMigrationHelper.migrateAttribute((String)emfColumn.getAttribute());
                    columns[i] = new QueryViewColumn(attributeIdentifier, emfColumn.isVisible(), emfColumn.getSorting(), emfColumn.getSortOrder(), emfColumn.getWidth());
                    ++i;
                }
                QueryView view = new QueryView(repository, v.getUuid(), v.getName(), columns);
                view.setIdentifier(v.getId());
                this.add(view);
            }
        }
        catch (Exception e) {
            this.fClientModelPlugin.log("Could not load client model", e);
        }
    }

    public QueryView getView(ITeamRepository repository, UUID id) {
        this.init(repository);
        Map<UUID, QueryView> views = this.getViewsByRepository(repository);
        return views.get(id);
    }

    public QueryView getView(ITeamRepository repository, String identifier) {
        if (identifier == null || "".equals(identifier)) {
            return null;
        }
        QueryView[] queryViewArray = this.getViews(repository);
        int n = queryViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            QueryView view = queryViewArray[n2];
            if (identifier.equals(view.getIdentifier())) {
                return view;
            }
            ++n2;
        }
        return null;
    }

    private void init(ITeamRepository repository) {
        Map<UUID, QueryView> views = this.getViewsByRepository(repository);
        if (views == null) {
            views = new HashMap<UUID, QueryView>();
            this.fViewsByRepository.put(repository.getRepositoryURI(), views);
            QueryViewColumn[] columns = new QueryViewColumn[]{new QueryViewColumn(IWorkItem.TYPE_PROPERTY, true, 0, 0, -1), new QueryViewColumn(IWorkItem.ID_PROPERTY, true, 2, 1, -1), new QueryViewColumn(IWorkItem.STATE_PROPERTY, true, 0, 0, -1), new QueryViewColumn(IWorkItem.PRIORITY_PROPERTY, true, 0, 0, -1), new QueryViewColumn(IWorkItem.SEVERITY_PROPERTY, true, 0, 0, -1), new QueryViewColumn(IWorkItem.SUMMARY_PROPERTY, true, 0, 0, -1), new QueryViewColumn(IWorkItem.OWNER_PROPERTY, true, 0, 0, -1), new QueryViewColumn(IWorkItem.CREATOR_PROPERTY, true, 0, 0, -1)};
            QueryView defaultView = new QueryView(repository, DEFAULT_VIEW_ID, Messages.QueriesManager_DEFAULT, columns);
            this.add(defaultView);
        }
    }

    public QueryView[] getViews(ITeamRepository repository) {
        this.init(repository);
        Map<UUID, QueryView> views = this.getViewsByRepository(repository);
        return views.values().toArray(new QueryView[views.size()]);
    }

    public void add(QueryView view) {
        this.init(view.getTeamRepository());
        Map<UUID, QueryView> views = this.getViewsByRepository(view.getTeamRepository());
        views.put(view.getId(), view);
    }

    public void delete(QueryView view) {
        Map<UUID, QueryView> views = this.getViewsByRepository(view.getTeamRepository());
        if (views != null) {
            views.remove(view.getId());
        }
    }

    public void prepareStore() {
        List internalViewContents = this.fClientModelPlugin.getModelRoot().getQueryViews().getInternalContents();
        internalViewContents.clear();
        CoreFactory factory = CoreFactory.eINSTANCE;
        Iterator<Map<UUID, QueryView>> repositoryIterator = this.fViewsByRepository.values().iterator();
        while (repositoryIterator.hasNext()) {
            for (QueryView v : repositoryIterator.next().values()) {
                com.ibm.team.workitem.rcp.core.QueryView view = factory.createQueryView();
                view.setUuid(v.getId());
                view.setName(v.getName());
                view.setRepository(v.getTeamRepository().getRepositoryURI());
                view.setId(v.getIdentifier());
                QueryViewColumn[] columns = v.getColumns();
                int i = 0;
                while (i < columns.length) {
                    com.ibm.team.workitem.rcp.core.QueryViewColumn column = factory.createQueryViewColumn();
                    column.setAttribute(columns[i].getAttributeIdentifier());
                    column.setVisible(columns[i].isVisible());
                    column.setSorting(columns[i].getSorting());
                    column.setSortOrder(columns[i].getSortOrder());
                    column.setWidth(columns[i].getWidth());
                    view.getColumns().add(column);
                    ++i;
                }
                internalViewContents.add(view);
            }
        }
    }

    private ITeamRepository findMatchingRepository(String repositoryURI) {
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < repositories.length) {
            if (repositories[i].getRepositoryURI().equals(repositoryURI)) {
                return repositories[i];
            }
            ++i;
        }
        URI uri = this.getURI(repositoryURI);
        if (uri != null) {
            int i2 = 0;
            while (i2 < repositories.length) {
                URI repoURI = this.getURI(repositories[i2].getRepositoryURI());
                if (repoURI != null && repoURI.getHost().equals(uri.getHost()) && repoURI.getPort() == uri.getPort()) {
                    return repositories[i2];
                }
                ++i2;
            }
        }
        return null;
    }

    private URI getURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private Map<UUID, QueryView> getViewsByRepository(ITeamRepository repository) {
        Map<UUID, QueryView> entry = this.fViewsByRepository.get(repository.getRepositoryURI());
        if (entry == null) {
            entry = this.fViewsByRepository.get(this.getAlternateURI(repository.getRepositoryURI()));
        }
        return entry;
    }

    private String getAlternateURI(String uri) {
        if (uri.charAt(uri.length() - 1) == '/') {
            return uri.substring(0, uri.length() - 2);
        }
        return String.valueOf(uri) + "/";
    }

    public void wipe() {
        this.fViewsByRepository.clear();
    }
}

