/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.xml;

import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaConfiguration;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.http.Util;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class QueryURL {
    private final String queryString;

    public QueryURL(String queryString) {
        this.queryString = queryString;
    }

    public boolean equals(Object obj) {
        if (obj instanceof QueryURL) {
            return this.toUrlString().equals(((QueryURL)obj).toUrlString());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.toUrlString().hashCode();
    }

    public String toUrlString() {
        return this.queryString;
    }

    public final String getUrl(BugzillaConfiguration configuration) {
        return this.getUrlString(configuration);
    }

    protected String getUrlString(BugzillaConfiguration configuration) {
        String urlString = Util.appendPath(configuration.getBaseURL(), this.toUrlString());
        urlString = String.valueOf(urlString) + this.getXMLResultRequest();
        return urlString;
    }

    protected String getXMLResultRequest() {
        return "&format=rdf";
    }

    public boolean isNamedQuery() {
        return this.queryString.indexOf("cmdtype=runnamed") != -1;
    }

    public String getName() {
        if (this.isNamedQuery()) {
            String key = "namedcmd=";
            int start = this.queryString.indexOf(key);
            if (start != -1) {
                start += key.length();
            }
            String name = this.queryString.substring(start);
            try {
                return URLDecoder.decode(name, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return this.queryString;
    }
}

